/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.ext.oracle.ui.actions.CompileHandler;
import org.jkiss.dbeaver.ext.oracle.ui.internal.OracleUIMessages;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileLog;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ObjectCompilerLogViewer;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.utils.CommonUtils;

public class OracleCompilerDialog
extends BaseDialog {
    private static final Log log = Log.getLog(OracleCompilerDialog.class);
    private static final int COMPILE_ID = 1000;
    private static final int COMPILE_ALL_ID = 1001;
    private List<OracleSourceObject> compileUnits;
    private TableViewer unitTable;
    private ObjectCompilerLogViewer compileLog;

    public OracleCompilerDialog(Shell shell, List<OracleSourceObject> compileUnits) {
        super(shell, OracleUIMessages.views_oracle_compiler_dialog_title, null);
        this.compileUnits = compileUnits;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Composite unitsGroup = new Composite(composite, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 200;
        gd.verticalIndent = 0;
        gd.horizontalIndent = 0;
        unitsGroup.setLayoutData((Object)gd);
        unitsGroup.setLayout((Layout)new GridLayout(1, false));
        this.unitTable = new TableViewer(unitsGroup, 68354);
        Table table = this.unitTable.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        ViewerColumnController columnController = new ViewerColumnController("OracleCompilerDialog", (ColumnViewer)this.unitTable);
        columnController.addColumn(OracleUIMessages.views_oracle_compiler_dialog_column_name, null, 0, true, true, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DBSObject unit = (DBSObject)cell.getElement();
                DBNDatabaseNode node = DBNUtils.getNodeByObject((DBSObject)unit);
                if (node != null) {
                    cell.setText(node.getNodeDisplayName());
                    cell.setImage(DBeaverIcons.getImage((DBPImage)node.getNodeIconDefault()));
                } else {
                    cell.setText(unit.toString());
                }
            }
        });
        columnController.addColumn(OracleUIMessages.views_oracle_compiler_dialog_column_type, null, 0, true, true, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DBSObject unit = (DBSObject)cell.getElement();
                DBNDatabaseNode node = DBNUtils.getNodeByObject((DBSObject)unit);
                if (node != null) {
                    cell.setText(node.getNodeTypeLabel());
                } else {
                    cell.setText("???");
                }
            }
        });
        columnController.createColumns();
        this.unitTable.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            this.getButton(1000).setEnabled(!selection.isEmpty());
        });
        this.unitTable.addDoubleClickListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty()) {
                OracleSourceObject unit = (OracleSourceObject)selection.getFirstElement();
                NavigatorHandlerObjectOpen.openEntityEditor((DBSObject)unit);
            }
        });
        this.unitTable.setContentProvider((IContentProvider)new ListContentProvider());
        this.unitTable.setInput(this.compileUnits);
        Composite infoGroup = new Composite(composite, 0);
        gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 200;
        gd.verticalIndent = 0;
        gd.horizontalIndent = 0;
        infoGroup.setLayoutData((Object)gd);
        infoGroup.setLayout((Layout)new GridLayout(1, false));
        this.compileLog = new ObjectCompilerLogViewer(infoGroup, null, true);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1000, OracleUIMessages.views_oracle_compiler_dialog_button_compile, false).setEnabled(false);
        this.createButton(parent, 1001, OracleUIMessages.views_oracle_compiler_dialog_button_compile_all, true);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        List<OracleSourceObject> toCompile = buttonId == 1000 ? ((IStructuredSelection)this.unitTable.getSelection()).toList() : (buttonId == 1001 ? this.compileUnits : null);
        if (!CommonUtils.isEmpty(toCompile)) {
            try {
                UIUtils.runInProgressService(monitor -> this.performCompilation(monitor, toCompile));
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Compile error", null, e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void performCompilation(DBRProgressMonitor monitor, List<OracleSourceObject> units) {
        this.compileLog.layoutLog();
        for (OracleSourceObject unit : units) {
            if (monitor.isCanceled()) break;
            String message = NLS.bind((String)OracleUIMessages.views_oracle_compiler_dialog_message_compile_unit, (Object)unit.getSourceType().name(), (Object)unit.getName());
            this.compileLog.info(message);
            boolean success = false;
            try {
                success = CompileHandler.compileUnit(monitor, (DBCCompileLog)this.compileLog, unit);
            }
            catch (DBException e) {
                log.error((Object)"Compile error", (Throwable)e);
            }
            this.compileLog.info(!success ? OracleUIMessages.views_oracle_compiler_dialog_message_compilation_error : OracleUIMessages.views_oracle_compiler_dialog_message_compilation_success);
            this.compileLog.info("");
        }
    }
}

