/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredInputException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserDataPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.util.Iterable;

public class PGPSecretKeyRing
extends PGPKeyRing
implements Iterable<PGPSecretKey> {
    private static final Logger LOG = Logger.getLogger(PGPSecretKeyRing.class.getName());
    List<PGPSecretKey> keys;
    List<PGPPublicKey> extraPubKeys;

    private static List<PGPSecretKey> checkKeys(List<PGPSecretKey> list) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(list.size());
        for (int i = 0; i != list.size(); ++i) {
            PGPSecretKey pGPSecretKey = list.get(i);
            if (i == 0) {
                if (!pGPSecretKey.isMasterKey()) {
                    throw new IllegalArgumentException("key 0 must be a master key");
                }
            } else if (pGPSecretKey.isMasterKey()) {
                throw new IllegalArgumentException("key 0 can be only master key");
            }
            arrayList.add(pGPSecretKey);
        }
        return arrayList;
    }

    public PGPSecretKeyRing(List<PGPSecretKey> list) {
        this(PGPSecretKeyRing.checkKeys(list), new ArrayList<PGPPublicKey>());
    }

    private PGPSecretKeyRing(List<PGPSecretKey> list, List<PGPPublicKey> list2) {
        this.keys = list;
        this.extraPubKeys = list2;
    }

    public PGPSecretKeyRing(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    public PGPSecretKeyRing(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        this.keys = new ArrayList<PGPSecretKey>();
        this.extraPubKeys = new ArrayList<PGPPublicKey>();
        BCPGInputStream bCPGInputStream = BCPGInputStream.wrap(inputStream);
        int n = bCPGInputStream.skipMarkerAndPaddingPackets();
        if (n != 5 && n != 7) {
            throw new IOException("secret key ring doesn't start with secret key tag: tag 0x" + Integer.toHexString(n));
        }
        SecretKeyPacket secretKeyPacket = (SecretKeyPacket)bCPGInputStream.readPacket();
        while (bCPGInputStream.nextPacketTag() == 61) {
            bCPGInputStream.readPacket();
        }
        TrustPacket trustPacket = PGPSecretKeyRing.readOptionalTrustPacket(bCPGInputStream);
        List<PGPSignature> list = PGPSecretKeyRing.readSignaturesAndTrust(bCPGInputStream);
        ArrayList<UserDataPacket> arrayList = new ArrayList<UserDataPacket>();
        ArrayList<TrustPacket> arrayList2 = new ArrayList<TrustPacket>();
        ArrayList<List<PGPSignature>> arrayList3 = new ArrayList<List<PGPSignature>>();
        PGPSecretKeyRing.readUserIDs(bCPGInputStream, arrayList, arrayList2, arrayList3);
        this.keys.add(new PGPSecretKey(secretKeyPacket, new PGPPublicKey(secretKeyPacket.getPublicKeyPacket(), trustPacket, list, arrayList, arrayList2, arrayList3, keyFingerPrintCalculator)));
        while (bCPGInputStream.nextPacketTag() == 7 || bCPGInputStream.nextPacketTag() == 14) {
            try {
                List<PGPSignature> list2;
                TrustPacket trustPacket2;
                ContainedPacket containedPacket;
                if (bCPGInputStream.nextPacketTag() == 7) {
                    containedPacket = (SecretSubkeyPacket)bCPGInputStream.readPacket();
                    while (bCPGInputStream.nextPacketTag() == 61) {
                        bCPGInputStream.readPacket();
                    }
                    trustPacket2 = PGPSecretKeyRing.readOptionalTrustPacket(bCPGInputStream);
                    list2 = PGPSecretKeyRing.readSignaturesAndTrust(bCPGInputStream);
                    this.keys.add(new PGPSecretKey((SecretKeyPacket)containedPacket, new PGPPublicKey(((SecretKeyPacket)containedPacket).getPublicKeyPacket(), trustPacket2, list2, keyFingerPrintCalculator)));
                    continue;
                }
                containedPacket = (PublicSubkeyPacket)bCPGInputStream.readPacket();
                trustPacket2 = PGPSecretKeyRing.readOptionalTrustPacket(bCPGInputStream);
                list2 = PGPSecretKeyRing.readSignaturesAndTrust(bCPGInputStream);
                this.extraPubKeys.add(new PGPPublicKey((PublicKeyPacket)containedPacket, trustPacket2, list2, keyFingerPrintCalculator));
            }
            catch (EOFException eOFException) {
                throw eOFException;
            }
            catch (ArmoredInputException armoredInputException) {
                throw armoredInputException;
            }
            catch (IOException iOException) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("skipping unknown subkey: " + iOException.getMessage());
            }
        }
    }

    @Override
    public PGPPublicKey getPublicKey() {
        return this.keys.get(0).getPublicKey();
    }

    @Override
    public PGPPublicKey getPublicKey(long l) {
        PGPSecretKey pGPSecretKey = this.getSecretKey(l);
        if (pGPSecretKey != null) {
            return pGPSecretKey.getPublicKey();
        }
        for (int i = 0; i != this.extraPubKeys.size(); ++i) {
            PGPPublicKey pGPPublicKey = this.extraPubKeys.get(i);
            if (l != pGPPublicKey.getKeyID()) continue;
            return pGPPublicKey;
        }
        return null;
    }

    @Override
    public PGPPublicKey getPublicKey(byte[] byArray) {
        PGPSecretKey pGPSecretKey = this.getSecretKey(byArray);
        if (pGPSecretKey != null) {
            return pGPSecretKey.getPublicKey();
        }
        for (int i = 0; i != this.extraPubKeys.size(); ++i) {
            PGPPublicKey pGPPublicKey = this.extraPubKeys.get(i);
            if (!pGPPublicKey.hasFingerprint(byArray)) continue;
            return pGPPublicKey;
        }
        return null;
    }

    @Override
    public PGPPublicKey getPublicKey(KeyIdentifier keyIdentifier) {
        for (PGPSecretKey object : this.keys) {
            if (object.getPublicKey() == null || !keyIdentifier.matchesExplicit(object.getKeyIdentifier())) continue;
            return object.getPublicKey();
        }
        for (PGPPublicKey pGPPublicKey : this.extraPubKeys) {
            if (!keyIdentifier.matchesExplicit(pGPPublicKey.getKeyIdentifier())) continue;
            return pGPPublicKey;
        }
        return null;
    }

    @Override
    public Iterator<PGPPublicKey> getPublicKeys(KeyIdentifier keyIdentifier) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        for (PGPSecretKey object : this.keys) {
            if (object.getPublicKey() == null || !keyIdentifier.matchesExplicit(object.getKeyIdentifier())) continue;
            arrayList.add(object.getPublicKey());
        }
        for (PGPPublicKey pGPPublicKey : this.extraPubKeys) {
            if (!keyIdentifier.matchesExplicit(pGPPublicKey.getKeyIdentifier())) continue;
            arrayList.add(pGPPublicKey);
        }
        return arrayList.iterator();
    }

    public PGPSecretKey getSecretKey(KeyIdentifier keyIdentifier) {
        for (PGPSecretKey pGPSecretKey : this.keys) {
            if (!keyIdentifier.matchesExplicit(pGPSecretKey.getKeyIdentifier())) continue;
            return pGPSecretKey;
        }
        return null;
    }

    public Iterator<PGPSecretKey> getSecretKeys(KeyIdentifier keyIdentifier) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>();
        for (PGPSecretKey pGPSecretKey : this.keys) {
            if (!keyIdentifier.matchesExplicit(pGPSecretKey.getKeyIdentifier())) continue;
            arrayList.add(pGPSecretKey);
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator<PGPPublicKey> getKeysWithSignaturesBy(long l) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        Iterator<PGPPublicKey> iterator = this.getPublicKeys();
        while (iterator.hasNext()) {
            PGPPublicKey pGPPublicKey = iterator.next();
            Iterator<PGPSignature> iterator2 = pGPPublicKey.getSignaturesForKeyID(l);
            if (!iterator2.hasNext()) continue;
            arrayList.add(pGPPublicKey);
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator<PGPPublicKey> getKeysWithSignaturesBy(KeyIdentifier keyIdentifier) {
        Iterator<PGPSignature> iterator;
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        for (PGPSecretKey object : this.keys) {
            if (object.getPublicKey() == null || !(iterator = object.getPublicKey().getSignaturesForKey(keyIdentifier)).hasNext()) continue;
            arrayList.add(object.getPublicKey());
        }
        for (PGPPublicKey pGPPublicKey : this.extraPubKeys) {
            iterator = pGPPublicKey.getSignaturesForKey(keyIdentifier);
            if (!iterator.hasNext()) continue;
            arrayList.add(pGPPublicKey);
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator<PGPPublicKey> getPublicKeys() {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        Iterator<PGPSecretKey> iterator = this.getSecretKeys();
        while (iterator.hasNext()) {
            PGPPublicKey pGPPublicKey = iterator.next().getPublicKey();
            arrayList.add(pGPPublicKey);
        }
        arrayList.addAll(this.extraPubKeys);
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public PGPSecretKey getSecretKey() {
        return this.keys.get(0);
    }

    public Iterator<PGPSecretKey> getSecretKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public PGPSecretKey getSecretKey(long l) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey pGPSecretKey = this.keys.get(i);
            if (l != pGPSecretKey.getKeyID()) continue;
            return pGPSecretKey;
        }
        return null;
    }

    public PGPSecretKey getSecretKey(byte[] byArray) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey pGPSecretKey = this.keys.get(i);
            if (!pGPSecretKey.getPublicKey().hasFingerprint(byArray)) continue;
            return pGPSecretKey;
        }
        return null;
    }

    public Iterator<PGPPublicKey> getExtraPublicKeys() {
        return this.extraPubKeys.iterator();
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    public PGPPublicKeyRing toCertificate() {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        Iterator<PGPPublicKey> iterator = this.getPublicKeys();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return new PGPPublicKeyRing(arrayList);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.getEncoded(PacketFormat.ROUNDTRIP);
    }

    @Override
    public byte[] getEncoded(PacketFormat packetFormat) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream((OutputStream)byteArrayOutputStream, packetFormat);
        this.encode(bCPGOutputStream);
        bCPGOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        Object object;
        int n;
        for (n = 0; n != this.keys.size(); ++n) {
            object = this.keys.get(n);
            ((PGPSecretKey)object).encode(outputStream);
        }
        for (n = 0; n != this.extraPubKeys.size(); ++n) {
            object = this.extraPubKeys.get(n);
            ((PGPPublicKey)object).encode(outputStream);
        }
    }

    public Iterator<PGPSecretKey> iterator() {
        return this.getSecretKeys();
    }

    public static PGPSecretKeyRing replacePublicKeys(PGPSecretKeyRing pGPSecretKeyRing, PGPPublicKeyRing pGPPublicKeyRing) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys.size());
        for (PGPSecretKey pGPSecretKey : pGPSecretKeyRing.keys) {
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(pGPSecretKey.getKeyID());
            arrayList.add(PGPSecretKey.replacePublicKey(pGPSecretKey, pGPPublicKey));
        }
        return new PGPSecretKeyRing(arrayList);
    }

    public static PGPSecretKeyRing insertOrReplacePublicKey(PGPSecretKeyRing pGPSecretKeyRing, PGPPublicKey pGPPublicKey) {
        PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey(pGPPublicKey.getKeyID());
        if (pGPSecretKey != null) {
            ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys.size());
            Iterator<PGPSecretKey> iterator = pGPSecretKeyRing.getSecretKeys();
            while (iterator.hasNext()) {
                PGPSecretKey pGPSecretKey2 = iterator.next();
                if (pGPSecretKey2.getKeyID() != pGPPublicKey.getKeyID()) continue;
                pGPSecretKey2 = PGPSecretKey.replacePublicKey(pGPSecretKey, pGPPublicKey);
                arrayList.add(pGPSecretKey2);
            }
            return new PGPSecretKeyRing(arrayList);
        }
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>(pGPSecretKeyRing.extraPubKeys.size());
        boolean bl = false;
        Iterator<PGPPublicKey> iterator = pGPSecretKeyRing.getExtraPublicKeys();
        while (iterator.hasNext()) {
            PGPPublicKey pGPPublicKey2 = iterator.next();
            if (pGPPublicKey2.getKeyID() == pGPPublicKey.getKeyID()) {
                arrayList.add(pGPPublicKey);
                bl = true;
                continue;
            }
            arrayList.add(pGPPublicKey2);
        }
        if (!bl) {
            arrayList.add(pGPPublicKey);
        }
        return new PGPSecretKeyRing(new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys), arrayList);
    }

    public static PGPSecretKeyRing copyWithNewPassword(PGPSecretKeyRing pGPSecretKeyRing, PBESecretKeyDecryptor pBESecretKeyDecryptor, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys.size());
        Iterator<PGPSecretKey> iterator = pGPSecretKeyRing.getSecretKeys();
        while (iterator.hasNext()) {
            PGPSecretKey pGPSecretKey = iterator.next();
            if (pGPSecretKey.isPrivateKeyEmpty()) {
                arrayList.add(pGPSecretKey);
                continue;
            }
            arrayList.add(PGPSecretKey.copyWithNewPassword(pGPSecretKey, pBESecretKeyDecryptor, pBESecretKeyEncryptor));
        }
        return new PGPSecretKeyRing(arrayList, pGPSecretKeyRing.extraPubKeys);
    }

    public static PGPSecretKeyRing insertSecretKey(PGPSecretKeyRing pGPSecretKeyRing, PGPSecretKey pGPSecretKey) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i != arrayList.size(); ++i) {
            PGPSecretKey pGPSecretKey2 = (PGPSecretKey)arrayList.get(i);
            if (pGPSecretKey2.getKeyID() == pGPSecretKey.getKeyID()) {
                bl = true;
                arrayList.set(i, pGPSecretKey);
            }
            if (!pGPSecretKey2.isMasterKey()) continue;
            bl2 = true;
        }
        if (!bl) {
            if (pGPSecretKey.isMasterKey()) {
                if (bl2) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                arrayList.add(0, pGPSecretKey);
            } else {
                arrayList.add(pGPSecretKey);
            }
        }
        return new PGPSecretKeyRing(arrayList, pGPSecretKeyRing.extraPubKeys);
    }

    public static PGPSecretKeyRing removeSecretKey(PGPSecretKeyRing pGPSecretKeyRing, PGPSecretKey pGPSecretKey) {
        int n = pGPSecretKeyRing.keys.size();
        long l = pGPSecretKey.getKeyID();
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            PGPSecretKey pGPSecretKey2 = pGPSecretKeyRing.keys.get(i);
            if (pGPSecretKey2.getKeyID() == l) {
                bl = true;
                continue;
            }
            arrayList.add(pGPSecretKey2);
        }
        if (!bl) {
            return null;
        }
        return new PGPSecretKeyRing(arrayList, pGPSecretKeyRing.extraPubKeys);
    }
}

