/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.adapter;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.eventadmin.impl.adapter.AbstractAdapter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class ServiceEventAdapter
extends AbstractAdapter
implements ServiceListener {
    public ServiceEventAdapter(BundleContext context, EventAdmin admin) {
        super(admin);
        context.addServiceListener((ServiceListener)this);
    }

    @Override
    public void destroy(BundleContext context) {
        context.removeServiceListener((ServiceListener)this);
    }

    public void serviceChanged(ServiceEvent event) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("event", event);
        ((Dictionary)properties).put("service", event.getServiceReference());
        ((Dictionary)properties).put("service.id", event.getServiceReference().getProperty("service.id"));
        ((Dictionary)properties).put("service.objectClass", event.getServiceReference().getProperty("objectClass"));
        Object pid = event.getServiceReference().getProperty("service.pid");
        if (null != pid) {
            ((Dictionary)properties).put("service.pid", pid);
        }
        StringBuilder topic = new StringBuilder(ServiceEvent.class.getName().replace('.', '/')).append('/');
        switch (event.getType()) {
            case 1: {
                topic.append("REGISTERED");
                break;
            }
            case 2: {
                topic.append("MODIFIED");
                break;
            }
            case 4: {
                topic.append("UNREGISTERING");
                break;
            }
            default: {
                return;
            }
        }
        try {
            this.getEventAdmin().postEvent(new Event(topic.toString(), (Dictionary<String, ?>)properties));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

