/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.jupnp.UpnpService;
import org.jupnp.model.DiscoveryOptions;
import org.jupnp.model.Location;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.discovery.IncomingSearchRequest;
import org.jupnp.model.message.discovery.OutgoingSearchResponse;
import org.jupnp.model.message.discovery.OutgoingSearchResponseDeviceType;
import org.jupnp.model.message.discovery.OutgoingSearchResponseRootDevice;
import org.jupnp.model.message.discovery.OutgoingSearchResponseServiceType;
import org.jupnp.model.message.discovery.OutgoingSearchResponseUDN;
import org.jupnp.model.message.header.DeviceTypeHeader;
import org.jupnp.model.message.header.MXHeader;
import org.jupnp.model.message.header.RootDeviceHeader;
import org.jupnp.model.message.header.STAllHeader;
import org.jupnp.model.message.header.ServiceTypeHeader;
import org.jupnp.model.message.header.UDNHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.protocol.ReceivingAsync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingSearch
extends ReceivingAsync<IncomingSearchRequest> {
    private final Logger logger = LoggerFactory.getLogger(ReceivingSearch.class);
    private final boolean LOG_ENABLED = this.logger.isTraceEnabled();
    protected final Random randomGenerator = new Random();

    public ReceivingSearch(UpnpService upnpService, IncomingDatagramMessage<UpnpRequest> inputMessage) {
        super(upnpService, new IncomingSearchRequest(inputMessage));
    }

    @Override
    protected void execute() throws RouterException {
        if (this.getUpnpService().getRouter() == null) {
            this.logger.trace("Router hasn't completed initialization, ignoring received search message");
            return;
        }
        if (!((IncomingSearchRequest)this.getInputMessage()).isMANSSDPDiscover()) {
            this.logger.trace("Invalid search request, no or invalid MAN ssdp:discover header: {}", this.getInputMessage());
            return;
        }
        UpnpHeader searchTarget = ((IncomingSearchRequest)this.getInputMessage()).getSearchTarget();
        if (searchTarget == null) {
            this.logger.trace("Invalid search request, did not contain ST header: {}", this.getInputMessage());
            return;
        }
        List<NetworkAddress> activeStreamServers = this.getUpnpService().getRouter().getActiveStreamServers(((IncomingSearchRequest)this.getInputMessage()).getLocalAddress());
        if (activeStreamServers.isEmpty()) {
            this.logger.trace("Aborting search response, no active stream servers found (network disabled?)");
            return;
        }
        for (NetworkAddress activeStreamServer : activeStreamServers) {
            this.sendResponses(searchTarget, activeStreamServer);
        }
    }

    @Override
    protected boolean waitBeforeExecution() throws InterruptedException {
        Integer mx = ((IncomingSearchRequest)this.getInputMessage()).getMX();
        if (mx == null) {
            this.logger.trace("Invalid search request, did not contain MX header: {}", this.getInputMessage());
            return false;
        }
        if (mx > 120 || mx <= 0) {
            mx = MXHeader.DEFAULT_VALUE;
        }
        if (!this.getUpnpService().getRegistry().getLocalDevices().isEmpty()) {
            int sleepTime = this.randomGenerator.nextInt(mx * 1000);
            this.logger.trace("Sleeping {} milliseconds to avoid flooding with search responses", (Object)sleepTime);
            Thread.sleep(sleepTime);
        }
        return true;
    }

    protected void sendResponses(UpnpHeader searchTarget, NetworkAddress activeStreamServer) throws RouterException {
        if (searchTarget instanceof STAllHeader) {
            this.sendSearchResponseAll(activeStreamServer);
        } else if (searchTarget instanceof RootDeviceHeader) {
            this.sendSearchResponseRootDevices(activeStreamServer);
        } else if (searchTarget instanceof UDNHeader) {
            this.sendSearchResponseUDN((UDN)searchTarget.getValue(), activeStreamServer);
        } else if (searchTarget instanceof DeviceTypeHeader) {
            this.sendSearchResponseDeviceType((DeviceType)searchTarget.getValue(), activeStreamServer);
        } else if (searchTarget instanceof ServiceTypeHeader) {
            this.sendSearchResponseServiceType((ServiceType)searchTarget.getValue(), activeStreamServer);
        } else {
            this.logger.warn("Non-implemented search request target: {}", searchTarget.getClass());
        }
    }

    protected void sendSearchResponseAll(NetworkAddress activeStreamServer) throws RouterException {
        if (this.LOG_ENABLED) {
            this.logger.trace("Responding to 'all' search with advertisement messages for all local devices");
        }
        for (LocalDevice localDevice : this.getUpnpService().getRegistry().getLocalDevices()) {
            List<OutgoingSearchResponse> serviceTypeMsgs;
            if (this.isAdvertisementDisabled(localDevice)) continue;
            if (this.LOG_ENABLED) {
                this.logger.trace("Sending root device messages: {}", (Object)localDevice);
            }
            List<OutgoingSearchResponse> rootDeviceMsgs = this.createDeviceMessages(localDevice, activeStreamServer);
            for (OutgoingSearchResponse upnpMessage : rootDeviceMsgs) {
                this.getUpnpService().getRouter().send(upnpMessage);
            }
            if (localDevice.hasEmbeddedDevices()) {
                LocalDevice[] localDeviceArray = (LocalDevice[])localDevice.findEmbeddedDevices();
                int n = localDeviceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LocalDevice embeddedDevice = localDeviceArray[n2];
                    if (this.LOG_ENABLED) {
                        this.logger.trace("Sending embedded device messages: {}", (Object)embeddedDevice);
                    }
                    List<OutgoingSearchResponse> embeddedDeviceMsgs = this.createDeviceMessages(embeddedDevice, activeStreamServer);
                    for (OutgoingSearchResponse upnpMessage : embeddedDeviceMsgs) {
                        this.getUpnpService().getRouter().send(upnpMessage);
                    }
                    ++n2;
                }
            }
            if ((serviceTypeMsgs = this.createServiceTypeMessages(localDevice, activeStreamServer)).isEmpty()) continue;
            if (this.LOG_ENABLED) {
                this.logger.trace("Sending service type messages");
            }
            for (OutgoingSearchResponse upnpMessage : serviceTypeMsgs) {
                this.getUpnpService().getRouter().send(upnpMessage);
            }
        }
    }

    protected List<OutgoingSearchResponse> createDeviceMessages(LocalDevice device, NetworkAddress activeStreamServer) {
        ArrayList<OutgoingSearchResponse> msgs = new ArrayList<OutgoingSearchResponse>();
        if (device.isRoot()) {
            msgs.add(new OutgoingSearchResponseRootDevice((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, device), device));
        }
        msgs.add(new OutgoingSearchResponseUDN((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, device), device));
        msgs.add(new OutgoingSearchResponseDeviceType((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, device), device));
        for (OutgoingSearchResponse msg : msgs) {
            this.prepareOutgoingSearchResponse(msg);
        }
        return msgs;
    }

    protected List<OutgoingSearchResponse> createServiceTypeMessages(LocalDevice device, NetworkAddress activeStreamServer) {
        ArrayList<OutgoingSearchResponse> msgs = new ArrayList<OutgoingSearchResponse>();
        ServiceType[] serviceTypeArray = device.findServiceTypes();
        int n = serviceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceType serviceType = serviceTypeArray[n2];
            OutgoingSearchResponseServiceType message = new OutgoingSearchResponseServiceType((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, device), device, serviceType);
            this.prepareOutgoingSearchResponse(message);
            msgs.add(message);
            ++n2;
        }
        return msgs;
    }

    protected void sendSearchResponseRootDevices(NetworkAddress activeStreamServer) throws RouterException {
        this.logger.trace("Responding to root device search with advertisement messages for all local root devices");
        for (LocalDevice device : this.getUpnpService().getRegistry().getLocalDevices()) {
            if (this.isAdvertisementDisabled(device)) continue;
            OutgoingSearchResponseRootDevice message = new OutgoingSearchResponseRootDevice((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, device), device);
            this.prepareOutgoingSearchResponse(message);
            this.getUpnpService().getRouter().send(message);
        }
    }

    protected void sendSearchResponseUDN(UDN udn, NetworkAddress activeStreamServer) throws RouterException {
        Device device = this.getUpnpService().getRegistry().getDevice(udn, false);
        if (device != null && device instanceof LocalDevice) {
            if (this.isAdvertisementDisabled((LocalDevice)device)) {
                return;
            }
            this.logger.trace("Responding to UDN device search: {}", (Object)udn);
            OutgoingSearchResponseUDN message = new OutgoingSearchResponseUDN((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, (LocalDevice)device), (LocalDevice)device);
            this.prepareOutgoingSearchResponse(message);
            this.getUpnpService().getRouter().send(message);
        }
    }

    protected void sendSearchResponseDeviceType(DeviceType deviceType, NetworkAddress activeStreamServer) throws RouterException {
        this.logger.trace("Responding to device type search: {}", (Object)deviceType);
        Collection<Device> devices = this.getUpnpService().getRegistry().getDevices(deviceType);
        for (Device device : devices) {
            if (!(device instanceof LocalDevice) || this.isAdvertisementDisabled((LocalDevice)device)) continue;
            this.logger.trace("Sending matching device type search result for: {}", (Object)device);
            OutgoingSearchResponseDeviceType message = new OutgoingSearchResponseDeviceType((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, (LocalDevice)device), (LocalDevice)device);
            this.prepareOutgoingSearchResponse(message);
            this.getUpnpService().getRouter().send(message);
        }
    }

    protected void sendSearchResponseServiceType(ServiceType serviceType, NetworkAddress activeStreamServer) throws RouterException {
        this.logger.trace("Responding to service type search: {}", (Object)serviceType);
        Collection<Device> devices = this.getUpnpService().getRegistry().getDevices(serviceType);
        for (Device device : devices) {
            if (!(device instanceof LocalDevice) || this.isAdvertisementDisabled((LocalDevice)device)) continue;
            this.logger.trace("Sending matching service type search result: {}", (Object)device);
            OutgoingSearchResponseServiceType message = new OutgoingSearchResponseServiceType((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, (LocalDevice)device), (LocalDevice)device, serviceType);
            this.prepareOutgoingSearchResponse(message);
            this.getUpnpService().getRouter().send(message);
        }
    }

    protected Location getDescriptorLocation(NetworkAddress activeStreamServer, LocalDevice device) {
        return new Location(activeStreamServer, this.getUpnpService().getConfiguration().getNamespace().getDescriptorPathString(device));
    }

    protected boolean isAdvertisementDisabled(LocalDevice device) {
        DiscoveryOptions options = this.getUpnpService().getRegistry().getDiscoveryOptions(((DeviceIdentity)device.getIdentity()).getUdn());
        return options != null && !options.isAdvertised();
    }

    protected void prepareOutgoingSearchResponse(OutgoingSearchResponse message) {
    }
}

