/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.events.AutomationEventFactory;
import org.openhab.core.automation.events.ExecutionEvent;
import org.openhab.core.automation.handler.BaseActionModuleHandler;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.events.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class RunRuleActionHandler
extends BaseActionModuleHandler {
    public static final String UID = "core.RunRuleAction";
    private static final String RULE_UIDS_KEY = "ruleUIDs";
    private static final String CONSIDER_CONDITIONS_KEY = "considerConditions";
    private final Logger logger = LoggerFactory.getLogger(RunRuleActionHandler.class);
    private final List<String> ruleUIDs;
    private final String moduleId;
    private boolean considerConditions = true;

    public RunRuleActionHandler(Action module) {
        super(module);
        Configuration config = module.getConfiguration();
        if (config.getProperties().isEmpty()) {
            throw new IllegalArgumentException("'Configuration' can not be empty.");
        }
        this.ruleUIDs = (List)config.get(RULE_UIDS_KEY);
        if (this.ruleUIDs == null) {
            throw new IllegalArgumentException("'ruleUIDs' property must not be null.");
        }
        if (config.get(CONSIDER_CONDITIONS_KEY) != null && config.get(CONSIDER_CONDITIONS_KEY) instanceof Boolean) {
            this.considerConditions = (Boolean)config.get(CONSIDER_CONDITIONS_KEY);
        }
        this.moduleId = module.getId();
    }

    @Override
    public @Nullable Map<String, @Nullable Object> execute(Map<String, Object> context) {
        Object previousEvent = context.get("event");
        ExecutionEvent event = AutomationEventFactory.createExecutionEvent(this.moduleId, previousEvent instanceof Event ? Map.of("previous", previousEvent) : null, "runRuleAction");
        HashMap<String, Object> newContext = new HashMap<String, Object>(context);
        newContext.put("event", (Object)event);
        for (String uid : this.ruleUIDs) {
            if (this.callback != null) {
                this.callback.runNow(uid, this.considerConditions, newContext);
                continue;
            }
            this.logger.warn("Action is not applied to {} because rule engine is not available.", (Object)uid);
        }
        return null;
    }
}

