/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.X509Certificate;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class X509PEMFileReader
implements Closeable {
    @NotNull
    public static final String BEGIN_CERTIFICATE_HEADER = "-----BEGIN CERTIFICATE-----";
    @NotNull
    public static final String END_CERTIFICATE_FOOTER = "-----END CERTIFICATE-----";
    @NotNull
    private final BufferedReader reader;

    public X509PEMFileReader(@NotNull String pemFilePath) throws IOException {
        this(new File(pemFilePath));
    }

    public X509PEMFileReader(@NotNull File pemFile) throws IOException {
        this(new FileInputStream(pemFile));
    }

    public X509PEMFileReader(@NotNull InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
    }

    @Nullable
    public X509Certificate readCertificate() throws IOException, CertException {
        boolean beginFound = false;
        StringBuilder base64Buffer = new StringBuilder();
        while (true) {
            String line;
            if ((line = this.reader.readLine()) == null) {
                if (beginFound) {
                    throw new CertException(CertMessages.ERR_X509_PEM_READER_EOF_WITHOUT_END.get(END_CERTIFICATE_FOOTER, BEGIN_CERTIFICATE_HEADER));
                }
                return null;
            }
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty() || trimmedLine.startsWith("#")) continue;
            String upperLine = StaticUtils.toUpperCase(trimmedLine);
            if (BEGIN_CERTIFICATE_HEADER.equals(upperLine)) {
                if (beginFound) {
                    throw new CertException(CertMessages.ERR_X509_PEM_READER_REPEATED_BEGIN.get(BEGIN_CERTIFICATE_HEADER));
                }
                beginFound = true;
                continue;
            }
            if (END_CERTIFICATE_FOOTER.equals(upperLine)) {
                byte[] x509Bytes;
                if (!beginFound) {
                    throw new CertException(CertMessages.ERR_X509_PEM_READER_END_WITHOUT_BEGIN.get(END_CERTIFICATE_FOOTER, BEGIN_CERTIFICATE_HEADER));
                }
                if (base64Buffer.length() == 0) {
                    throw new CertException(CertMessages.ERR_X509_PEM_READER_END_WITHOUT_DATA.get(END_CERTIFICATE_FOOTER, BEGIN_CERTIFICATE_HEADER));
                }
                try {
                    x509Bytes = Base64.decode(base64Buffer.toString());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new CertException(CertMessages.ERR_X509_PEM_READER_CANNOT_BASE64_DECODE.get(), e);
                }
                return new X509Certificate(x509Bytes);
            }
            if (!beginFound) {
                throw new CertException(CertMessages.ERR_X509_PEM_READER_DATA_WITHOUT_BEGIN.get(BEGIN_CERTIFICATE_HEADER));
            }
            base64Buffer.append(trimmedLine);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

