---
title: pixi init
---
<!--- This file is autogenerated. Do not edit manually! -->
# [pixi](../pixi.md) init

Creates a new workspace

--8<-- "docs/reference/cli/pixi/init_extender:description"

## Usage
```
pixi init [OPTIONS] [PATH]
```

## Arguments
- <a id="arg-<PATH>" href="#arg-<PATH>">`<PATH>`</a>
:  Where to place the workspace (defaults to current path)
<br>**default**: `.`

## Options
- <a id="arg---channel" href="#arg---channel">`--channel (-c) <CHANNEL>`</a>
:  Channel to use in the workspace
<br>May be provided more than once.
- <a id="arg---platform" href="#arg---platform">`--platform (-p) <PLATFORM>`</a>
:  Platforms that the workspace supports
<br>May be provided more than once.
- <a id="arg---import" href="#arg---import">`--import (-i) <ENVIRONMENT_FILE>`</a>
:  Environment.yml file to bootstrap the workspace
- <a id="arg---format" href="#arg---format">`--format <FORMAT>`</a>
:  The manifest format to create
<br>**options**: `pixi`, `pyproject`, `mojoproject`
- <a id="arg---scm" href="#arg---scm">`--scm (-s) <SCM>`</a>
:  Source Control Management used for this workspace
<br>**options**: `github`, `gitlab`, `codeberg`
- <a id="arg---conda-pypi-map" href="#arg---conda-pypi-map">`--conda-pypi-map <CONDA_PYPI_MAP>`</a>
:  Set a mapping between conda channels and pypi channels
<br>May be provided more than once.

## Description
Creates a new workspace

This command is used to create a new workspace. It prepares a manifest and some helpers for the user to start working.

As pixi can both work with `pixi.toml` and `pyproject.toml` files, the user can choose which one to use with `--format`.

You can import an existing conda environment file with the `--import` flag.


--8<-- "docs/reference/cli/pixi/init_extender:example"
