/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.FastTimeZone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultTimeZone;

public class DurationFormatUtilsTest
extends AbstractLangTest {
    private static final int FOUR_YEARS = 1461;

    private void assertEqualDuration(String expected, int[] start, int[] end, String format) {
        this.assertEqualDuration(null, expected, start, end, format);
    }

    private void assertEqualDuration(String message, String expected, int[] start, int[] end, String format) {
        Calendar cal1 = Calendar.getInstance();
        cal1.set(start[0], start[1], start[2], start[3], start[4], start[5]);
        cal1.set(14, 0);
        Calendar cal2 = Calendar.getInstance();
        cal2.set(end[0], end[1], end[2], end[3], end[4], end[5]);
        cal2.set(14, 0);
        long milli1 = cal1.getTime().getTime();
        long milli2 = cal2.getTime().getTime();
        String result = DurationFormatUtils.formatPeriod((long)milli1, (long)milli2, (String)format);
        if (message == null) {
            Assertions.assertEquals((Object)expected, (Object)result);
        } else {
            Assertions.assertEquals((Object)expected, (Object)result, (String)message);
        }
    }

    private void bruteForce(int year, int month, int day, String format, int calendarType) {
        String msg = year + "-" + month + "-" + day + " to ";
        Calendar c = Calendar.getInstance();
        c.set(year, month, day, 0, 0, 0);
        int[] array1 = new int[]{year, month, day, 0, 0, 0};
        int[] array2 = new int[]{year, month, day, 0, 0, 0};
        for (int i = 0; i < 1461; ++i) {
            array2[0] = c.get(1);
            array2[1] = c.get(2);
            array2[2] = c.get(5);
            String tmpMsg = msg + array2[0] + "-" + array2[1] + "-" + array2[2] + " at ";
            this.assertEqualDuration(tmpMsg + i, Integer.toString(i), array1, array2, format);
            c.add(calendarType, 1);
        }
    }

    private DurationFormatUtils.Token createTokenWithCount(CharSequence value, int count) {
        DurationFormatUtils.Token token = new DurationFormatUtils.Token(value, false, -1);
        Assertions.assertNotNull((Object)token.toString());
        for (int i = 1; i < count; ++i) {
            token.increment();
            Assertions.assertNotNull((Object)token.toString());
        }
        return token;
    }

    @Test
    public void testAlternatingLiteralOptionals() {
        String format = "['d'dH'h'][m'm']['s's]['ms'S]";
        Assertions.assertEquals((Object)"d1", (Object)DurationFormatUtils.formatDuration((long)Duration.ofDays(1L).toMillis(), (String)"['d'dH'h'][m'm']['s's]['ms'S]"));
        Assertions.assertEquals((Object)"1h", (Object)DurationFormatUtils.formatDuration((long)Duration.ofHours(1L).toMillis(), (String)"['d'dH'h'][m'm']['s's]['ms'S]"));
        Assertions.assertEquals((Object)"1m", (Object)DurationFormatUtils.formatDuration((long)Duration.ofMinutes(1L).toMillis(), (String)"['d'dH'h'][m'm']['s's]['ms'S]"));
        Assertions.assertEquals((Object)"s1", (Object)DurationFormatUtils.formatDuration((long)Duration.ofSeconds(1L).toMillis(), (String)"['d'dH'h'][m'm']['s's]['ms'S]"));
        Assertions.assertEquals((Object)"ms001", (Object)DurationFormatUtils.formatDuration((long)Duration.ofMillis(1L).toMillis(), (String)"['d'dH'h'][m'm']['s's]['ms'S]"));
        Assertions.assertEquals((Object)"d1s1", (Object)DurationFormatUtils.formatDuration((long)Duration.ofDays(1L).plusSeconds(1L).toMillis(), (String)"['d'dH'h'][m'm']['s's]['ms'S]"));
        Assertions.assertEquals((Object)"d11h", (Object)DurationFormatUtils.formatDuration((long)Duration.ofDays(1L).plusHours(1L).toMillis(), (String)"['d'dH'h'][m'm']['s's]['ms'S]"));
        Assertions.assertEquals((Object)"d11h1m", (Object)DurationFormatUtils.formatDuration((long)Duration.ofDays(1L).plusHours(1L).plusMinutes(1L).toMillis(), (String)"['d'dH'h'][m'm']['s's]['ms'S]"));
        Assertions.assertEquals((Object)"d11h1ms1", (Object)DurationFormatUtils.formatDuration((long)Duration.ofDays(1L).plusHours(1L).plusMinutes(1L).plusSeconds(1L).toMillis(), (String)"['d'dH'h'][m'm']['s's]['ms'S]"));
        Assertions.assertEquals((Object)"d11h1ms1ms001", (Object)DurationFormatUtils.formatDuration((long)Duration.ofDays(1L).plusHours(1L).plusMinutes(1L).plusSeconds(1L).plusMillis(1L).toMillis(), (String)"['d'dH'h'][m'm']['s's]['ms'S]"));
    }

    @Test
    public void testBugzilla38401() {
        this.assertEqualDuration("0000/00/30 16:00:00 000", new int[]{2006, 0, 26, 18, 47, 34}, new int[]{2006, 1, 26, 10, 47, 34}, "yyyy/MM/dd HH:mm:ss SSS");
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new DurationFormatUtils());
        Constructor<?>[] cons = DurationFormatUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(DurationFormatUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(DurationFormatUtils.class.getModifiers()));
    }

    @Test
    public void testDurationsByBruteForce() {
        this.bruteForce(2006, 0, 1, "d", 5);
        this.bruteForce(2006, 0, 2, "d", 5);
        this.bruteForce(2007, 1, 2, "d", 5);
        this.bruteForce(2004, 1, 29, "d", 5);
        this.bruteForce(1996, 1, 29, "d", 5);
        this.bruteForce(1969, 1, 28, "M", 2);
    }

    @Test
    @DefaultTimeZone(value="GMT")
    public void testEdgeDurations() {
        TimeZone.setDefault(FastTimeZone.getGmtTimeZone());
        this.assertEqualDuration("01", new int[]{2006, 0, 15, 0, 0, 0}, new int[]{2006, 2, 10, 0, 0, 0}, "MM");
        this.assertEqualDuration("12", new int[]{2005, 0, 15, 0, 0, 0}, new int[]{2006, 0, 15, 0, 0, 0}, "MM");
        this.assertEqualDuration("12", new int[]{2005, 0, 15, 0, 0, 0}, new int[]{2006, 0, 16, 0, 0, 0}, "MM");
        this.assertEqualDuration("11", new int[]{2005, 0, 15, 0, 0, 0}, new int[]{2006, 0, 14, 0, 0, 0}, "MM");
        this.assertEqualDuration("01 26", new int[]{2006, 0, 15, 0, 0, 0}, new int[]{2006, 2, 10, 0, 0, 0}, "MM dd");
        this.assertEqualDuration("54", new int[]{2006, 0, 15, 0, 0, 0}, new int[]{2006, 2, 10, 0, 0, 0}, "dd");
        this.assertEqualDuration("09 12", new int[]{2006, 1, 20, 0, 0, 0}, new int[]{2006, 11, 4, 0, 0, 0}, "MM dd");
        this.assertEqualDuration("287", new int[]{2006, 1, 20, 0, 0, 0}, new int[]{2006, 11, 4, 0, 0, 0}, "dd");
        this.assertEqualDuration("11 30", new int[]{2006, 0, 2, 0, 0, 0}, new int[]{2007, 0, 1, 0, 0, 0}, "MM dd");
        this.assertEqualDuration("364", new int[]{2006, 0, 2, 0, 0, 0}, new int[]{2007, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("12 00", new int[]{2006, 0, 1, 0, 0, 0}, new int[]{2007, 0, 1, 0, 0, 0}, "MM dd");
        this.assertEqualDuration("365", new int[]{2006, 0, 1, 0, 0, 0}, new int[]{2007, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("31", new int[]{2006, 0, 1, 0, 0, 0}, new int[]{2006, 1, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("92", new int[]{2005, 9, 1, 0, 0, 0}, new int[]{2006, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("77", new int[]{2005, 9, 16, 0, 0, 0}, new int[]{2006, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("136", new int[]{2005, 9, 16, 0, 0, 0}, new int[]{2006, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("136", new int[]{2004, 9, 16, 0, 0, 0}, new int[]{2005, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("137", new int[]{2003, 9, 16, 0, 0, 0}, new int[]{2004, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("135", new int[]{2003, 9, 16, 0, 0, 0}, new int[]{2004, 1, 28, 0, 0, 0}, "dd");
        this.assertEqualDuration("364", new int[]{2007, 0, 2, 0, 0, 0}, new int[]{2008, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("729", new int[]{2006, 0, 2, 0, 0, 0}, new int[]{2008, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("365", new int[]{2007, 2, 2, 0, 0, 0}, new int[]{2008, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("333", new int[]{2007, 1, 2, 0, 0, 0}, new int[]{2008, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("28", new int[]{2008, 1, 2, 0, 0, 0}, new int[]{2008, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("393", new int[]{2007, 1, 2, 0, 0, 0}, new int[]{2008, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("369", new int[]{2004, 0, 29, 0, 0, 0}, new int[]{2005, 1, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("338", new int[]{2004, 1, 29, 0, 0, 0}, new int[]{2005, 1, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("28", new int[]{2004, 2, 8, 0, 0, 0}, new int[]{2004, 3, 5, 0, 0, 0}, "dd");
        this.assertEqualDuration("48", new int[]{1992, 1, 29, 0, 0, 0}, new int[]{1996, 1, 29, 0, 0, 0}, "M");
        this.assertEqualDuration("11", new int[]{1996, 1, 29, 0, 0, 0}, new int[]{1997, 1, 28, 0, 0, 0}, "M");
        this.assertEqualDuration("11 28", new int[]{1996, 1, 29, 0, 0, 0}, new int[]{1997, 1, 28, 0, 0, 0}, "M d");
    }

    @Test
    public void testEmptyOptionals() {
        Assertions.assertEquals((Object)"", (Object)DurationFormatUtils.formatDuration((long)0L, (String)"[d'd'][H'h'][m'm'][s's']"));
        Assertions.assertEquals((Object)"", (Object)DurationFormatUtils.formatDuration((long)0L, (String)"['d''h''m''s's]"));
    }

    @Test
    public void testFormatDuration() {
        long duration = 0L;
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"y"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"M"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"d"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"H"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"m"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"s"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"S"));
        Assertions.assertEquals((Object)"0000", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"SSSS"));
        Assertions.assertEquals((Object)"0000", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"yyyy"));
        Assertions.assertEquals((Object)"0000", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"yyMM"));
        duration = 60000L;
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"y"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"M"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"d"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"H"));
        Assertions.assertEquals((Object)"1", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"m"));
        Assertions.assertEquals((Object)"60", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"s"));
        Assertions.assertEquals((Object)"60000", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"S"));
        Assertions.assertEquals((Object)"01:00", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"mm:ss"));
        Calendar base = Calendar.getInstance();
        base.set(2000, 0, 1, 0, 0, 0);
        base.set(14, 0);
        Calendar cal = Calendar.getInstance();
        cal.set(2003, 1, 1, 0, 0, 0);
        cal.set(14, 0);
        duration = cal.getTime().getTime() - base.getTime().getTime();
        int days = 1127;
        Assertions.assertEquals((Object)"0 0 1127", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"y M d"));
    }

    @Test
    public void testFormatDurationHMS() {
        long time = 0L;
        Assertions.assertEquals((Object)"00:00:00.000", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 1L;
        Assertions.assertEquals((Object)"00:00:00.001", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 15L;
        Assertions.assertEquals((Object)"00:00:00.015", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 165L;
        Assertions.assertEquals((Object)"00:00:00.165", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 1675L;
        Assertions.assertEquals((Object)"00:00:01.675", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 13465L;
        Assertions.assertEquals((Object)"00:00:13.465", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 72789L;
        Assertions.assertEquals((Object)"00:01:12.789", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 1932789L;
        Assertions.assertEquals((Object)"00:32:12.789", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 3732789L;
        Assertions.assertEquals((Object)"01:02:12.789", (Object)DurationFormatUtils.formatDurationHMS((long)time));
    }

    @Test
    public void testFormatDurationISO() {
        Assertions.assertEquals((Object)"P0Y0M0DT0H0M0.000S", (Object)DurationFormatUtils.formatDurationISO((long)0L));
        Assertions.assertEquals((Object)"P0Y0M0DT0H0M0.001S", (Object)DurationFormatUtils.formatDurationISO((long)1L));
        Assertions.assertEquals((Object)"P0Y0M0DT0H0M0.010S", (Object)DurationFormatUtils.formatDurationISO((long)10L));
        Assertions.assertEquals((Object)"P0Y0M0DT0H0M0.100S", (Object)DurationFormatUtils.formatDurationISO((long)100L));
        Assertions.assertEquals((Object)"P0Y0M0DT0H1M15.321S", (Object)DurationFormatUtils.formatDurationISO((long)75321L));
    }

    @Test
    public void testFormatDurationPluralWords() {
        long oneSecond = 1000L;
        long oneMinute = 60000L;
        long oneHour = 3600000L;
        long oneDay = 86400000L;
        String text = DurationFormatUtils.formatDurationWords((long)1000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 0 hours 0 minutes 1 second", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)2000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 0 hours 0 minutes 2 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)11000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 0 hours 0 minutes 11 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)60000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 0 hours 1 minute 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)120000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 0 hours 2 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)660000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 0 hours 11 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)61000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 0 hours 1 minute 1 second", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)3600000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 1 hour 0 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)0x6DDD00L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 2 hours 0 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)39600000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 11 hours 0 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)3661000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 1 hour 1 minute 1 second", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)86400000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"1 day 0 hours 0 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)172800000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"2 days 0 hours 0 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)950400000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"11 days 0 hours 0 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)90061000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"1 day 1 hour 1 minute 1 second", (Object)text);
    }

    @Test
    public void testFormatDurationWords() {
        String text = DurationFormatUtils.formatDurationWords((long)50000L, (boolean)true, (boolean)false);
        Assertions.assertEquals((Object)"50 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)65000L, (boolean)true, (boolean)false);
        Assertions.assertEquals((Object)"1 minute 5 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)120000L, (boolean)true, (boolean)false);
        Assertions.assertEquals((Object)"2 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)121000L, (boolean)true, (boolean)false);
        Assertions.assertEquals((Object)"2 minutes 1 second", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)4320000L, (boolean)true, (boolean)false);
        Assertions.assertEquals((Object)"1 hour 12 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)86400000L, (boolean)true, (boolean)false);
        Assertions.assertEquals((Object)"1 day 0 hours 0 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)50000L, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)"50 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)65000L, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)"1 minute 5 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)120000L, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)"2 minutes", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)121000L, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)"2 minutes 1 second", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)4320000L, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)"1 hour 12 minutes", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)86400000L, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)"1 day", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)50000L, (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)"0 days 0 hours 0 minutes 50 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)65000L, (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)"0 days 0 hours 1 minute 5 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)120000L, (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)"0 days 0 hours 2 minutes", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)121000L, (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)"0 days 0 hours 2 minutes 1 second", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)4320000L, (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)"0 days 1 hour 12 minutes", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)86400000L, (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)"1 day", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)50000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 0 hours 0 minutes 50 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)65000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 0 hours 1 minute 5 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)120000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 0 hours 2 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)121000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 0 hours 2 minutes 1 second", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)4320000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"0 days 1 hour 12 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)90720000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"1 day 1 hour 12 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)177120000L, (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"2 days 1 hour 12 minutes 0 seconds", (Object)text);
        for (int i = 2; i < 31; ++i) {
            text = DurationFormatUtils.formatDurationWords((long)((long)(i * 24 * 60 * 60) * 1000L), (boolean)false, (boolean)false);
            Assertions.assertEquals((Object)(i + " days 0 hours 0 minutes 0 seconds"), (Object)text);
        }
    }

    @Test
    public void testFormatNegativeDuration() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DurationFormatUtils.formatDuration((long)-5000L, (String)"S", (boolean)true));
    }

    @Test
    public void testFormatNegativeDurationHMS() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DurationFormatUtils.formatDurationHMS((long)-5000L));
    }

    @Test
    public void testFormatNegativeDurationISO() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DurationFormatUtils.formatDurationISO((long)-5000L));
    }

    @Test
    public void testFormatNegativeDurationWords() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DurationFormatUtils.formatDurationWords((long)-5000L, (boolean)true, (boolean)true));
    }

    @Test
    public void testFormatPeriod() {
        Calendar cal1970 = Calendar.getInstance();
        cal1970.set(1970, 0, 1, 0, 0, 0);
        cal1970.set(14, 0);
        long time1970 = cal1970.getTime().getTime();
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"y"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"M"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"d"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"H"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"m"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"s"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"S"));
        Assertions.assertEquals((Object)"0000", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"SSSS"));
        Assertions.assertEquals((Object)"0000", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"yyyy"));
        Assertions.assertEquals((Object)"0000", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"yyMM"));
        long time = time1970 + 60000L;
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"y"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"M"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"d"));
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"H"));
        Assertions.assertEquals((Object)"1", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"m"));
        Assertions.assertEquals((Object)"60", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"s"));
        Assertions.assertEquals((Object)"60000", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"S"));
        Assertions.assertEquals((Object)"01:00", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"mm:ss"));
        Calendar cal = Calendar.getInstance();
        cal.set(1973, 6, 1, 0, 0, 0);
        cal.set(14, 0);
        time = cal.getTime().getTime();
        Assertions.assertEquals((Object)"36", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yM"));
        Assertions.assertEquals((Object)"3 years 6 months", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"y' years 'M' months'"));
        Assertions.assertEquals((Object)"03/06", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yy/MM"));
        cal.set(1973, 10, 1, 0, 0, 0);
        cal.set(14, 0);
        time = cal.getTime().getTime();
        Assertions.assertEquals((Object)"310", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yM"));
        Assertions.assertEquals((Object)"3 years 10 months", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"y' years 'M' months'"));
        Assertions.assertEquals((Object)"03/10", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yy/MM"));
        cal.set(1974, 0, 1, 0, 0, 0);
        cal.set(14, 0);
        time = cal.getTime().getTime();
        Assertions.assertEquals((Object)"40", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yM"));
        Assertions.assertEquals((Object)"4 years 0 months", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"y' ''years' M 'months'"));
        Assertions.assertEquals((Object)"4 years 0 months", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"y' years 'M' months'"));
        Assertions.assertEquals((Object)"4years 0months", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"y'years 'M'months'"));
        Assertions.assertEquals((Object)"04/00", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yy/MM"));
        Assertions.assertEquals((Object)"48", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"M"));
        Assertions.assertEquals((Object)"48", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"MM"));
        Assertions.assertEquals((Object)"048", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"MMM"));
        Assertions.assertEquals((Object)"hello", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"'hello'"));
        Assertions.assertEquals((Object)"helloworld", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"'hello''world'"));
    }

    @Test
    public void testFormatPeriodeStartGreaterEnd() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DurationFormatUtils.formatPeriod((long)5000L, (long)2500L, (String)"yy/MM"));
    }

    @Test
    public void testFormatPeriodISO() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar base = Calendar.getInstance(timeZone);
        base.set(1970, 0, 1, 0, 0, 0);
        base.set(14, 0);
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2002, 1, 23, 9, 11, 12);
        cal.set(14, 1);
        String text = DateFormatUtils.format((Calendar)cal, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        Assertions.assertEquals((Object)"2002-02-23T09:11:12-03:00", (Object)text);
        text = DurationFormatUtils.formatPeriod((long)base.getTime().getTime(), (long)cal.getTime().getTime(), (String)"'P'yyyy'Y'M'M'd'DT'H'H'm'M's.SSS'S'", (boolean)false, (TimeZone)timeZone);
        Assertions.assertEquals((Object)"P32Y1M22DT9H11M12.001S", (Object)text);
        cal.set(1971, 1, 3, 10, 30, 0);
        cal.set(14, 0);
        text = DurationFormatUtils.formatPeriod((long)base.getTime().getTime(), (long)cal.getTime().getTime(), (String)"'P'yyyy'Y'M'M'd'DT'H'H'm'M's.SSS'S'", (boolean)false, (TimeZone)timeZone);
        Assertions.assertEquals((Object)"P1Y1M2DT10H30M0.000S", (Object)text);
    }

    @Test
    public void testFormatPeriodISOMethod() {
        Assertions.assertEquals((Object)"P0Y0M0DT0H0M0.000S", (Object)DurationFormatUtils.formatPeriodISO((long)0L, (long)0L));
        Assertions.assertEquals((Object)"P0Y0M0DT0H0M1.000S", (Object)DurationFormatUtils.formatPeriodISO((long)0L, (long)1000L));
        Assertions.assertEquals((Object)"P0Y0M0DT0H1M1.000S", (Object)DurationFormatUtils.formatPeriodISO((long)0L, (long)61000L));
    }

    @Test
    public void testFormatPeriodISOStartGreaterEnd() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DurationFormatUtils.formatPeriodISO((long)5000L, (long)2000L));
    }

    @Test
    public void testFourYears() {
        Calendar c = Calendar.getInstance();
        c.set(2004, 0, 1, 0, 0, 0);
        for (int i = 0; i < 1461; ++i) {
            this.bruteForce(c.get(1), c.get(2), c.get(5), "d", 5);
            c.add(5, 1);
        }
    }

    @Test
    public void testJiraLang281() {
        this.assertEqualDuration("09", new int[]{2005, 11, 31, 0, 0, 0}, new int[]{2006, 9, 6, 0, 0, 0}, "MM");
    }

    @Test
    public void testLANG815() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2012, 6, 30, 0, 0, 0);
        long startMillis = calendar.getTimeInMillis();
        calendar.set(2012, 8, 8);
        long endMillis = calendar.getTimeInMillis();
        Assertions.assertEquals((Object)"1 9", (Object)DurationFormatUtils.formatPeriod((long)startMillis, (long)endMillis, (String)"M d"));
    }

    @Test
    public void testLANG981() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DurationFormatUtils.lexx((String)"'yMdHms''S"));
    }

    @Test
    public void testLANG982() {
        Assertions.assertEquals((Object)"61.999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"s.S"));
        Assertions.assertEquals((Object)"1 1999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"m S"));
        Assertions.assertEquals((Object)"61.999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"s.SSS"));
        Assertions.assertEquals((Object)"1 1999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"m SSS"));
        Assertions.assertEquals((Object)"61.0999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"s.SSSS"));
        Assertions.assertEquals((Object)"1 1999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"m SSSS"));
        Assertions.assertEquals((Object)"61.00999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"s.SSSSS"));
        Assertions.assertEquals((Object)"1 01999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"m SSSSS"));
    }

    @Test
    public void testLANG984() {
        Assertions.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)0L, (String)"S"));
        Assertions.assertEquals((Object)Integer.toString(Integer.MAX_VALUE), (Object)DurationFormatUtils.formatDuration((long)Integer.MAX_VALUE, (String)"S"));
        long maxIntPlus = Integer.MAX_VALUE;
        Assertions.assertEquals((Object)Long.toString(++maxIntPlus), (Object)DurationFormatUtils.formatDuration((long)maxIntPlus, (String)"S"));
        Assertions.assertEquals((Object)Long.toString(Long.MAX_VALUE), (Object)DurationFormatUtils.formatDuration((long)Long.MAX_VALUE, (String)"S"));
    }

    @Test
    public void testLexx() {
        Assertions.assertArrayEquals((Object[])new DurationFormatUtils.Token[]{this.createTokenWithCount("y", 1), this.createTokenWithCount("M", 1), this.createTokenWithCount("d", 1), this.createTokenWithCount("H", 1), this.createTokenWithCount("m", 1), this.createTokenWithCount("s", 1), this.createTokenWithCount("S", 1)}, (Object[])DurationFormatUtils.lexx((String)"yMdHmsS"));
        Assertions.assertArrayEquals((Object[])new DurationFormatUtils.Token[]{this.createTokenWithCount("H", 2), this.createTokenWithCount(new StringBuilder(":"), 1), this.createTokenWithCount("m", 2), this.createTokenWithCount(new StringBuilder(":"), 1), this.createTokenWithCount("s", 2), this.createTokenWithCount(new StringBuilder("."), 1), this.createTokenWithCount("S", 3)}, (Object[])DurationFormatUtils.lexx((String)"HH:mm:ss.SSS"));
        Assertions.assertArrayEquals((Object[])new DurationFormatUtils.Token[]{this.createTokenWithCount(new StringBuilder("P"), 1), this.createTokenWithCount("y", 4), this.createTokenWithCount(new StringBuilder("Y"), 1), this.createTokenWithCount("M", 1), this.createTokenWithCount(new StringBuilder("M"), 1), this.createTokenWithCount("d", 1), this.createTokenWithCount(new StringBuilder("DT"), 1), this.createTokenWithCount("H", 1), this.createTokenWithCount(new StringBuilder("H"), 1), this.createTokenWithCount("m", 1), this.createTokenWithCount(new StringBuilder("M"), 1), this.createTokenWithCount("s", 1), this.createTokenWithCount(new StringBuilder("."), 1), this.createTokenWithCount("S", 3), this.createTokenWithCount(new StringBuilder("S"), 1)}, (Object[])DurationFormatUtils.lexx((String)"'P'yyyy'Y'M'M'd'DT'H'H'm'M's.SSS'S'"));
        DurationFormatUtils.Token token = this.createTokenWithCount("y", 4);
        Assertions.assertEquals((Object)token, (Object)token);
        Assertions.assertEquals((int)token.hashCode(), (int)token.hashCode());
        Assertions.assertNotEquals((Object)token, (Object)new Object(), (String)"Token equal to non-Token class. ");
        DurationFormatUtils.Token token2 = this.createTokenWithCount("", 1);
        Assertions.assertNotEquals((Object)token, (Object)token2, (String)"Token equal to Token with wrong value class. ");
        Assertions.assertNotEquals((int)token.hashCode(), (int)token2.hashCode());
        Assertions.assertNotEquals((Object)token, (Object)this.createTokenWithCount("y", 1), (String)"Token equal to Token with different count. ");
        DurationFormatUtils.Token numToken = this.createTokenWithCount("1", 4);
        Assertions.assertEquals((Object)numToken, (Object)numToken, (String)"Token with Number value not equal to itself. ");
    }

    @Test
    public void testLiteralPrefixOptionalToken() {
        Assertions.assertEquals((Object)DurationFormatUtils.formatDuration((long)10000L, (String)"s's'"), (Object)DurationFormatUtils.formatDuration((long)10000L, (String)"['['d']']['<'H'>']['{'m'}']s's'"));
        Assertions.assertEquals((Object)DurationFormatUtils.formatDuration((long)10000L, (String)"s's'"), (Object)DurationFormatUtils.formatDuration((long)10000L, (String)"['{'m'}']s's'"));
    }

    @Test
    public void testLowDurations() {
        for (int hr = 0; hr < 24; ++hr) {
            for (int min = 0; min < 60; ++min) {
                for (int sec = 0; sec < 60; ++sec) {
                    this.assertEqualDuration(hr + ":" + min + ":" + sec, new int[]{2000, 0, 1, 0, 0, 0, 0}, new int[]{2000, 0, 1, hr, min, sec}, "H:m:s");
                }
            }
        }
    }

    @Test
    public void testMultipleOptionalBlocks() {
        Assertions.assertEquals((Object)DurationFormatUtils.formatDuration((long)Duration.ofHours(1L).toMillis(), (String)"'[['H']]'"), (Object)DurationFormatUtils.formatDuration((long)Duration.ofHours(1L).toMillis(), (String)"['{'d'}']['[['H']]']"));
        Assertions.assertEquals((Object)DurationFormatUtils.formatDuration((long)Duration.ofDays(1L).toMillis(), (String)"['{'d'}']"), (Object)DurationFormatUtils.formatDuration((long)Duration.ofDays(1L).toMillis(), (String)"['{'d'}']['['H']']"));
    }

    @Test
    public void testOptionalLiteralSpecialCharacters() {
        Assertions.assertEquals((Object)DurationFormatUtils.formatDuration((long)10000L, (String)"s's'"), (Object)DurationFormatUtils.formatDuration((long)10000L, (String)"['['m']']s's'"));
    }

    @Test
    public void testOptionalToken() {
        Assertions.assertEquals((Object)DurationFormatUtils.formatDuration((long)915361000L, (String)"d'd'H'h'm'm's's'"), (Object)DurationFormatUtils.formatDuration((long)915361000L, (String)"[d'd'H'h'm'm']s's'"));
        Assertions.assertEquals((Object)DurationFormatUtils.formatDuration((long)9153610L, (String)"H'h'm'm's's'"), (Object)DurationFormatUtils.formatDuration((long)9153610L, (String)"[d'd'H'h'm'm']s's'"));
        Assertions.assertEquals((Object)DurationFormatUtils.formatDuration((long)915361L, (String)"m'm's's'"), (Object)DurationFormatUtils.formatDuration((long)915361L, (String)"[d'd'H'h'm'm']s's'"));
        Assertions.assertEquals((Object)DurationFormatUtils.formatDuration((long)9153L, (String)"s's'"), (Object)DurationFormatUtils.formatDuration((long)9153L, (String)"[d'd'H'h'm'm']s's'"));
        Assertions.assertEquals((Object)DurationFormatUtils.formatDuration((long)9153L, (String)"s's'"), (Object)DurationFormatUtils.formatDuration((long)9153L, (String)"[d'd'H'h'm'm']s's'"));
        Assertions.assertEquals((Object)DurationFormatUtils.formatPeriod((long)9153610L, (long)915361000L, (String)"d'd'H'h'm'm's's'"), (Object)DurationFormatUtils.formatPeriod((long)9153610L, (long)915361000L, (String)"[d'd'H'h'm'm']s's'"));
        Assertions.assertEquals((Object)DurationFormatUtils.formatPeriod((long)915361L, (long)9153610L, (String)"H'h'm'm's's'"), (Object)DurationFormatUtils.formatPeriod((long)915361L, (long)9153610L, (String)"[d'd'H'h'm'm']s's'"));
        Assertions.assertEquals((Object)DurationFormatUtils.formatPeriod((long)9153L, (long)915361L, (String)"m'm's's'"), (Object)DurationFormatUtils.formatPeriod((long)9153L, (long)915361L, (String)"[d'd'H'h'm'm']s's'"));
        Assertions.assertEquals((Object)DurationFormatUtils.formatPeriod((long)0L, (long)9153L, (String)"s's'"), (Object)DurationFormatUtils.formatPeriod((long)0L, (long)9153L, (String)"[d'd'H'h'm'm']s's'"));
        Assertions.assertEquals((Object)"2h32m33s610ms", (Object)DurationFormatUtils.formatDuration((long)9153610L, (String)"[d'd'H'h'm'm's's']S'ms'"));
        Assertions.assertEquals((Object)"15m15s361ms", (Object)DurationFormatUtils.formatDuration((long)915361L, (String)"[d'd'H'h'm'm's's']S'ms'"));
        Assertions.assertEquals((Object)"9s153ms", (Object)DurationFormatUtils.formatDuration((long)9153L, (String)"[d'd'H'h'm'm's's']S'ms'"));
        Assertions.assertEquals((Object)"915ms", (Object)DurationFormatUtils.formatDuration((long)915L, (String)"[d'd'H'h'm'm's's']S'ms'"));
        Assertions.assertEquals((Object)DurationFormatUtils.formatPeriod((long)915361L, (long)9153610L, (String)"H'h''h2'm'm's's'"), (Object)DurationFormatUtils.formatPeriod((long)915361L, (long)9153610L, (String)"[d'd''d2'H'h''h2'm'm']s's'"));
    }

    @Test
    public void testUnmatchedOptionalTokens() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DurationFormatUtils.formatDuration((long)1L, (String)"[s"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DurationFormatUtils.formatDuration((long)1L, (String)"[[s"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DurationFormatUtils.formatDuration((long)1L, (String)"[s]]"));
    }
}

