// Copyright 2023-2025 The Inspektor Gadget authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package syscalls

// This file is automatically generated from:
//     https://raw.githubusercontent.com/seccomp/libseccomp/refs/heads/main/src/syscalls.csv
//
// To update it, run:
//     make -C tools/syscalls-update
//
// Linux version: v6.13.0 2025-01-23

var syscallsNameToNumber = map[string]int{
	"accept":                  202,
	"accept4":                 242,
	"acct":                    89,
	"add_key":                 217,
	"adjtimex":                171,
	"bind":                    200,
	"bpf":                     280,
	"brk":                     214,
	"cachestat":               451,
	"capget":                  90,
	"capset":                  91,
	"chdir":                   49,
	"chroot":                  51,
	"clock_adjtime":           266,
	"clock_getres":            114,
	"clock_gettime":           113,
	"clock_nanosleep":         115,
	"clock_settime":           112,
	"clone":                   220,
	"clone3":                  435,
	"close":                   57,
	"close_range":             436,
	"connect":                 203,
	"copy_file_range":         285,
	"delete_module":           106,
	"dup":                     23,
	"dup3":                    24,
	"epoll_create1":           20,
	"epoll_ctl":               21,
	"epoll_pwait":             22,
	"epoll_pwait2":            441,
	"eventfd2":                19,
	"execve":                  221,
	"execveat":                281,
	"exit":                    93,
	"exit_group":              94,
	"faccessat":               48,
	"faccessat2":              439,
	"fadvise64":               223,
	"fallocate":               47,
	"fanotify_init":           262,
	"fanotify_mark":           263,
	"fchdir":                  50,
	"fchmod":                  52,
	"fchmodat":                53,
	"fchmodat2":               452,
	"fchown":                  55,
	"fchownat":                54,
	"fcntl":                   25,
	"fdatasync":               83,
	"fgetxattr":               10,
	"finit_module":            273,
	"flistxattr":              13,
	"flock":                   32,
	"fremovexattr":            16,
	"fsconfig":                431,
	"fsetxattr":               7,
	"fsmount":                 432,
	"fsopen":                  430,
	"fspick":                  433,
	"fstat":                   80,
	"fstatfs":                 44,
	"fsync":                   82,
	"ftruncate":               46,
	"futex":                   98,
	"futex_requeue":           456,
	"futex_wait":              455,
	"futex_waitv":             449,
	"futex_wake":              454,
	"get_mempolicy":           236,
	"get_robust_list":         100,
	"getcpu":                  168,
	"getcwd":                  17,
	"getdents64":              61,
	"getegid":                 177,
	"geteuid":                 175,
	"getgid":                  176,
	"getgroups":               158,
	"getitimer":               102,
	"getpeername":             205,
	"getpgid":                 155,
	"getpid":                  172,
	"getppid":                 173,
	"getpriority":             141,
	"getrandom":               278,
	"getresgid":               150,
	"getresuid":               148,
	"getrlimit":               163,
	"getrusage":               165,
	"getsid":                  156,
	"getsockname":             204,
	"getsockopt":              209,
	"gettid":                  178,
	"gettimeofday":            169,
	"getuid":                  174,
	"getxattr":                8,
	"getxattrat":              464,
	"init_module":             105,
	"inotify_add_watch":       27,
	"inotify_init1":           26,
	"inotify_rm_watch":        28,
	"io_cancel":               3,
	"io_destroy":              1,
	"io_getevents":            4,
	"io_pgetevents":           292,
	"io_setup":                0,
	"io_submit":               2,
	"io_uring_enter":          426,
	"io_uring_register":       427,
	"io_uring_setup":          425,
	"ioctl":                   29,
	"ioprio_get":              31,
	"ioprio_set":              30,
	"kcmp":                    272,
	"kexec_file_load":         294,
	"kexec_load":              104,
	"keyctl":                  219,
	"kill":                    129,
	"landlock_add_rule":       445,
	"landlock_create_ruleset": 444,
	"landlock_restrict_self":  446,
	"lgetxattr":               9,
	"linkat":                  37,
	"listen":                  201,
	"listmount":               458,
	"listxattr":               11,
	"listxattrat":             465,
	"llistxattr":              12,
	"lookup_dcookie":          18,
	"lremovexattr":            15,
	"lseek":                   62,
	"lsetxattr":               6,
	"lsm_get_self_attr":       459,
	"lsm_list_modules":        461,
	"lsm_set_self_attr":       460,
	"madvise":                 233,
	"map_shadow_stack":        453,
	"mbind":                   235,
	"membarrier":              283,
	"memfd_create":            279,
	"memfd_secret":            447,
	"migrate_pages":           238,
	"mincore":                 232,
	"mkdirat":                 34,
	"mknodat":                 33,
	"mlock":                   228,
	"mlock2":                  284,
	"mlockall":                230,
	"mmap":                    222,
	"mount":                   40,
	"mount_setattr":           442,
	"move_mount":              429,
	"move_pages":              239,
	"mprotect":                226,
	"mq_getsetattr":           185,
	"mq_notify":               184,
	"mq_open":                 180,
	"mq_timedreceive":         183,
	"mq_timedsend":            182,
	"mq_unlink":               181,
	"mremap":                  216,
	"mseal":                   462,
	"msgctl":                  187,
	"msgget":                  186,
	"msgrcv":                  188,
	"msgsnd":                  189,
	"msync":                   227,
	"munlock":                 229,
	"munlockall":              231,
	"munmap":                  215,
	"name_to_handle_at":       264,
	"nanosleep":               101,
	"newfstatat":              79,
	"nfsservctl":              42,
	"open_by_handle_at":       265,
	"open_tree":               428,
	"openat":                  56,
	"openat2":                 437,
	"perf_event_open":         241,
	"personality":             92,
	"pidfd_getfd":             438,
	"pidfd_open":              434,
	"pidfd_send_signal":       424,
	"pipe2":                   59,
	"pivot_root":              41,
	"pkey_alloc":              289,
	"pkey_free":               290,
	"pkey_mprotect":           288,
	"ppoll":                   73,
	"prctl":                   167,
	"pread64":                 67,
	"preadv":                  69,
	"preadv2":                 286,
	"prlimit64":               261,
	"process_madvise":         440,
	"process_mrelease":        448,
	"process_vm_readv":        270,
	"process_vm_writev":       271,
	"pselect6":                72,
	"ptrace":                  117,
	"pwrite64":                68,
	"pwritev":                 70,
	"pwritev2":                287,
	"quotactl":                60,
	"quotactl_fd":             443,
	"read":                    63,
	"readahead":               213,
	"readlinkat":              78,
	"readv":                   65,
	"reboot":                  142,
	"recvfrom":                207,
	"recvmmsg":                243,
	"recvmsg":                 212,
	"remap_file_pages":        234,
	"removexattr":             14,
	"removexattrat":           466,
	"renameat":                38,
	"renameat2":               276,
	"request_key":             218,
	"restart_syscall":         128,
	"rseq":                    293,
	"rt_sigaction":            134,
	"rt_sigpending":           136,
	"rt_sigprocmask":          135,
	"rt_sigqueueinfo":         138,
	"rt_sigreturn":            139,
	"rt_sigsuspend":           133,
	"rt_sigtimedwait":         137,
	"rt_tgsigqueueinfo":       240,
	"sched_get_priority_max":  125,
	"sched_get_priority_min":  126,
	"sched_getaffinity":       123,
	"sched_getattr":           275,
	"sched_getparam":          121,
	"sched_getscheduler":      120,
	"sched_rr_get_interval":   127,
	"sched_setaffinity":       122,
	"sched_setattr":           274,
	"sched_setparam":          118,
	"sched_setscheduler":      119,
	"sched_yield":             124,
	"seccomp":                 277,
	"semctl":                  191,
	"semget":                  190,
	"semop":                   193,
	"semtimedop":              192,
	"sendfile":                71,
	"sendmmsg":                269,
	"sendmsg":                 211,
	"sendto":                  206,
	"set_mempolicy":           237,
	"set_mempolicy_home_node": 450,
	"set_robust_list":         99,
	"set_tid_address":         96,
	"setdomainname":           162,
	"setfsgid":                152,
	"setfsuid":                151,
	"setgid":                  144,
	"setgroups":               159,
	"sethostname":             161,
	"setitimer":               103,
	"setns":                   268,
	"setpgid":                 154,
	"setpriority":             140,
	"setregid":                143,
	"setresgid":               149,
	"setresuid":               147,
	"setreuid":                145,
	"setrlimit":               164,
	"setsid":                  157,
	"setsockopt":              208,
	"settimeofday":            170,
	"setuid":                  146,
	"setxattr":                5,
	"setxattrat":              463,
	"shmat":                   196,
	"shmctl":                  195,
	"shmdt":                   197,
	"shmget":                  194,
	"shutdown":                210,
	"sigaltstack":             132,
	"signalfd4":               74,
	"socket":                  198,
	"socketpair":              199,
	"splice":                  76,
	"statfs":                  43,
	"statmount":               457,
	"statx":                   291,
	"swapoff":                 225,
	"swapon":                  224,
	"symlinkat":               36,
	"sync":                    81,
	"sync_file_range":         84,
	"syncfs":                  267,
	"sysinfo":                 179,
	"syslog":                  116,
	"tee":                     77,
	"tgkill":                  131,
	"timer_create":            107,
	"timer_delete":            111,
	"timer_getoverrun":        109,
	"timer_gettime":           108,
	"timer_settime":           110,
	"timerfd_create":          85,
	"timerfd_gettime":         87,
	"timerfd_settime":         86,
	"times":                   153,
	"tkill":                   130,
	"truncate":                45,
	"umask":                   166,
	"umount2":                 39,
	"uname":                   160,
	"unlinkat":                35,
	"unshare":                 97,
	"userfaultfd":             282,
	"utimensat":               88,
	"vhangup":                 58,
	"vmsplice":                75,
	"wait4":                   260,
	"waitid":                  95,
	"write":                   64,
	"writev":                  66,
}

var syscallsNumberToName = map[int]string{
	202: "accept",
	242: "accept4",
	89:  "acct",
	217: "add_key",
	171: "adjtimex",
	200: "bind",
	280: "bpf",
	214: "brk",
	451: "cachestat",
	90:  "capget",
	91:  "capset",
	49:  "chdir",
	51:  "chroot",
	266: "clock_adjtime",
	114: "clock_getres",
	113: "clock_gettime",
	115: "clock_nanosleep",
	112: "clock_settime",
	220: "clone",
	435: "clone3",
	57:  "close",
	436: "close_range",
	203: "connect",
	285: "copy_file_range",
	106: "delete_module",
	23:  "dup",
	24:  "dup3",
	20:  "epoll_create1",
	21:  "epoll_ctl",
	22:  "epoll_pwait",
	441: "epoll_pwait2",
	19:  "eventfd2",
	221: "execve",
	281: "execveat",
	93:  "exit",
	94:  "exit_group",
	48:  "faccessat",
	439: "faccessat2",
	223: "fadvise64",
	47:  "fallocate",
	262: "fanotify_init",
	263: "fanotify_mark",
	50:  "fchdir",
	52:  "fchmod",
	53:  "fchmodat",
	452: "fchmodat2",
	55:  "fchown",
	54:  "fchownat",
	25:  "fcntl",
	83:  "fdatasync",
	10:  "fgetxattr",
	273: "finit_module",
	13:  "flistxattr",
	32:  "flock",
	16:  "fremovexattr",
	431: "fsconfig",
	7:   "fsetxattr",
	432: "fsmount",
	430: "fsopen",
	433: "fspick",
	80:  "fstat",
	44:  "fstatfs",
	82:  "fsync",
	46:  "ftruncate",
	98:  "futex",
	456: "futex_requeue",
	455: "futex_wait",
	449: "futex_waitv",
	454: "futex_wake",
	236: "get_mempolicy",
	100: "get_robust_list",
	168: "getcpu",
	17:  "getcwd",
	61:  "getdents64",
	177: "getegid",
	175: "geteuid",
	176: "getgid",
	158: "getgroups",
	102: "getitimer",
	205: "getpeername",
	155: "getpgid",
	172: "getpid",
	173: "getppid",
	141: "getpriority",
	278: "getrandom",
	150: "getresgid",
	148: "getresuid",
	163: "getrlimit",
	165: "getrusage",
	156: "getsid",
	204: "getsockname",
	209: "getsockopt",
	178: "gettid",
	169: "gettimeofday",
	174: "getuid",
	8:   "getxattr",
	464: "getxattrat",
	105: "init_module",
	27:  "inotify_add_watch",
	26:  "inotify_init1",
	28:  "inotify_rm_watch",
	3:   "io_cancel",
	1:   "io_destroy",
	4:   "io_getevents",
	292: "io_pgetevents",
	0:   "io_setup",
	2:   "io_submit",
	426: "io_uring_enter",
	427: "io_uring_register",
	425: "io_uring_setup",
	29:  "ioctl",
	31:  "ioprio_get",
	30:  "ioprio_set",
	272: "kcmp",
	294: "kexec_file_load",
	104: "kexec_load",
	219: "keyctl",
	129: "kill",
	445: "landlock_add_rule",
	444: "landlock_create_ruleset",
	446: "landlock_restrict_self",
	9:   "lgetxattr",
	37:  "linkat",
	201: "listen",
	458: "listmount",
	11:  "listxattr",
	465: "listxattrat",
	12:  "llistxattr",
	18:  "lookup_dcookie",
	15:  "lremovexattr",
	62:  "lseek",
	6:   "lsetxattr",
	459: "lsm_get_self_attr",
	461: "lsm_list_modules",
	460: "lsm_set_self_attr",
	233: "madvise",
	453: "map_shadow_stack",
	235: "mbind",
	283: "membarrier",
	279: "memfd_create",
	447: "memfd_secret",
	238: "migrate_pages",
	232: "mincore",
	34:  "mkdirat",
	33:  "mknodat",
	228: "mlock",
	284: "mlock2",
	230: "mlockall",
	222: "mmap",
	40:  "mount",
	442: "mount_setattr",
	429: "move_mount",
	239: "move_pages",
	226: "mprotect",
	185: "mq_getsetattr",
	184: "mq_notify",
	180: "mq_open",
	183: "mq_timedreceive",
	182: "mq_timedsend",
	181: "mq_unlink",
	216: "mremap",
	462: "mseal",
	187: "msgctl",
	186: "msgget",
	188: "msgrcv",
	189: "msgsnd",
	227: "msync",
	229: "munlock",
	231: "munlockall",
	215: "munmap",
	264: "name_to_handle_at",
	101: "nanosleep",
	79:  "newfstatat",
	42:  "nfsservctl",
	265: "open_by_handle_at",
	428: "open_tree",
	56:  "openat",
	437: "openat2",
	241: "perf_event_open",
	92:  "personality",
	438: "pidfd_getfd",
	434: "pidfd_open",
	424: "pidfd_send_signal",
	59:  "pipe2",
	41:  "pivot_root",
	289: "pkey_alloc",
	290: "pkey_free",
	288: "pkey_mprotect",
	73:  "ppoll",
	167: "prctl",
	67:  "pread64",
	69:  "preadv",
	286: "preadv2",
	261: "prlimit64",
	440: "process_madvise",
	448: "process_mrelease",
	270: "process_vm_readv",
	271: "process_vm_writev",
	72:  "pselect6",
	117: "ptrace",
	68:  "pwrite64",
	70:  "pwritev",
	287: "pwritev2",
	60:  "quotactl",
	443: "quotactl_fd",
	63:  "read",
	213: "readahead",
	78:  "readlinkat",
	65:  "readv",
	142: "reboot",
	207: "recvfrom",
	243: "recvmmsg",
	212: "recvmsg",
	234: "remap_file_pages",
	14:  "removexattr",
	466: "removexattrat",
	38:  "renameat",
	276: "renameat2",
	218: "request_key",
	128: "restart_syscall",
	293: "rseq",
	134: "rt_sigaction",
	136: "rt_sigpending",
	135: "rt_sigprocmask",
	138: "rt_sigqueueinfo",
	139: "rt_sigreturn",
	133: "rt_sigsuspend",
	137: "rt_sigtimedwait",
	240: "rt_tgsigqueueinfo",
	125: "sched_get_priority_max",
	126: "sched_get_priority_min",
	123: "sched_getaffinity",
	275: "sched_getattr",
	121: "sched_getparam",
	120: "sched_getscheduler",
	127: "sched_rr_get_interval",
	122: "sched_setaffinity",
	274: "sched_setattr",
	118: "sched_setparam",
	119: "sched_setscheduler",
	124: "sched_yield",
	277: "seccomp",
	191: "semctl",
	190: "semget",
	193: "semop",
	192: "semtimedop",
	71:  "sendfile",
	269: "sendmmsg",
	211: "sendmsg",
	206: "sendto",
	237: "set_mempolicy",
	450: "set_mempolicy_home_node",
	99:  "set_robust_list",
	96:  "set_tid_address",
	162: "setdomainname",
	152: "setfsgid",
	151: "setfsuid",
	144: "setgid",
	159: "setgroups",
	161: "sethostname",
	103: "setitimer",
	268: "setns",
	154: "setpgid",
	140: "setpriority",
	143: "setregid",
	149: "setresgid",
	147: "setresuid",
	145: "setreuid",
	164: "setrlimit",
	157: "setsid",
	208: "setsockopt",
	170: "settimeofday",
	146: "setuid",
	5:   "setxattr",
	463: "setxattrat",
	196: "shmat",
	195: "shmctl",
	197: "shmdt",
	194: "shmget",
	210: "shutdown",
	132: "sigaltstack",
	74:  "signalfd4",
	198: "socket",
	199: "socketpair",
	76:  "splice",
	43:  "statfs",
	457: "statmount",
	291: "statx",
	225: "swapoff",
	224: "swapon",
	36:  "symlinkat",
	81:  "sync",
	84:  "sync_file_range",
	267: "syncfs",
	179: "sysinfo",
	116: "syslog",
	77:  "tee",
	131: "tgkill",
	107: "timer_create",
	111: "timer_delete",
	109: "timer_getoverrun",
	108: "timer_gettime",
	110: "timer_settime",
	85:  "timerfd_create",
	87:  "timerfd_gettime",
	86:  "timerfd_settime",
	153: "times",
	130: "tkill",
	45:  "truncate",
	166: "umask",
	39:  "umount2",
	160: "uname",
	35:  "unlinkat",
	97:  "unshare",
	282: "userfaultfd",
	88:  "utimensat",
	58:  "vhangup",
	75:  "vmsplice",
	260: "wait4",
	95:  "waitid",
	64:  "write",
	66:  "writev",
}
