message(STATUS "======= Welcome to Molsketch build =======")
message(STATUS "Sources in: ${CMAKE_CURRENT_SOURCE_DIR}")
message(STATUS "Installation settings and corresponding cmake variables (use \"-D <variableName>=<value>\" to change):")

file(STRINGS buildvariables BUILD_VARIABLES)
list(APPEND BUILD_VARIABLES "\"Build static application\"\;MSK_STATIC_LIB\;false\;false")
foreach(buildvar ${BUILD_VARIABLES})
        list(GET buildvar 0 descriptor)
        list(GET buildvar 1 variableName)
        list(GET buildvar 2 defaultValue)
        list(GET buildvar 3 winDefaultValue)
        if(NOT DEFINED ${variableName})
                set(${variableName} "${defaultValue}")
                if(WIN32 OR WIN64)
                        set(${variableName} "${winDefaultValue}")
                endif(WIN32 OR WIN64)
        endif(NOT DEFINED ${variableName})
        if(variableName MATCHES ".*INSTALL.*")
                set(${variableName} "${MSK_PREFIX}${${variableName}}")
        endif(variableName MATCHES ".*INSTALL.*")
        message(STATUS "    ${descriptor}: ${variableName} = ${${variableName}}")
        add_definitions(-D${variableName}="\\\"${${variableName}}\\\"")
endforeach(buildvar BUILD_VARIABLES)
