# Release Notes - v2.8.35

**Date**: 2026-02-02

## 📝 Executive Summary

```text
2.8.35 2026-02-02

- feat: modernize version check using `HTTP::Tiny` with robust fallback to `curl`/`wget` (PR #18 and #17).
- feat: integrate `perltidy` in `release-preflight` workflow and enforce script formatting (issue #19).
- fix: resolve inaccurate `innodb_log_file_size` recommendations caused by integer rounding (issue #770).
- fix: ensure percentage returns 100.00% instead of 0% on idle or fresh servers, preventing unwarranted `innodb_log_buffer_size` recommendations (issue #783).
- test: add dedicated unit test `tests/test_version_regex.t` for version extraction verification.
- test: add regression test `tests/issue_770.t` to verify `innodb_log_file_size` recommendation precision.
- test: add regression test `tests/issue_783.t` to verify `innodb_log_buffer_size` recommendation on idle servers.
- docs: replace generic `SECURITY.md` template with project-specific policy and contact info (Issue #771, credit @bfontaine).
- style: run `perltidy` on `mysqltuner.pl` to ensure code consistency.
# MySQLTuner Changelog
```

## 📈 Diagnostic Growth Indicators

| Metric | Current | Progress | Status |
| :--- | :--- | :--- | :--- |
| Total Indicators | 12 | +12 | 🚀 |
| Efficiency Checks | 0 | 0 | 🛡️ |
| Risk Detections | 2 | +2 | 🚀 |
| Information Points | 10 | +10 | 🚀 |

## 🧪 New Diagnostic Capabilities

### 🛑 New Risk Detections
- Table $dbname.$tbname has no index defined
- innodb_snapshot_isolation is OFF with REPEATABLE-READ (Stricter snapshot isolation is disabled)

### ℹ️ New Information Points
- Auto-generating raw output file: $raw_output_file
- Dumpdir: $opt{dumpdir}
- Dumping information schema
- Dumping performance schema
- Dumping sys schema
- General MyIsam metrics:
- InnoDB Snapshot Isolation: 
- SKIPPING $sys_view
- Transaction Isolation Level: $isolation
- table_definition_cache (

## 🛠️ Internal Commit History

Initial release or no previous tag found.

## ⚙️ Technical Evolutions

### ➕ CLI Options Added
- `--CLOUD`
- `--CONNECTION`
- `--MISC`
- `--Modeling`
- `--OUTPUT`
- `--PERFORMANCE`
- `--Performance`
- `--Security`
- `--System`
- `--azure`
- `--bannedports`
- `--buffers`
- `--checkversion`
- `--cloud`
- `--container`
- `--cvefile`
- `--data`
- `--dbgpattern`
- `--debug`
- `--defaultarch`
- `--defaults-extra-file`
- `--defaults-file`
- `--dumpdir`
- `--experimental`
- `--feature`
- `--forcemem`
- `--forceswap`
- `--host`
- `--ignore-tables`
- `--json`
- `--max-password-checks`
- `--maxportallowed`
- `--mysqladmin`
- `--mysqlcmd`
- `--noask`
- `--nobad`
- `--nogood`
- `--noinfo`
- `--nondedicated`
- `--noprettyicon`
- `--noprocess`
- `--outputfile`
- `--passenv`
- `--passwordfile`
- `--pipe`
- `--pipe_name`
- `--port`
- `--prettyjson`
- `--protocol`
- `--reportfile`
- `--schemadir`
- `--server-log`
- `--silent`
- `--skippassword`
- `--skipsize`
- `--socket`
- `--ssh-host`
- `--ssh-identity-file`
- `--ssh-password`
- `--ssh-user`
- `--ssl-ca`
- `--template`
- `--updateversion`
- `--userenv`

## ✅ Laboratory Verification Results

- [x] Automated TDD suite passed.
- [x] Multi-DB version laboratory execution validated.
- [x] Performance indicator delta analysis completed.
