/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dv.xs;

import com.sun.org.apache.xerces.internal.impl.dv.InvalidDatatypeValueException;
import com.sun.org.apache.xerces.internal.impl.dv.ValidationContext;
import com.sun.org.apache.xerces.internal.impl.dv.xs.TypeValidator;
import com.sun.org.apache.xerces.internal.util.URI;
import java.io.UnsupportedEncodingException;

public class AnyURIDV
extends TypeValidator {
    private static final URI BASE_URI;
    private static boolean[] gNeedEscaping;
    private static char[] gAfterEscaping1;
    private static char[] gAfterEscaping2;
    private static char[] gHexChs;

    @Override
    public short getAllowedFacets() {
        return 2079;
    }

    @Override
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            if (content.length() != 0) {
                String encoded = AnyURIDV.encode(content);
                new URI(BASE_URI, encoded);
            }
        }
        catch (URI.MalformedURIException ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "anyURI"});
        }
        return content;
    }

    private static String encode(String anyURI) {
        int ch;
        int i;
        int len = anyURI.length();
        StringBuffer buffer = new StringBuffer(len * 3);
        for (i = 0; i < len && (ch = anyURI.charAt(i)) < 128; ++i) {
            if (gNeedEscaping[ch]) {
                buffer.append('%');
                buffer.append(gAfterEscaping1[ch]);
                buffer.append(gAfterEscaping2[ch]);
                continue;
            }
            buffer.append((char)ch);
        }
        if (i < len) {
            byte[] bytes = null;
            try {
                bytes = anyURI.substring(i).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return anyURI;
            }
            len = bytes.length;
            for (i = 0; i < len; ++i) {
                byte b = bytes[i];
                if (b < 0) {
                    ch = b + 256;
                    buffer.append('%');
                    buffer.append(gHexChs[ch >> 4]);
                    buffer.append(gHexChs[ch & 0xF]);
                    continue;
                }
                if (gNeedEscaping[b]) {
                    buffer.append('%');
                    buffer.append(gAfterEscaping1[b]);
                    buffer.append(gAfterEscaping2[b]);
                    continue;
                }
                buffer.append((char)b);
            }
        }
        if (buffer.length() != len) {
            return buffer.toString();
        }
        return anyURI;
    }

    static {
        URI uri = null;
        try {
            uri = new URI("abc://def.ghi.jkl");
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
        BASE_URI = uri;
        gNeedEscaping = new boolean[128];
        gAfterEscaping1 = new char[128];
        gAfterEscaping2 = new char[128];
        gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i <= 31; ++i) {
            AnyURIDV.gNeedEscaping[i] = true;
            AnyURIDV.gAfterEscaping1[i] = gHexChs[i >> 4];
            AnyURIDV.gAfterEscaping2[i] = gHexChs[i & 0xF];
        }
        AnyURIDV.gNeedEscaping[127] = true;
        AnyURIDV.gAfterEscaping1[127] = 55;
        AnyURIDV.gAfterEscaping2[127] = 70;
        for (char ch : new char[]{' ', '<', '>', '\"', '{', '}', '|', '\\', '^', '~', '`'}) {
            AnyURIDV.gNeedEscaping[ch] = true;
            AnyURIDV.gAfterEscaping1[ch] = gHexChs[ch >> 4];
            AnyURIDV.gAfterEscaping2[ch] = gHexChs[ch & 0xF];
        }
    }
}

