/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2019 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * abs.  Add abs constantV2,  z = abs( z + constant) - abs( z - constant) - z:
 * This formula contains aux.color

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_abs_add_tglad_fold4d.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfAbsAddTgladFold4dIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 limit = fractal->transformCommon.additionConstant0000;

	REAL4 oldZ = z;

	if (fractal->transformCommon.functionEnabledAx
			&& aux->i >= fractal->transformCommon.startIterationsA
			&& aux->i < fractal->transformCommon.stopIterationsA)
		z.x = fabs(z.x + limit.x) - fabs(z.x - limit.x) - z.x;

	if (fractal->transformCommon.functionEnabledAy
			&& aux->i >= fractal->transformCommon.startIterationsB
			&& aux->i < fractal->transformCommon.stopIterationsB)
		z.y = fabs(z.y + limit.y) - fabs(z.y - limit.y) - z.y;

	if (fractal->transformCommon.functionEnabledAz
			&& aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC)
		z.z = fabs(z.z + limit.z) - fabs(z.z - limit.z) - z.z;

	if (fractal->transformCommon.functionEnabledAw
			&& aux->i >= fractal->transformCommon.startIterationsD
			&& aux->i < fractal->transformCommon.stopIterationsD)
		z.w = fabs(z.w + limit.w) - fabs(z.w - limit.w) - z.w;

	if (fractal->foldColor.auxColorEnabledFalse)
	{
		if (!fractal->transformCommon.functionEnabledCxFalse)
		{
			if (z.x != oldZ.x) aux->color += fractal->mandelbox.color.factor4D.x;
			if (z.y != oldZ.y) aux->color += fractal->mandelbox.color.factor4D.y;
			if (z.z != oldZ.z) aux->color += fractal->mandelbox.color.factor4D.z;
			if (z.w != oldZ.w) aux->color += fractal->mandelbox.color.factor4D.w;
		}
		else
		{
			if (z.x != oldZ.x) aux->color += fractal->mandelbox.color.factor4D.x * (fabs(z.x) - limit.x);
			if (z.y != oldZ.y) aux->color += fractal->mandelbox.color.factor4D.y * (fabs(z.y) - limit.y);
			if (z.z != oldZ.z) aux->color += fractal->mandelbox.color.factor4D.z * (fabs(z.z) - limit.z);
			if (z.w != oldZ.w) aux->color += fractal->mandelbox.color.factor4D.w * (fabs(z.w) - limit.w);
		}
	}
	return z;
}