// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test2.proto

#ifndef GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_GOLDEN_REST_ONLY_REST_STUB_H
#define GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_GOLDEN_REST_ONLY_REST_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/internal/rest_client.h"
#include "google/cloud/internal/rest_context.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <generator/integration_tests/test2.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class GoldenRestOnlyRestStub {
 public:
  virtual ~GoldenRestOnlyRestStub() = default;

  virtual Status Noop(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options, google::protobuf::Empty const& request) = 0;
};

class DefaultGoldenRestOnlyRestStub : public GoldenRestOnlyRestStub {
 public:
  ~DefaultGoldenRestOnlyRestStub() override = default;

  explicit DefaultGoldenRestOnlyRestStub(Options options);
  DefaultGoldenRestOnlyRestStub(
      std::shared_ptr<rest_internal::RestClient> service,
      Options options);

  Status Noop(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options, google::protobuf::Empty const& request) override;

 private:
  std::shared_ptr<rest_internal::RestClient> service_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_GOLDEN_REST_ONLY_REST_STUB_H
