// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/billing/v1/cloud_billing.proto

#include "google/cloud/billing/v1/internal/cloud_billing_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/billing/v1/cloud_billing.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace billing_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudBillingStub::~CloudBillingStub() = default;

StatusOr<google::cloud::billing::v1::BillingAccount>
DefaultCloudBillingStub::GetBillingAccount(
    grpc::ClientContext& context, Options const&,
    google::cloud::billing::v1::GetBillingAccountRequest const& request) {
  google::cloud::billing::v1::BillingAccount response;
  auto status = grpc_stub_->GetBillingAccount(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::billing::v1::ListBillingAccountsResponse>
DefaultCloudBillingStub::ListBillingAccounts(
    grpc::ClientContext& context, Options const&,
    google::cloud::billing::v1::ListBillingAccountsRequest const& request) {
  google::cloud::billing::v1::ListBillingAccountsResponse response;
  auto status = grpc_stub_->ListBillingAccounts(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::billing::v1::BillingAccount>
DefaultCloudBillingStub::UpdateBillingAccount(
    grpc::ClientContext& context, Options const&,
    google::cloud::billing::v1::UpdateBillingAccountRequest const& request) {
  google::cloud::billing::v1::BillingAccount response;
  auto status = grpc_stub_->UpdateBillingAccount(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::billing::v1::BillingAccount>
DefaultCloudBillingStub::CreateBillingAccount(
    grpc::ClientContext& context, Options const&,
    google::cloud::billing::v1::CreateBillingAccountRequest const& request) {
  google::cloud::billing::v1::BillingAccount response;
  auto status = grpc_stub_->CreateBillingAccount(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::billing::v1::ListProjectBillingInfoResponse>
DefaultCloudBillingStub::ListProjectBillingInfo(
    grpc::ClientContext& context, Options const&,
    google::cloud::billing::v1::ListProjectBillingInfoRequest const& request) {
  google::cloud::billing::v1::ListProjectBillingInfoResponse response;
  auto status =
      grpc_stub_->ListProjectBillingInfo(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::billing::v1::ProjectBillingInfo>
DefaultCloudBillingStub::GetProjectBillingInfo(
    grpc::ClientContext& context, Options const&,
    google::cloud::billing::v1::GetProjectBillingInfoRequest const& request) {
  google::cloud::billing::v1::ProjectBillingInfo response;
  auto status = grpc_stub_->GetProjectBillingInfo(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::billing::v1::ProjectBillingInfo>
DefaultCloudBillingStub::UpdateProjectBillingInfo(
    grpc::ClientContext& context, Options const&,
    google::cloud::billing::v1::UpdateProjectBillingInfoRequest const&
        request) {
  google::cloud::billing::v1::ProjectBillingInfo response;
  auto status =
      grpc_stub_->UpdateProjectBillingInfo(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::iam::v1::Policy> DefaultCloudBillingStub::GetIamPolicy(
    grpc::ClientContext& context, Options const&,
    google::iam::v1::GetIamPolicyRequest const& request) {
  google::iam::v1::Policy response;
  auto status = grpc_stub_->GetIamPolicy(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::iam::v1::Policy> DefaultCloudBillingStub::SetIamPolicy(
    grpc::ClientContext& context, Options const&,
    google::iam::v1::SetIamPolicyRequest const& request) {
  google::iam::v1::Policy response;
  auto status = grpc_stub_->SetIamPolicy(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DefaultCloudBillingStub::TestIamPermissions(
    grpc::ClientContext& context, Options const&,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  google::iam::v1::TestIamPermissionsResponse response;
  auto status = grpc_stub_->TestIamPermissions(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::billing::v1::BillingAccount>
DefaultCloudBillingStub::MoveBillingAccount(
    grpc::ClientContext& context, Options const&,
    google::cloud::billing::v1::MoveBillingAccountRequest const& request) {
  google::cloud::billing::v1::BillingAccount response;
  auto status = grpc_stub_->MoveBillingAccount(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace billing_v1_internal
}  // namespace cloud
}  // namespace google
