// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudbuild/v2/repositories.proto

#include "google/cloud/cloudbuild/v2/internal/repository_manager_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace cloudbuild_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RepositoryManagerTracingConnection::RepositoryManagerTracingConnection(
    std::shared_ptr<cloudbuild_v2::RepositoryManagerConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::devtools::cloudbuild::v2::Connection>>
RepositoryManagerTracingConnection::CreateConnection(
    google::devtools::cloudbuild::v2::CreateConnectionRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::CreateConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateConnection(request));
}

StatusOr<google::longrunning::Operation>
RepositoryManagerTracingConnection::CreateConnection(
    NoAwaitTag,
    google::devtools::cloudbuild::v2::CreateConnectionRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::CreateConnection");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateConnection(NoAwaitTag{}, request));
}

future<StatusOr<google::devtools::cloudbuild::v2::Connection>>
RepositoryManagerTracingConnection::CreateConnection(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::CreateConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateConnection(operation));
}

StatusOr<google::devtools::cloudbuild::v2::Connection>
RepositoryManagerTracingConnection::GetConnection(
    google::devtools::cloudbuild::v2::GetConnectionRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::GetConnection");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetConnection(request));
}

StreamRange<google::devtools::cloudbuild::v2::Connection>
RepositoryManagerTracingConnection::ListConnections(
    google::devtools::cloudbuild::v2::ListConnectionsRequest request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::ListConnections");
  internal::OTelScope scope(span);
  auto sr = child_->ListConnections(std::move(request));
  return internal::MakeTracedStreamRange<
      google::devtools::cloudbuild::v2::Connection>(std::move(span),
                                                    std::move(sr));
}

future<StatusOr<google::devtools::cloudbuild::v2::Connection>>
RepositoryManagerTracingConnection::UpdateConnection(
    google::devtools::cloudbuild::v2::UpdateConnectionRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::UpdateConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateConnection(request));
}

StatusOr<google::longrunning::Operation>
RepositoryManagerTracingConnection::UpdateConnection(
    NoAwaitTag,
    google::devtools::cloudbuild::v2::UpdateConnectionRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::UpdateConnection");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateConnection(NoAwaitTag{}, request));
}

future<StatusOr<google::devtools::cloudbuild::v2::Connection>>
RepositoryManagerTracingConnection::UpdateConnection(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::UpdateConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateConnection(operation));
}

future<StatusOr<google::devtools::cloudbuild::v2::OperationMetadata>>
RepositoryManagerTracingConnection::DeleteConnection(
    google::devtools::cloudbuild::v2::DeleteConnectionRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::DeleteConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteConnection(request));
}

StatusOr<google::longrunning::Operation>
RepositoryManagerTracingConnection::DeleteConnection(
    NoAwaitTag,
    google::devtools::cloudbuild::v2::DeleteConnectionRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::DeleteConnection");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteConnection(NoAwaitTag{}, request));
}

future<StatusOr<google::devtools::cloudbuild::v2::OperationMetadata>>
RepositoryManagerTracingConnection::DeleteConnection(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::DeleteConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteConnection(operation));
}

future<StatusOr<google::devtools::cloudbuild::v2::Repository>>
RepositoryManagerTracingConnection::CreateRepository(
    google::devtools::cloudbuild::v2::CreateRepositoryRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::CreateRepository");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateRepository(request));
}

StatusOr<google::longrunning::Operation>
RepositoryManagerTracingConnection::CreateRepository(
    NoAwaitTag,
    google::devtools::cloudbuild::v2::CreateRepositoryRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::CreateRepository");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateRepository(NoAwaitTag{}, request));
}

future<StatusOr<google::devtools::cloudbuild::v2::Repository>>
RepositoryManagerTracingConnection::CreateRepository(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::CreateRepository");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateRepository(operation));
}

future<
    StatusOr<google::devtools::cloudbuild::v2::BatchCreateRepositoriesResponse>>
RepositoryManagerTracingConnection::BatchCreateRepositories(
    google::devtools::cloudbuild::v2::BatchCreateRepositoriesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::BatchCreateRepositories");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchCreateRepositories(request));
}

StatusOr<google::longrunning::Operation>
RepositoryManagerTracingConnection::BatchCreateRepositories(
    NoAwaitTag,
    google::devtools::cloudbuild::v2::BatchCreateRepositoriesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::BatchCreateRepositories");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->BatchCreateRepositories(NoAwaitTag{}, request));
}

future<
    StatusOr<google::devtools::cloudbuild::v2::BatchCreateRepositoriesResponse>>
RepositoryManagerTracingConnection::BatchCreateRepositories(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::BatchCreateRepositories");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchCreateRepositories(operation));
}

StatusOr<google::devtools::cloudbuild::v2::Repository>
RepositoryManagerTracingConnection::GetRepository(
    google::devtools::cloudbuild::v2::GetRepositoryRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::GetRepository");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetRepository(request));
}

StreamRange<google::devtools::cloudbuild::v2::Repository>
RepositoryManagerTracingConnection::ListRepositories(
    google::devtools::cloudbuild::v2::ListRepositoriesRequest request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::ListRepositories");
  internal::OTelScope scope(span);
  auto sr = child_->ListRepositories(std::move(request));
  return internal::MakeTracedStreamRange<
      google::devtools::cloudbuild::v2::Repository>(std::move(span),
                                                    std::move(sr));
}

future<StatusOr<google::devtools::cloudbuild::v2::OperationMetadata>>
RepositoryManagerTracingConnection::DeleteRepository(
    google::devtools::cloudbuild::v2::DeleteRepositoryRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::DeleteRepository");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteRepository(request));
}

StatusOr<google::longrunning::Operation>
RepositoryManagerTracingConnection::DeleteRepository(
    NoAwaitTag,
    google::devtools::cloudbuild::v2::DeleteRepositoryRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::DeleteRepository");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteRepository(NoAwaitTag{}, request));
}

future<StatusOr<google::devtools::cloudbuild::v2::OperationMetadata>>
RepositoryManagerTracingConnection::DeleteRepository(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::DeleteRepository");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteRepository(operation));
}

StatusOr<google::devtools::cloudbuild::v2::FetchReadWriteTokenResponse>
RepositoryManagerTracingConnection::FetchReadWriteToken(
    google::devtools::cloudbuild::v2::FetchReadWriteTokenRequest const&
        request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::FetchReadWriteToken");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->FetchReadWriteToken(request));
}

StatusOr<google::devtools::cloudbuild::v2::FetchReadTokenResponse>
RepositoryManagerTracingConnection::FetchReadToken(
    google::devtools::cloudbuild::v2::FetchReadTokenRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::FetchReadToken");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->FetchReadToken(request));
}

StreamRange<google::devtools::cloudbuild::v2::Repository>
RepositoryManagerTracingConnection::FetchLinkableRepositories(
    google::devtools::cloudbuild::v2::FetchLinkableRepositoriesRequest
        request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::FetchLinkableRepositories");
  internal::OTelScope scope(span);
  auto sr = child_->FetchLinkableRepositories(std::move(request));
  return internal::MakeTracedStreamRange<
      google::devtools::cloudbuild::v2::Repository>(std::move(span),
                                                    std::move(sr));
}

StatusOr<google::devtools::cloudbuild::v2::FetchGitRefsResponse>
RepositoryManagerTracingConnection::FetchGitRefs(
    google::devtools::cloudbuild::v2::FetchGitRefsRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v2::RepositoryManagerConnection::FetchGitRefs");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->FetchGitRefs(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<cloudbuild_v2::RepositoryManagerConnection>
MakeRepositoryManagerTracingConnection(
    std::shared_ptr<cloudbuild_v2::RepositoryManagerConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<RepositoryManagerTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudbuild_v2_internal
}  // namespace cloud
}  // namespace google
