// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/images/v1/images.proto

#include "google/cloud/compute/images/v1/images_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_images_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ImagesConnectionIdempotencyPolicy::~ImagesConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<ImagesConnectionIdempotencyPolicy>
ImagesConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ImagesConnectionIdempotencyPolicy>(*this);
}

Idempotency ImagesConnectionIdempotencyPolicy::DeleteImage(
    google::cloud::cpp::compute::images::v1::DeleteImageRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ImagesConnectionIdempotencyPolicy::Deprecate(
    google::cloud::cpp::compute::images::v1::DeprecateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ImagesConnectionIdempotencyPolicy::GetImage(
    google::cloud::cpp::compute::images::v1::GetImageRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ImagesConnectionIdempotencyPolicy::GetFromFamily(
    google::cloud::cpp::compute::images::v1::GetFromFamilyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ImagesConnectionIdempotencyPolicy::GetIamPolicy(
    google::cloud::cpp::compute::images::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ImagesConnectionIdempotencyPolicy::InsertImage(
    google::cloud::cpp::compute::images::v1::InsertImageRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ImagesConnectionIdempotencyPolicy::ListImages(
    google::cloud::cpp::compute::images::v1::ListImagesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ImagesConnectionIdempotencyPolicy::PatchImage(
    google::cloud::cpp::compute::images::v1::PatchImageRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ImagesConnectionIdempotencyPolicy::SetIamPolicy(
    google::cloud::cpp::compute::images::v1::SetIamPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ImagesConnectionIdempotencyPolicy::SetLabels(
    google::cloud::cpp::compute::images::v1::SetLabelsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ImagesConnectionIdempotencyPolicy::TestIamPermissions(
    google::cloud::cpp::compute::images::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<ImagesConnectionIdempotencyPolicy>
MakeDefaultImagesConnectionIdempotencyPolicy() {
  return std::make_unique<ImagesConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_images_v1
}  // namespace cloud
}  // namespace google
