// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/resource_policies/v1/resource_policies.proto

#include "google/cloud/compute/resource_policies/v1/internal/resource_policies_rest_metadata_decorator.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/rest_set_metadata.h"
#include "google/cloud/status_or.h"
#include "absl/strings/str_format.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_resource_policies_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ResourcePoliciesRestMetadata::ResourcePoliciesRestMetadata(
    std::shared_ptr<ResourcePoliciesRestStub> child,
    std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::cpp::compute::v1::ResourcePolicyAggregatedList>
ResourcePoliciesRestMetadata::AggregatedListResourcePolicies(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::resource_policies::v1::
        AggregatedListResourcePoliciesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->AggregatedListResourcePolicies(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesRestMetadata::AsyncDeleteResourcePolicy(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::resource_policies::v1::
        DeleteResourcePolicyRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncDeleteResourcePolicy(cq, std::move(rest_context),
                                           std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
ResourcePoliciesRestMetadata::DeleteResourcePolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::resource_policies::v1::
        DeleteResourcePolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->DeleteResourcePolicy(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::ResourcePolicy>
ResourcePoliciesRestMetadata::GetResourcePolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::resource_policies::v1::
        GetResourcePolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetResourcePolicy(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
ResourcePoliciesRestMetadata::GetIamPolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::resource_policies::v1::
        GetIamPolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetIamPolicy(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesRestMetadata::AsyncInsertResourcePolicy(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::resource_policies::v1::
        InsertResourcePolicyRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncInsertResourcePolicy(cq, std::move(rest_context),
                                           std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
ResourcePoliciesRestMetadata::InsertResourcePolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::resource_policies::v1::
        InsertResourcePolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->InsertResourcePolicy(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::ResourcePolicyList>
ResourcePoliciesRestMetadata::ListResourcePolicies(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::resource_policies::v1::
        ListResourcePoliciesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListResourcePolicies(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesRestMetadata::AsyncPatchResourcePolicy(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::resource_policies::v1::
        PatchResourcePolicyRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncPatchResourcePolicy(cq, std::move(rest_context),
                                          std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
ResourcePoliciesRestMetadata::PatchResourcePolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::resource_policies::v1::
        PatchResourcePolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->PatchResourcePolicy(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
ResourcePoliciesRestMetadata::SetIamPolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::resource_policies::v1::
        SetIamPolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetIamPolicy(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
ResourcePoliciesRestMetadata::TestIamPermissions(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::resource_policies::v1::
        TestIamPermissionsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->TestIamPermissions(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesRestMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::region_operations::v1::
        GetOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncGetOperation(cq, std::move(rest_context),
                                   std::move(options), request);
}

future<Status> ResourcePoliciesRestMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::region_operations::v1::
        DeleteOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCancelOperation(cq, std::move(rest_context),
                                      std::move(options), request);
}

void ResourcePoliciesRestMetadata::SetMetadata(
    rest_internal::RestContext& rest_context, Options const& options,
    std::vector<std::string> const& params) {
  google::cloud::rest_internal::SetMetadata(rest_context, options, params,
                                            api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_resource_policies_v1_internal
}  // namespace cloud
}  // namespace google
