// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/storage_pool_types/v1/storage_pool_types.proto

#include "google/cloud/compute/storage_pool_types/v1/internal/storage_pool_types_rest_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_storage_pool_types_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

StoragePoolTypesRestLogging::StoragePoolTypesRestLogging(
    std::shared_ptr<StoragePoolTypesRestStub> child,
    TracingOptions tracing_options, std::set<std::string> components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      components_(std::move(components)) {}

StatusOr<google::cloud::cpp::compute::v1::StoragePoolTypeAggregatedList>
StoragePoolTypesRestLogging::AggregatedListStoragePoolTypes(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::storage_pool_types::v1::
        AggregatedListStoragePoolTypesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::storage_pool_types::v1::
                 AggregatedListStoragePoolTypesRequest const& request) {
        return child_->AggregatedListStoragePoolTypes(rest_context, options,
                                                      request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::StoragePoolType>
StoragePoolTypesRestLogging::GetStoragePoolType(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::storage_pool_types::v1::
        GetStoragePoolTypeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::storage_pool_types::v1::
                 GetStoragePoolTypeRequest const& request) {
        return child_->GetStoragePoolType(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::StoragePoolTypeList>
StoragePoolTypesRestLogging::ListStoragePoolTypes(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::storage_pool_types::v1::
        ListStoragePoolTypesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::storage_pool_types::v1::
                 ListStoragePoolTypesRequest const& request) {
        return child_->ListStoragePoolTypes(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_storage_pool_types_v1_internal
}  // namespace cloud
}  // namespace google
