// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/v1/datastore.proto

#include "google/cloud/datastore/v1/internal/datastore_connection_impl.h"
#include "google/cloud/datastore/v1/internal/datastore_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace datastore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<datastore_v1::DatastoreRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<datastore_v1::DatastoreRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<datastore_v1::DatastoreBackoffPolicyOption>()->clone();
}

std::unique_ptr<datastore_v1::DatastoreConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<datastore_v1::DatastoreConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

DatastoreConnectionImpl::DatastoreConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<datastore_v1_internal::DatastoreStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      DatastoreConnection::options())) {}

StatusOr<google::datastore::v1::LookupResponse> DatastoreConnectionImpl::Lookup(
    google::datastore::v1::LookupRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->Lookup(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::datastore::v1::LookupRequest const& request) {
        return stub_->Lookup(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::datastore::v1::RunQueryResponse>
DatastoreConnectionImpl::RunQuery(
    google::datastore::v1::RunQueryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RunQuery(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::datastore::v1::RunQueryRequest const& request) {
        return stub_->RunQuery(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::datastore::v1::RunAggregationQueryResponse>
DatastoreConnectionImpl::RunAggregationQuery(
    google::datastore::v1::RunAggregationQueryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RunAggregationQuery(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::datastore::v1::RunAggregationQueryRequest const& request) {
        return stub_->RunAggregationQuery(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::datastore::v1::BeginTransactionResponse>
DatastoreConnectionImpl::BeginTransaction(
    google::datastore::v1::BeginTransactionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BeginTransaction(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::datastore::v1::BeginTransactionRequest const& request) {
        return stub_->BeginTransaction(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::datastore::v1::CommitResponse> DatastoreConnectionImpl::Commit(
    google::datastore::v1::CommitRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->Commit(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::datastore::v1::CommitRequest const& request) {
        return stub_->Commit(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::datastore::v1::RollbackResponse>
DatastoreConnectionImpl::Rollback(
    google::datastore::v1::RollbackRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->Rollback(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::datastore::v1::RollbackRequest const& request) {
        return stub_->Rollback(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::datastore::v1::AllocateIdsResponse>
DatastoreConnectionImpl::AllocateIds(
    google::datastore::v1::AllocateIdsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->AllocateIds(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::datastore::v1::AllocateIdsRequest const& request) {
        return stub_->AllocateIds(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::datastore::v1::ReserveIdsResponse>
DatastoreConnectionImpl::ReserveIds(
    google::datastore::v1::ReserveIdsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ReserveIds(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::datastore::v1::ReserveIdsRequest const& request) {
        return stub_->ReserveIds(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_v1_internal
}  // namespace cloud
}  // namespace google
