// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/intent.proto

#include "google/cloud/dialogflow_cx/intents_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IntentsClient::IntentsClient(std::shared_ptr<IntentsConnection> connection,
                             Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
IntentsClient::~IntentsClient() = default;

StreamRange<google::cloud::dialogflow::cx::v3::Intent>
IntentsClient::ListIntents(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::ListIntentsRequest request;
  request.set_parent(parent);
  return connection_->ListIntents(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::Intent>
IntentsClient::ListIntents(
    google::cloud::dialogflow::cx::v3::ListIntentsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListIntents(std::move(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::Intent> IntentsClient::GetIntent(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::GetIntentRequest request;
  request.set_name(name);
  return connection_->GetIntent(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Intent> IntentsClient::GetIntent(
    google::cloud::dialogflow::cx::v3::GetIntentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIntent(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Intent> IntentsClient::CreateIntent(
    std::string const& parent,
    google::cloud::dialogflow::cx::v3::Intent const& intent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::CreateIntentRequest request;
  request.set_parent(parent);
  *request.mutable_intent() = intent;
  return connection_->CreateIntent(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Intent> IntentsClient::CreateIntent(
    google::cloud::dialogflow::cx::v3::CreateIntentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateIntent(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Intent> IntentsClient::UpdateIntent(
    google::cloud::dialogflow::cx::v3::Intent const& intent,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::UpdateIntentRequest request;
  *request.mutable_intent() = intent;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateIntent(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Intent> IntentsClient::UpdateIntent(
    google::cloud::dialogflow::cx::v3::UpdateIntentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateIntent(request);
}

Status IntentsClient::DeleteIntent(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::DeleteIntentRequest request;
  request.set_name(name);
  return connection_->DeleteIntent(request);
}

Status IntentsClient::DeleteIntent(
    google::cloud::dialogflow::cx::v3::DeleteIntentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteIntent(request);
}

future<StatusOr<google::cloud::dialogflow::cx::v3::ImportIntentsResponse>>
IntentsClient::ImportIntents(
    google::cloud::dialogflow::cx::v3::ImportIntentsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportIntents(request);
}

StatusOr<google::longrunning::Operation> IntentsClient::ImportIntents(
    NoAwaitTag,
    google::cloud::dialogflow::cx::v3::ImportIntentsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportIntents(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::cx::v3::ImportIntentsResponse>>
IntentsClient::ImportIntents(google::longrunning::Operation const& operation,
                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportIntents(operation);
}

future<StatusOr<google::cloud::dialogflow::cx::v3::ExportIntentsResponse>>
IntentsClient::ExportIntents(
    google::cloud::dialogflow::cx::v3::ExportIntentsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportIntents(request);
}

StatusOr<google::longrunning::Operation> IntentsClient::ExportIntents(
    NoAwaitTag,
    google::cloud::dialogflow::cx::v3::ExportIntentsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportIntents(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::cx::v3::ExportIntentsResponse>>
IntentsClient::ExportIntents(google::longrunning::Operation const& operation,
                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportIntents(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
