// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/language/v1/language_service.proto

#include "google/cloud/language/v1/internal/language_auth_decorator.h"
#include <google/cloud/language/v1/language_service.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace language_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

LanguageServiceAuth::LanguageServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<LanguageServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::language::v1::AnalyzeSentimentResponse>
LanguageServiceAuth::AnalyzeSentiment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::language::v1::AnalyzeSentimentRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->AnalyzeSentiment(context, options, request);
}

StatusOr<google::cloud::language::v1::AnalyzeEntitiesResponse>
LanguageServiceAuth::AnalyzeEntities(
    grpc::ClientContext& context, Options const& options,
    google::cloud::language::v1::AnalyzeEntitiesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->AnalyzeEntities(context, options, request);
}

StatusOr<google::cloud::language::v1::AnalyzeEntitySentimentResponse>
LanguageServiceAuth::AnalyzeEntitySentiment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::language::v1::AnalyzeEntitySentimentRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->AnalyzeEntitySentiment(context, options, request);
}

StatusOr<google::cloud::language::v1::AnalyzeSyntaxResponse>
LanguageServiceAuth::AnalyzeSyntax(
    grpc::ClientContext& context, Options const& options,
    google::cloud::language::v1::AnalyzeSyntaxRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->AnalyzeSyntax(context, options, request);
}

StatusOr<google::cloud::language::v1::ClassifyTextResponse>
LanguageServiceAuth::ClassifyText(
    grpc::ClientContext& context, Options const& options,
    google::cloud::language::v1::ClassifyTextRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ClassifyText(context, options, request);
}

StatusOr<google::cloud::language::v1::ModerateTextResponse>
LanguageServiceAuth::ModerateText(
    grpc::ClientContext& context, Options const& options,
    google::cloud::language::v1::ModerateTextRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ModerateText(context, options, request);
}

StatusOr<google::cloud::language::v1::AnnotateTextResponse>
LanguageServiceAuth::AnnotateText(
    grpc::ClientContext& context, Options const& options,
    google::cloud::language::v1::AnnotateTextRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->AnnotateText(context, options, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace language_v1_internal
}  // namespace cloud
}  // namespace google
