// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkconnectivity/v1/policy_based_routing.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_POLICY_BASED_ROUTING_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_POLICY_BASED_ROUTING_CLIENT_H

#include "google/cloud/networkconnectivity/v1/policy_based_routing_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace networkconnectivity_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Policy-Based Routing allows GCP customers to specify flexibile routing
/// policies for Layer 4 traffic traversing through the connected service.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class PolicyBasedRoutingServiceClient {
 public:
  explicit PolicyBasedRoutingServiceClient(
      std::shared_ptr<PolicyBasedRoutingServiceConnection> connection,
      Options opts = {});
  ~PolicyBasedRoutingServiceClient();

  ///@{
  /// @name Copy and move support
  PolicyBasedRoutingServiceClient(PolicyBasedRoutingServiceClient const&) =
      default;
  PolicyBasedRoutingServiceClient& operator=(
      PolicyBasedRoutingServiceClient const&) = default;
  PolicyBasedRoutingServiceClient(PolicyBasedRoutingServiceClient&&) = default;
  PolicyBasedRoutingServiceClient& operator=(
      PolicyBasedRoutingServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(PolicyBasedRoutingServiceClient const& a,
                         PolicyBasedRoutingServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(PolicyBasedRoutingServiceClient const& a,
                         PolicyBasedRoutingServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists PolicyBasedRoutes in a given project and location.
  ///
  /// @param parent  Required. The parent resource's name.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkconnectivity.v1.PolicyBasedRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.ListPolicyBasedRoutesRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/policy_based_routing.proto#L265}
  /// [google.cloud.networkconnectivity.v1.PolicyBasedRoute]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/policy_based_routing.proto#L95}
  ///
  // clang-format on
  StreamRange<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
  ListPolicyBasedRoutes(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists PolicyBasedRoutes in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.ListPolicyBasedRoutesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkconnectivity.v1.PolicyBasedRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.ListPolicyBasedRoutesRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/policy_based_routing.proto#L265}
  /// [google.cloud.networkconnectivity.v1.PolicyBasedRoute]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/policy_based_routing.proto#L95}
  ///
  // clang-format on
  StreamRange<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
  ListPolicyBasedRoutes(
      google::cloud::networkconnectivity::v1::ListPolicyBasedRoutesRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single PolicyBasedRoute.
  ///
  /// @param name  Required. Name of the PolicyBasedRoute resource to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkconnectivity.v1.PolicyBasedRoute])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.GetPolicyBasedRouteRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/policy_based_routing.proto#L301}
  /// [google.cloud.networkconnectivity.v1.PolicyBasedRoute]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/policy_based_routing.proto#L95}
  ///
  // clang-format on
  StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
  GetPolicyBasedRoute(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single PolicyBasedRoute.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.GetPolicyBasedRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkconnectivity.v1.PolicyBasedRoute])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.GetPolicyBasedRouteRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/policy_based_routing.proto#L301}
  /// [google.cloud.networkconnectivity.v1.PolicyBasedRoute]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/policy_based_routing.proto#L95}
  ///
  // clang-format on
  StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
  GetPolicyBasedRoute(
      google::cloud::networkconnectivity::v1::GetPolicyBasedRouteRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new PolicyBasedRoute in a given project and location.
  ///
  /// @param parent  Required. The parent resource's name of the PolicyBasedRoute.
  /// @param policy_based_route  Required. Initial values for a new Policy Based Route.
  /// @param policy_based_route_id  Required. Unique id for the Policy Based Route to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.PolicyBasedRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.CreatePolicyBasedRouteRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/policy_based_routing.proto#L312}
  /// [google.cloud.networkconnectivity.v1.PolicyBasedRoute]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/policy_based_routing.proto#L95}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>
  CreatePolicyBasedRoute(
      std::string const& parent,
      google::cloud::networkconnectivity::v1::PolicyBasedRoute const&
          policy_based_route,
      std::string const& policy_based_route_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePolicyBasedRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreatePolicyBasedRoute(
      NoAwaitTag, std::string const& parent,
      google::cloud::networkconnectivity::v1::PolicyBasedRoute const&
          policy_based_route,
      std::string const& policy_based_route_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new PolicyBasedRoute in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.CreatePolicyBasedRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.PolicyBasedRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.CreatePolicyBasedRouteRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/policy_based_routing.proto#L312}
  /// [google.cloud.networkconnectivity.v1.PolicyBasedRoute]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/policy_based_routing.proto#L95}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>
  CreatePolicyBasedRoute(google::cloud::networkconnectivity::v1::
                             CreatePolicyBasedRouteRequest const& request,
                         Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePolicyBasedRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreatePolicyBasedRoute(
      NoAwaitTag,
      google::cloud::networkconnectivity::v1::
          CreatePolicyBasedRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePolicyBasedRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>
  CreatePolicyBasedRoute(google::longrunning::Operation const& operation,
                         Options opts = {});

  // clang-format off
  ///
  /// Deletes a single PolicyBasedRoute.
  ///
  /// @param name  Required. Name of the PolicyBasedRoute resource to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.DeletePolicyBasedRouteRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/policy_based_routing.proto#L345}
  /// [google.cloud.networkconnectivity.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/common.proto#L40}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
  DeletePolicyBasedRoute(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePolicyBasedRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeletePolicyBasedRoute(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single PolicyBasedRoute.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkconnectivity.v1.DeletePolicyBasedRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkconnectivity.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkconnectivity.v1.DeletePolicyBasedRouteRequest]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/policy_based_routing.proto#L345}
  /// [google.cloud.networkconnectivity.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkconnectivity/v1/common.proto#L40}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
  DeletePolicyBasedRoute(google::cloud::networkconnectivity::v1::
                             DeletePolicyBasedRouteRequest const& request,
                         Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePolicyBasedRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeletePolicyBasedRoute(
      NoAwaitTag,
      google::cloud::networkconnectivity::v1::
          DeletePolicyBasedRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePolicyBasedRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
  DeletePolicyBasedRoute(google::longrunning::Operation const& operation,
                         Options opts = {});

 private:
  std::shared_ptr<PolicyBasedRoutingServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkconnectivity_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_POLICY_BASED_ROUTING_CLIENT_H
