// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkmanagement/v1/reachability.proto

#include "google/cloud/networkmanagement/v1/reachability_connection.h"
#include "google/cloud/networkmanagement/v1/internal/reachability_connection_impl.h"
#include "google/cloud/networkmanagement/v1/internal/reachability_option_defaults.h"
#include "google/cloud/networkmanagement/v1/internal/reachability_stub_factory.h"
#include "google/cloud/networkmanagement/v1/internal/reachability_tracing_connection.h"
#include "google/cloud/networkmanagement/v1/reachability_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkmanagement_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ReachabilityServiceConnection::~ReachabilityServiceConnection() = default;

StreamRange<google::cloud::networkmanagement::v1::ConnectivityTest>
ReachabilityServiceConnection::ListConnectivityTests(
    google::cloud::networkmanagement::v1::
        ListConnectivityTestsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkmanagement::v1::ConnectivityTest>>();
}

StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>
ReachabilityServiceConnection::GetConnectivityTest(
    google::cloud::networkmanagement::v1::GetConnectivityTestRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
ReachabilityServiceConnection::CreateConnectivityTest(
    google::cloud::networkmanagement::v1::
        CreateConnectivityTestRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ReachabilityServiceConnection::CreateConnectivityTest(
    NoAwaitTag, google::cloud::networkmanagement::v1::
                    CreateConnectivityTestRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
ReachabilityServiceConnection::CreateConnectivityTest(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
ReachabilityServiceConnection::UpdateConnectivityTest(
    google::cloud::networkmanagement::v1::
        UpdateConnectivityTestRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ReachabilityServiceConnection::UpdateConnectivityTest(
    NoAwaitTag, google::cloud::networkmanagement::v1::
                    UpdateConnectivityTestRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
ReachabilityServiceConnection::UpdateConnectivityTest(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
ReachabilityServiceConnection::RerunConnectivityTest(
    google::cloud::networkmanagement::v1::RerunConnectivityTestRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ReachabilityServiceConnection::RerunConnectivityTest(
    NoAwaitTag,
    google::cloud::networkmanagement::v1::RerunConnectivityTestRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
ReachabilityServiceConnection::RerunConnectivityTest(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkmanagement::v1::OperationMetadata>>
ReachabilityServiceConnection::DeleteConnectivityTest(
    google::cloud::networkmanagement::v1::
        DeleteConnectivityTestRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkmanagement::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ReachabilityServiceConnection::DeleteConnectivityTest(
    NoAwaitTag, google::cloud::networkmanagement::v1::
                    DeleteConnectivityTestRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkmanagement::v1::OperationMetadata>>
ReachabilityServiceConnection::DeleteConnectivityTest(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkmanagement::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<ReachabilityServiceConnection>
MakeReachabilityServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ReachabilityServicePolicyOptionList>(options,
                                                                      __func__);
  options = networkmanagement_v1_internal::ReachabilityServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub =
      networkmanagement_v1_internal::CreateDefaultReachabilityServiceStub(
          std::move(auth), options);
  return networkmanagement_v1_internal::
      MakeReachabilityServiceTracingConnection(
          std::make_shared<
              networkmanagement_v1_internal::ReachabilityServiceConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkmanagement_v1
}  // namespace cloud
}  // namespace google
