// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicehealth/v1/event_service.proto

#include "google/cloud/servicehealth/v1/service_health_connection.h"
#include "google/cloud/servicehealth/v1/internal/service_health_connection_impl.h"
#include "google/cloud/servicehealth/v1/internal/service_health_option_defaults.h"
#include "google/cloud/servicehealth/v1/internal/service_health_stub_factory.h"
#include "google/cloud/servicehealth/v1/internal/service_health_tracing_connection.h"
#include "google/cloud/servicehealth/v1/service_health_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace servicehealth_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ServiceHealthConnection::~ServiceHealthConnection() = default;

StreamRange<google::cloud::servicehealth::v1::Event>
ServiceHealthConnection::ListEvents(
    google::cloud::servicehealth::v1::
        ListEventsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::servicehealth::v1::Event>>();
}

StatusOr<google::cloud::servicehealth::v1::Event>
ServiceHealthConnection::GetEvent(
    google::cloud::servicehealth::v1::GetEventRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::servicehealth::v1::OrganizationEvent>
ServiceHealthConnection::ListOrganizationEvents(
    google::cloud::servicehealth::v1::
        ListOrganizationEventsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::servicehealth::v1::OrganizationEvent>>();
}

StatusOr<google::cloud::servicehealth::v1::OrganizationEvent>
ServiceHealthConnection::GetOrganizationEvent(
    google::cloud::servicehealth::v1::GetOrganizationEventRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::servicehealth::v1::OrganizationImpact>
ServiceHealthConnection::ListOrganizationImpacts(
    google::cloud::servicehealth::v1::
        ListOrganizationImpactsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::servicehealth::v1::OrganizationImpact>>();
}

StatusOr<google::cloud::servicehealth::v1::OrganizationImpact>
ServiceHealthConnection::GetOrganizationImpact(
    google::cloud::servicehealth::v1::GetOrganizationImpactRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ServiceHealthConnection> MakeServiceHealthConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ServiceHealthPolicyOptionList>(options,
                                                                __func__);
  options = servicehealth_v1_internal::ServiceHealthDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = servicehealth_v1_internal::CreateDefaultServiceHealthStub(
      std::move(auth), options);
  return servicehealth_v1_internal::MakeServiceHealthTracingConnection(
      std::make_shared<servicehealth_v1_internal::ServiceHealthConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicehealth_v1
}  // namespace cloud
}  // namespace google
