// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/dataset_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_DATASET_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_DATASET_CONNECTION_IMPL_H

#include "google/cloud/aiplatform/v1/dataset_connection.h"
#include "google/cloud/aiplatform/v1/dataset_connection_idempotency_policy.h"
#include "google/cloud/aiplatform/v1/dataset_options.h"
#include "google/cloud/aiplatform/v1/internal/dataset_retry_traits.h"
#include "google/cloud/aiplatform/v1/internal/dataset_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DatasetServiceConnectionImpl
    : public aiplatform_v1::DatasetServiceConnection {
 public:
  ~DatasetServiceConnectionImpl() override = default;

  DatasetServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<aiplatform_v1_internal::DatasetServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::cloud::aiplatform::v1::Dataset>> CreateDataset(
      google::cloud::aiplatform::v1::CreateDatasetRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateDataset(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateDatasetRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::Dataset>> CreateDataset(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::Dataset> GetDataset(
      google::cloud::aiplatform::v1::GetDatasetRequest const& request) override;

  StatusOr<google::cloud::aiplatform::v1::Dataset> UpdateDataset(
      google::cloud::aiplatform::v1::UpdateDatasetRequest const& request)
      override;

  StreamRange<google::cloud::aiplatform::v1::Dataset> ListDatasets(
      google::cloud::aiplatform::v1::ListDatasetsRequest request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteDataset(google::cloud::aiplatform::v1::DeleteDatasetRequest const&
                    request) override;

  StatusOr<google::longrunning::Operation> DeleteDataset(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteDatasetRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteDataset(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::ImportDataResponse>>
  ImportData(
      google::cloud::aiplatform::v1::ImportDataRequest const& request) override;

  StatusOr<google::longrunning::Operation> ImportData(
      NoAwaitTag,
      google::cloud::aiplatform::v1::ImportDataRequest const& request) override;

  future<StatusOr<google::cloud::aiplatform::v1::ImportDataResponse>>
  ImportData(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::ExportDataResponse>>
  ExportData(
      google::cloud::aiplatform::v1::ExportDataRequest const& request) override;

  StatusOr<google::longrunning::Operation> ExportData(
      NoAwaitTag,
      google::cloud::aiplatform::v1::ExportDataRequest const& request) override;

  future<StatusOr<google::cloud::aiplatform::v1::ExportDataResponse>>
  ExportData(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::DatasetVersion>>
  CreateDatasetVersion(
      google::cloud::aiplatform::v1::CreateDatasetVersionRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateDatasetVersion(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateDatasetVersionRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DatasetVersion>>
  CreateDatasetVersion(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::DatasetVersion> UpdateDatasetVersion(
      google::cloud::aiplatform::v1::UpdateDatasetVersionRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteDatasetVersion(
      google::cloud::aiplatform::v1::DeleteDatasetVersionRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteDatasetVersion(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteDatasetVersionRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteDatasetVersion(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::DatasetVersion> GetDatasetVersion(
      google::cloud::aiplatform::v1::GetDatasetVersionRequest const& request)
      override;

  StreamRange<google::cloud::aiplatform::v1::DatasetVersion>
  ListDatasetVersions(google::cloud::aiplatform::v1::ListDatasetVersionsRequest
                          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DatasetVersion>>
  RestoreDatasetVersion(
      google::cloud::aiplatform::v1::RestoreDatasetVersionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> RestoreDatasetVersion(
      NoAwaitTag,
      google::cloud::aiplatform::v1::RestoreDatasetVersionRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DatasetVersion>>
  RestoreDatasetVersion(
      google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::aiplatform::v1::DataItem> ListDataItems(
      google::cloud::aiplatform::v1::ListDataItemsRequest request) override;

  StreamRange<google::cloud::aiplatform::v1::DataItemView> SearchDataItems(
      google::cloud::aiplatform::v1::SearchDataItemsRequest request) override;

  StreamRange<google::cloud::aiplatform::v1::SavedQuery> ListSavedQueries(
      google::cloud::aiplatform::v1::ListSavedQueriesRequest request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteSavedQuery(google::cloud::aiplatform::v1::DeleteSavedQueryRequest const&
                       request) override;

  StatusOr<google::longrunning::Operation> DeleteSavedQuery(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteSavedQueryRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteSavedQuery(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::AnnotationSpec> GetAnnotationSpec(
      google::cloud::aiplatform::v1::GetAnnotationSpecRequest const& request)
      override;

  StreamRange<google::cloud::aiplatform::v1::Annotation> ListAnnotations(
      google::cloud::aiplatform::v1::ListAnnotationsRequest request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<aiplatform_v1_internal::DatasetServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_DATASET_CONNECTION_IMPL_H
