// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/metadata_service.proto

#include "google/cloud/aiplatform/v1/metadata_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetadataServiceClient::MetadataServiceClient(
    std::shared_ptr<MetadataServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
MetadataServiceClient::~MetadataServiceClient() = default;

future<StatusOr<google::cloud::aiplatform::v1::MetadataStore>>
MetadataServiceClient::CreateMetadataStore(
    std::string const& parent,
    google::cloud::aiplatform::v1::MetadataStore const& metadata_store,
    std::string const& metadata_store_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateMetadataStoreRequest request;
  request.set_parent(parent);
  *request.mutable_metadata_store() = metadata_store;
  request.set_metadata_store_id(metadata_store_id);
  return connection_->CreateMetadataStore(request);
}

StatusOr<google::longrunning::Operation>
MetadataServiceClient::CreateMetadataStore(
    NoAwaitTag, std::string const& parent,
    google::cloud::aiplatform::v1::MetadataStore const& metadata_store,
    std::string const& metadata_store_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateMetadataStoreRequest request;
  request.set_parent(parent);
  *request.mutable_metadata_store() = metadata_store;
  request.set_metadata_store_id(metadata_store_id);
  return connection_->CreateMetadataStore(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::MetadataStore>>
MetadataServiceClient::CreateMetadataStore(
    google::cloud::aiplatform::v1::CreateMetadataStoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateMetadataStore(request);
}

StatusOr<google::longrunning::Operation>
MetadataServiceClient::CreateMetadataStore(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateMetadataStoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateMetadataStore(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::MetadataStore>>
MetadataServiceClient::CreateMetadataStore(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateMetadataStore(operation);
}

StatusOr<google::cloud::aiplatform::v1::MetadataStore>
MetadataServiceClient::GetMetadataStore(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetMetadataStoreRequest request;
  request.set_name(name);
  return connection_->GetMetadataStore(request);
}

StatusOr<google::cloud::aiplatform::v1::MetadataStore>
MetadataServiceClient::GetMetadataStore(
    google::cloud::aiplatform::v1::GetMetadataStoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetMetadataStore(request);
}

StreamRange<google::cloud::aiplatform::v1::MetadataStore>
MetadataServiceClient::ListMetadataStores(std::string const& parent,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListMetadataStoresRequest request;
  request.set_parent(parent);
  return connection_->ListMetadataStores(request);
}

StreamRange<google::cloud::aiplatform::v1::MetadataStore>
MetadataServiceClient::ListMetadataStores(
    google::cloud::aiplatform::v1::ListMetadataStoresRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListMetadataStores(std::move(request));
}

future<StatusOr<
    google::cloud::aiplatform::v1::DeleteMetadataStoreOperationMetadata>>
MetadataServiceClient::DeleteMetadataStore(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteMetadataStoreRequest request;
  request.set_name(name);
  return connection_->DeleteMetadataStore(request);
}

StatusOr<google::longrunning::Operation>
MetadataServiceClient::DeleteMetadataStore(NoAwaitTag, std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteMetadataStoreRequest request;
  request.set_name(name);
  return connection_->DeleteMetadataStore(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::aiplatform::v1::DeleteMetadataStoreOperationMetadata>>
MetadataServiceClient::DeleteMetadataStore(
    google::cloud::aiplatform::v1::DeleteMetadataStoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteMetadataStore(request);
}

StatusOr<google::longrunning::Operation>
MetadataServiceClient::DeleteMetadataStore(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteMetadataStoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteMetadataStore(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::aiplatform::v1::DeleteMetadataStoreOperationMetadata>>
MetadataServiceClient::DeleteMetadataStore(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteMetadataStore(operation);
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceClient::CreateArtifact(
    std::string const& parent,
    google::cloud::aiplatform::v1::Artifact const& artifact,
    std::string const& artifact_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateArtifactRequest request;
  request.set_parent(parent);
  *request.mutable_artifact() = artifact;
  request.set_artifact_id(artifact_id);
  return connection_->CreateArtifact(request);
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceClient::CreateArtifact(
    google::cloud::aiplatform::v1::CreateArtifactRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateArtifact(request);
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceClient::GetArtifact(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetArtifactRequest request;
  request.set_name(name);
  return connection_->GetArtifact(request);
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceClient::GetArtifact(
    google::cloud::aiplatform::v1::GetArtifactRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetArtifact(request);
}

StreamRange<google::cloud::aiplatform::v1::Artifact>
MetadataServiceClient::ListArtifacts(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListArtifactsRequest request;
  request.set_parent(parent);
  return connection_->ListArtifacts(request);
}

StreamRange<google::cloud::aiplatform::v1::Artifact>
MetadataServiceClient::ListArtifacts(
    google::cloud::aiplatform::v1::ListArtifactsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListArtifacts(std::move(request));
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceClient::UpdateArtifact(
    google::cloud::aiplatform::v1::Artifact const& artifact,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateArtifactRequest request;
  *request.mutable_artifact() = artifact;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateArtifact(request);
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceClient::UpdateArtifact(
    google::cloud::aiplatform::v1::UpdateArtifactRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateArtifact(request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceClient::DeleteArtifact(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteArtifactRequest request;
  request.set_name(name);
  return connection_->DeleteArtifact(request);
}

StatusOr<google::longrunning::Operation> MetadataServiceClient::DeleteArtifact(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteArtifactRequest request;
  request.set_name(name);
  return connection_->DeleteArtifact(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceClient::DeleteArtifact(
    google::cloud::aiplatform::v1::DeleteArtifactRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteArtifact(request);
}

StatusOr<google::longrunning::Operation> MetadataServiceClient::DeleteArtifact(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteArtifactRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteArtifact(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceClient::DeleteArtifact(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteArtifact(operation);
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeArtifactsResponse>>
MetadataServiceClient::PurgeArtifacts(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::PurgeArtifactsRequest request;
  request.set_parent(parent);
  return connection_->PurgeArtifacts(request);
}

StatusOr<google::longrunning::Operation> MetadataServiceClient::PurgeArtifacts(
    NoAwaitTag, std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::PurgeArtifactsRequest request;
  request.set_parent(parent);
  return connection_->PurgeArtifacts(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeArtifactsResponse>>
MetadataServiceClient::PurgeArtifacts(
    google::cloud::aiplatform::v1::PurgeArtifactsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeArtifacts(request);
}

StatusOr<google::longrunning::Operation> MetadataServiceClient::PurgeArtifacts(
    NoAwaitTag,
    google::cloud::aiplatform::v1::PurgeArtifactsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeArtifacts(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeArtifactsResponse>>
MetadataServiceClient::PurgeArtifacts(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeArtifacts(operation);
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceClient::CreateContext(
    std::string const& parent,
    google::cloud::aiplatform::v1::Context const& context,
    std::string const& context_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateContextRequest request;
  request.set_parent(parent);
  *request.mutable_context() = context;
  request.set_context_id(context_id);
  return connection_->CreateContext(request);
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceClient::CreateContext(
    google::cloud::aiplatform::v1::CreateContextRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateContext(request);
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceClient::GetContext(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetContextRequest request;
  request.set_name(name);
  return connection_->GetContext(request);
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceClient::GetContext(
    google::cloud::aiplatform::v1::GetContextRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetContext(request);
}

StreamRange<google::cloud::aiplatform::v1::Context>
MetadataServiceClient::ListContexts(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListContextsRequest request;
  request.set_parent(parent);
  return connection_->ListContexts(request);
}

StreamRange<google::cloud::aiplatform::v1::Context>
MetadataServiceClient::ListContexts(
    google::cloud::aiplatform::v1::ListContextsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListContexts(std::move(request));
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceClient::UpdateContext(
    google::cloud::aiplatform::v1::Context const& context,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateContextRequest request;
  *request.mutable_context() = context;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateContext(request);
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceClient::UpdateContext(
    google::cloud::aiplatform::v1::UpdateContextRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateContext(request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceClient::DeleteContext(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteContextRequest request;
  request.set_name(name);
  return connection_->DeleteContext(request);
}

StatusOr<google::longrunning::Operation> MetadataServiceClient::DeleteContext(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteContextRequest request;
  request.set_name(name);
  return connection_->DeleteContext(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceClient::DeleteContext(
    google::cloud::aiplatform::v1::DeleteContextRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteContext(request);
}

StatusOr<google::longrunning::Operation> MetadataServiceClient::DeleteContext(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteContextRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteContext(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceClient::DeleteContext(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteContext(operation);
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeContextsResponse>>
MetadataServiceClient::PurgeContexts(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::PurgeContextsRequest request;
  request.set_parent(parent);
  return connection_->PurgeContexts(request);
}

StatusOr<google::longrunning::Operation> MetadataServiceClient::PurgeContexts(
    NoAwaitTag, std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::PurgeContextsRequest request;
  request.set_parent(parent);
  return connection_->PurgeContexts(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeContextsResponse>>
MetadataServiceClient::PurgeContexts(
    google::cloud::aiplatform::v1::PurgeContextsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeContexts(request);
}

StatusOr<google::longrunning::Operation> MetadataServiceClient::PurgeContexts(
    NoAwaitTag,
    google::cloud::aiplatform::v1::PurgeContextsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeContexts(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeContextsResponse>>
MetadataServiceClient::PurgeContexts(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeContexts(operation);
}

StatusOr<
    google::cloud::aiplatform::v1::AddContextArtifactsAndExecutionsResponse>
MetadataServiceClient::AddContextArtifactsAndExecutions(
    std::string const& context, std::vector<std::string> const& artifacts,
    std::vector<std::string> const& executions, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::AddContextArtifactsAndExecutionsRequest
      request;
  request.set_context(context);
  *request.mutable_artifacts() = {artifacts.begin(), artifacts.end()};
  *request.mutable_executions() = {executions.begin(), executions.end()};
  return connection_->AddContextArtifactsAndExecutions(request);
}

StatusOr<
    google::cloud::aiplatform::v1::AddContextArtifactsAndExecutionsResponse>
MetadataServiceClient::AddContextArtifactsAndExecutions(
    google::cloud::aiplatform::v1::
        AddContextArtifactsAndExecutionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddContextArtifactsAndExecutions(request);
}

StatusOr<google::cloud::aiplatform::v1::AddContextChildrenResponse>
MetadataServiceClient::AddContextChildren(
    std::string const& context, std::vector<std::string> const& child_contexts,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::AddContextChildrenRequest request;
  request.set_context(context);
  *request.mutable_child_contexts() = {child_contexts.begin(),
                                       child_contexts.end()};
  return connection_->AddContextChildren(request);
}

StatusOr<google::cloud::aiplatform::v1::AddContextChildrenResponse>
MetadataServiceClient::AddContextChildren(
    google::cloud::aiplatform::v1::AddContextChildrenRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddContextChildren(request);
}

StatusOr<google::cloud::aiplatform::v1::RemoveContextChildrenResponse>
MetadataServiceClient::RemoveContextChildren(
    std::string const& context, std::vector<std::string> const& child_contexts,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::RemoveContextChildrenRequest request;
  request.set_context(context);
  *request.mutable_child_contexts() = {child_contexts.begin(),
                                       child_contexts.end()};
  return connection_->RemoveContextChildren(request);
}

StatusOr<google::cloud::aiplatform::v1::RemoveContextChildrenResponse>
MetadataServiceClient::RemoveContextChildren(
    google::cloud::aiplatform::v1::RemoveContextChildrenRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RemoveContextChildren(request);
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceClient::QueryContextLineageSubgraph(std::string const& context,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::QueryContextLineageSubgraphRequest request;
  request.set_context(context);
  return connection_->QueryContextLineageSubgraph(request);
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceClient::QueryContextLineageSubgraph(
    google::cloud::aiplatform::v1::QueryContextLineageSubgraphRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->QueryContextLineageSubgraph(request);
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceClient::CreateExecution(
    std::string const& parent,
    google::cloud::aiplatform::v1::Execution const& execution,
    std::string const& execution_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateExecutionRequest request;
  request.set_parent(parent);
  *request.mutable_execution() = execution;
  request.set_execution_id(execution_id);
  return connection_->CreateExecution(request);
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceClient::CreateExecution(
    google::cloud::aiplatform::v1::CreateExecutionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateExecution(request);
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceClient::GetExecution(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetExecutionRequest request;
  request.set_name(name);
  return connection_->GetExecution(request);
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceClient::GetExecution(
    google::cloud::aiplatform::v1::GetExecutionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetExecution(request);
}

StreamRange<google::cloud::aiplatform::v1::Execution>
MetadataServiceClient::ListExecutions(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListExecutionsRequest request;
  request.set_parent(parent);
  return connection_->ListExecutions(request);
}

StreamRange<google::cloud::aiplatform::v1::Execution>
MetadataServiceClient::ListExecutions(
    google::cloud::aiplatform::v1::ListExecutionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListExecutions(std::move(request));
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceClient::UpdateExecution(
    google::cloud::aiplatform::v1::Execution const& execution,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateExecutionRequest request;
  *request.mutable_execution() = execution;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateExecution(request);
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceClient::UpdateExecution(
    google::cloud::aiplatform::v1::UpdateExecutionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateExecution(request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceClient::DeleteExecution(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteExecutionRequest request;
  request.set_name(name);
  return connection_->DeleteExecution(request);
}

StatusOr<google::longrunning::Operation> MetadataServiceClient::DeleteExecution(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteExecutionRequest request;
  request.set_name(name);
  return connection_->DeleteExecution(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceClient::DeleteExecution(
    google::cloud::aiplatform::v1::DeleteExecutionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExecution(request);
}

StatusOr<google::longrunning::Operation> MetadataServiceClient::DeleteExecution(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteExecutionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExecution(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceClient::DeleteExecution(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExecution(operation);
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeExecutionsResponse>>
MetadataServiceClient::PurgeExecutions(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::PurgeExecutionsRequest request;
  request.set_parent(parent);
  return connection_->PurgeExecutions(request);
}

StatusOr<google::longrunning::Operation> MetadataServiceClient::PurgeExecutions(
    NoAwaitTag, std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::PurgeExecutionsRequest request;
  request.set_parent(parent);
  return connection_->PurgeExecutions(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeExecutionsResponse>>
MetadataServiceClient::PurgeExecutions(
    google::cloud::aiplatform::v1::PurgeExecutionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeExecutions(request);
}

StatusOr<google::longrunning::Operation> MetadataServiceClient::PurgeExecutions(
    NoAwaitTag,
    google::cloud::aiplatform::v1::PurgeExecutionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeExecutions(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeExecutionsResponse>>
MetadataServiceClient::PurgeExecutions(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeExecutions(operation);
}

StatusOr<google::cloud::aiplatform::v1::AddExecutionEventsResponse>
MetadataServiceClient::AddExecutionEvents(
    std::string const& execution,
    std::vector<google::cloud::aiplatform::v1::Event> const& events,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::AddExecutionEventsRequest request;
  request.set_execution(execution);
  *request.mutable_events() = {events.begin(), events.end()};
  return connection_->AddExecutionEvents(request);
}

StatusOr<google::cloud::aiplatform::v1::AddExecutionEventsResponse>
MetadataServiceClient::AddExecutionEvents(
    google::cloud::aiplatform::v1::AddExecutionEventsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddExecutionEvents(request);
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceClient::QueryExecutionInputsAndOutputs(
    std::string const& execution, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::QueryExecutionInputsAndOutputsRequest request;
  request.set_execution(execution);
  return connection_->QueryExecutionInputsAndOutputs(request);
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceClient::QueryExecutionInputsAndOutputs(
    google::cloud::aiplatform::v1::QueryExecutionInputsAndOutputsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->QueryExecutionInputsAndOutputs(request);
}

StatusOr<google::cloud::aiplatform::v1::MetadataSchema>
MetadataServiceClient::CreateMetadataSchema(
    std::string const& parent,
    google::cloud::aiplatform::v1::MetadataSchema const& metadata_schema,
    std::string const& metadata_schema_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateMetadataSchemaRequest request;
  request.set_parent(parent);
  *request.mutable_metadata_schema() = metadata_schema;
  request.set_metadata_schema_id(metadata_schema_id);
  return connection_->CreateMetadataSchema(request);
}

StatusOr<google::cloud::aiplatform::v1::MetadataSchema>
MetadataServiceClient::CreateMetadataSchema(
    google::cloud::aiplatform::v1::CreateMetadataSchemaRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateMetadataSchema(request);
}

StatusOr<google::cloud::aiplatform::v1::MetadataSchema>
MetadataServiceClient::GetMetadataSchema(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetMetadataSchemaRequest request;
  request.set_name(name);
  return connection_->GetMetadataSchema(request);
}

StatusOr<google::cloud::aiplatform::v1::MetadataSchema>
MetadataServiceClient::GetMetadataSchema(
    google::cloud::aiplatform::v1::GetMetadataSchemaRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetMetadataSchema(request);
}

StreamRange<google::cloud::aiplatform::v1::MetadataSchema>
MetadataServiceClient::ListMetadataSchemas(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListMetadataSchemasRequest request;
  request.set_parent(parent);
  return connection_->ListMetadataSchemas(request);
}

StreamRange<google::cloud::aiplatform::v1::MetadataSchema>
MetadataServiceClient::ListMetadataSchemas(
    google::cloud::aiplatform::v1::ListMetadataSchemasRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListMetadataSchemas(std::move(request));
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceClient::QueryArtifactLineageSubgraph(std::string const& artifact,
                                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::QueryArtifactLineageSubgraphRequest request;
  request.set_artifact(artifact);
  return connection_->QueryArtifactLineageSubgraph(request);
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceClient::QueryArtifactLineageSubgraph(
    google::cloud::aiplatform::v1::QueryArtifactLineageSubgraphRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->QueryArtifactLineageSubgraph(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
