// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BEYONDCORP_APPGATEWAYS_V1_APP_GATEWAYS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BEYONDCORP_APPGATEWAYS_V1_APP_GATEWAYS_CLIENT_H

#include "google/cloud/beyondcorp/appgateways/v1/app_gateways_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace beyondcorp_appgateways_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// API Overview:
///
/// The `beyondcorp.googleapis.com` service implements the Google Cloud
/// BeyondCorp API.
///
/// Data Model:
///
/// The AppGatewaysService exposes the following resources:
///
/// * AppGateways, named as follows:
///   `projects/{project_id}/locations/{location_id}/appGateways/{app_gateway_id}`.
///
/// The AppGatewaysService service provides methods to manage
/// (create/read/update/delete) BeyondCorp AppGateways.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class AppGatewaysServiceClient {
 public:
  explicit AppGatewaysServiceClient(
      std::shared_ptr<AppGatewaysServiceConnection> connection,
      Options opts = {});
  ~AppGatewaysServiceClient();

  ///@{
  /// @name Copy and move support
  AppGatewaysServiceClient(AppGatewaysServiceClient const&) = default;
  AppGatewaysServiceClient& operator=(AppGatewaysServiceClient const&) =
      default;
  AppGatewaysServiceClient(AppGatewaysServiceClient&&) = default;
  AppGatewaysServiceClient& operator=(AppGatewaysServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(AppGatewaysServiceClient const& a,
                         AppGatewaysServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(AppGatewaysServiceClient const& a,
                         AppGatewaysServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists AppGateways in a given project and location.
  ///
  /// @param parent  Required. The resource name of the AppGateway location using the form:
  ///  `projects/{project_id}/locations/{location_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.beyondcorp.appgateways.v1.AppGateway], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.beyondcorp.appgateways.v1.AppGateway]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L231}
  /// [google.cloud.beyondcorp.appgateways.v1.ListAppGatewaysRequest]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L99}
  ///
  // clang-format on
  StreamRange<google::cloud::beyondcorp::appgateways::v1::AppGateway>
  ListAppGateways(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists AppGateways in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.beyondcorp.appgateways.v1.ListAppGatewaysRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.beyondcorp.appgateways.v1.AppGateway], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.beyondcorp.appgateways.v1.AppGateway]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L231}
  /// [google.cloud.beyondcorp.appgateways.v1.ListAppGatewaysRequest]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L99}
  ///
  // clang-format on
  StreamRange<google::cloud::beyondcorp::appgateways::v1::AppGateway>
  ListAppGateways(
      google::cloud::beyondcorp::appgateways::v1::ListAppGatewaysRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single AppGateway.
  ///
  /// @param name  Required. BeyondCorp AppGateway name using the form:
  ///  `projects/{project_id}/locations/{location_id}/appGateways/{app_gateway_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.beyondcorp.appgateways.v1.AppGateway])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.beyondcorp.appgateways.v1.AppGateway]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L231}
  /// [google.cloud.beyondcorp.appgateways.v1.GetAppGatewayRequest]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L145}
  ///
  // clang-format on
  StatusOr<google::cloud::beyondcorp::appgateways::v1::AppGateway>
  GetAppGateway(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single AppGateway.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.beyondcorp.appgateways.v1.GetAppGatewayRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.beyondcorp.appgateways.v1.AppGateway])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.beyondcorp.appgateways.v1.AppGateway]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L231}
  /// [google.cloud.beyondcorp.appgateways.v1.GetAppGatewayRequest]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L145}
  ///
  // clang-format on
  StatusOr<google::cloud::beyondcorp::appgateways::v1::AppGateway>
  GetAppGateway(
      google::cloud::beyondcorp::appgateways::v1::GetAppGatewayRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new AppGateway in a given project and location.
  ///
  /// @param parent  Required. The resource project name of the AppGateway location using the
  ///  form: `projects/{project_id}/locations/{location_id}`
  /// @param app_gateway  Required. A BeyondCorp AppGateway resource.
  /// @param app_gateway_id  Optional. User-settable AppGateway resource ID.
  ///   * Must start with a letter.
  ///   * Must contain between 4-63 characters from `/[a-z][0-9]-/`.
  ///   * Must end with a number or a letter.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.beyondcorp.appgateways.v1.AppGateway] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.beyondcorp.appgateways.v1.AppGateway]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L231}
  /// [google.cloud.beyondcorp.appgateways.v1.CreateAppGatewayRequest]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L157}
  ///
  // clang-format on
  future<StatusOr<google::cloud::beyondcorp::appgateways::v1::AppGateway>>
  CreateAppGateway(
      std::string const& parent,
      google::cloud::beyondcorp::appgateways::v1::AppGateway const& app_gateway,
      std::string const& app_gateway_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAppGateway
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAppGateway(
      NoAwaitTag, std::string const& parent,
      google::cloud::beyondcorp::appgateways::v1::AppGateway const& app_gateway,
      std::string const& app_gateway_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new AppGateway in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.beyondcorp.appgateways.v1.CreateAppGatewayRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.beyondcorp.appgateways.v1.AppGateway] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.beyondcorp.appgateways.v1.AppGateway]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L231}
  /// [google.cloud.beyondcorp.appgateways.v1.CreateAppGatewayRequest]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L157}
  ///
  // clang-format on
  future<StatusOr<google::cloud::beyondcorp::appgateways::v1::AppGateway>>
  CreateAppGateway(
      google::cloud::beyondcorp::appgateways::v1::CreateAppGatewayRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAppGateway
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAppGateway(
      NoAwaitTag,
      google::cloud::beyondcorp::appgateways::v1::CreateAppGatewayRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAppGateway
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::beyondcorp::appgateways::v1::AppGateway>>
  CreateAppGateway(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Deletes a single AppGateway.
  ///
  /// @param name  Required. BeyondCorp AppGateway name using the form:
  ///  `projects/{project_id}/locations/{location_id}/appGateways/{app_gateway_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.beyondcorp.appgateways.v1.AppGatewayOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.beyondcorp.appgateways.v1.AppGatewayOperationMetadata]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L329}
  /// [google.cloud.beyondcorp.appgateways.v1.DeleteAppGatewayRequest]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L197}
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::beyondcorp::appgateways::v1::AppGatewayOperationMetadata>>
  DeleteAppGateway(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAppGateway
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAppGateway(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single AppGateway.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.beyondcorp.appgateways.v1.DeleteAppGatewayRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.beyondcorp.appgateways.v1.AppGatewayOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.beyondcorp.appgateways.v1.AppGatewayOperationMetadata]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L329}
  /// [google.cloud.beyondcorp.appgateways.v1.DeleteAppGatewayRequest]: @googleapis_reference_link{google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto#L197}
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::beyondcorp::appgateways::v1::AppGatewayOperationMetadata>>
  DeleteAppGateway(
      google::cloud::beyondcorp::appgateways::v1::DeleteAppGatewayRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAppGateway
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAppGateway(
      NoAwaitTag,
      google::cloud::beyondcorp::appgateways::v1::DeleteAppGatewayRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAppGateway
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::beyondcorp::appgateways::v1::AppGatewayOperationMetadata>>
  DeleteAppGateway(google::longrunning::Operation const& operation,
                   Options opts = {});

 private:
  std::shared_ptr<AppGatewaysServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace beyondcorp_appgateways_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BEYONDCORP_APPGATEWAYS_V1_APP_GATEWAYS_CLIENT_H
