// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/model.proto

#include "google/cloud/bigquerycontrol/v2/model_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ModelServiceClient::ModelServiceClient(
    std::shared_ptr<ModelServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ModelServiceClient::~ModelServiceClient() = default;

StatusOr<google::cloud::bigquery::v2::Model> ModelServiceClient::GetModel(
    std::string const& project_id, std::string const& dataset_id,
    std::string const& model_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::v2::GetModelRequest request;
  request.set_project_id(project_id);
  request.set_dataset_id(dataset_id);
  request.set_model_id(model_id);
  return connection_->GetModel(request);
}

StatusOr<google::cloud::bigquery::v2::Model> ModelServiceClient::GetModel(
    google::cloud::bigquery::v2::GetModelRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetModel(request);
}

StreamRange<google::cloud::bigquery::v2::Model> ModelServiceClient::ListModels(
    std::string const& project_id, std::string const& dataset_id,
    google::protobuf::UInt32Value const& max_results, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::v2::ListModelsRequest request;
  request.set_project_id(project_id);
  request.set_dataset_id(dataset_id);
  *request.mutable_max_results() = max_results;
  return connection_->ListModels(request);
}

StreamRange<google::cloud::bigquery::v2::Model> ModelServiceClient::ListModels(
    google::cloud::bigquery::v2::ListModelsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListModels(std::move(request));
}

StatusOr<google::cloud::bigquery::v2::Model> ModelServiceClient::PatchModel(
    std::string const& project_id, std::string const& dataset_id,
    std::string const& model_id,
    google::cloud::bigquery::v2::Model const& model, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::v2::PatchModelRequest request;
  request.set_project_id(project_id);
  request.set_dataset_id(dataset_id);
  request.set_model_id(model_id);
  *request.mutable_model() = model;
  return connection_->PatchModel(request);
}

StatusOr<google::cloud::bigquery::v2::Model> ModelServiceClient::PatchModel(
    google::cloud::bigquery::v2::PatchModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchModel(request);
}

Status ModelServiceClient::DeleteModel(std::string const& project_id,
                                       std::string const& dataset_id,
                                       std::string const& model_id,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::v2::DeleteModelRequest request;
  request.set_project_id(project_id);
  request.set_dataset_id(dataset_id);
  request.set_model_id(model_id);
  return connection_->DeleteModel(request);
}

Status ModelServiceClient::DeleteModel(
    google::cloud::bigquery::v2::DeleteModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteModel(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2
}  // namespace cloud
}  // namespace google
