// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/orchestration/airflow/service/v1/image_versions.proto

#include "google/cloud/composer/v1/internal/image_versions_connection_impl.h"
#include "google/cloud/composer/v1/internal/image_versions_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace composer_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<composer_v1::ImageVersionsRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<composer_v1::ImageVersionsRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<composer_v1::ImageVersionsBackoffPolicyOption>()->clone();
}

std::unique_ptr<composer_v1::ImageVersionsConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<composer_v1::ImageVersionsConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

ImageVersionsConnectionImpl::ImageVersionsConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<composer_v1_internal::ImageVersionsStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      ImageVersionsConnection::options())) {}

StreamRange<google::cloud::orchestration::airflow::service::v1::ImageVersion>
ImageVersionsConnectionImpl::ListImageVersions(
    google::cloud::orchestration::airflow::service::v1::ListImageVersionsRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListImageVersions(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::cloud::orchestration::airflow::service::v1::ImageVersion>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<composer_v1::ImageVersionsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::orchestration::airflow::service::v1::
              ListImageVersionsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::orchestration::airflow::service::v1::
                       ListImageVersionsRequest const& request) {
              return stub->ListImageVersions(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::orchestration::airflow::service::v1::
             ListImageVersionsResponse r) {
        std::vector<
            google::cloud::orchestration::airflow::service::v1::ImageVersion>
            result(r.image_versions().size());
        auto& messages = *r.mutable_image_versions();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace composer_v1_internal
}  // namespace cloud
}  // namespace google
