// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/instance_group_manager_resize_requests/v1/instance_group_manager_resize_requests.proto

#include "google/cloud/compute/instance_group_manager_resize_requests/v1/internal/instance_group_manager_resize_requests_rest_metadata_decorator.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/rest_set_metadata.h"
#include "google/cloud/status_or.h"
#include "absl/strings/str_format.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_instance_group_manager_resize_requests_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

InstanceGroupManagerResizeRequestsRestMetadata::
    InstanceGroupManagerResizeRequestsRestMetadata(
        std::shared_ptr<InstanceGroupManagerResizeRequestsRestStub> child,
        std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsRestMetadata::AsyncCancel(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
        CancelRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCancel(cq, std::move(rest_context), std::move(options),
                             request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagerResizeRequestsRestMetadata::Cancel(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
        CancelRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->Cancel(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsRestMetadata::
    AsyncDeleteInstanceGroupManagerResizeRequest(
        CompletionQueue& cq,
        std::unique_ptr<rest_internal::RestContext> rest_context,
        google::cloud::internal::ImmutableOptions options,
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::DeleteInstanceGroupManagerResizeRequestRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncDeleteInstanceGroupManagerResizeRequest(
      cq, std::move(rest_context), std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagerResizeRequestsRestMetadata::
    DeleteInstanceGroupManagerResizeRequest(
        rest_internal::RestContext& rest_context, Options const& options,
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::DeleteInstanceGroupManagerResizeRequestRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->DeleteInstanceGroupManagerResizeRequest(rest_context, options,
                                                         request);
}

StatusOr<google::cloud::cpp::compute::v1::InstanceGroupManagerResizeRequest>
InstanceGroupManagerResizeRequestsRestMetadata::
    GetInstanceGroupManagerResizeRequest(
        rest_internal::RestContext& rest_context, Options const& options,
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::GetInstanceGroupManagerResizeRequestRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetInstanceGroupManagerResizeRequest(rest_context, options,
                                                      request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsRestMetadata::
    AsyncInsertInstanceGroupManagerResizeRequest(
        CompletionQueue& cq,
        std::unique_ptr<rest_internal::RestContext> rest_context,
        google::cloud::internal::ImmutableOptions options,
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::InsertInstanceGroupManagerResizeRequestRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncInsertInstanceGroupManagerResizeRequest(
      cq, std::move(rest_context), std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagerResizeRequestsRestMetadata::
    InsertInstanceGroupManagerResizeRequest(
        rest_internal::RestContext& rest_context, Options const& options,
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::InsertInstanceGroupManagerResizeRequestRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->InsertInstanceGroupManagerResizeRequest(rest_context, options,
                                                         request);
}

StatusOr<google::cloud::cpp::compute::v1::
             InstanceGroupManagerResizeRequestsListResponse>
InstanceGroupManagerResizeRequestsRestMetadata::
    ListInstanceGroupManagerResizeRequests(
        rest_internal::RestContext& rest_context, Options const& options,
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::ListInstanceGroupManagerResizeRequestsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListInstanceGroupManagerResizeRequests(rest_context, options,
                                                        request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsRestMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::zone_operations::v1::GetOperationRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncGetOperation(cq, std::move(rest_context),
                                   std::move(options), request);
}

future<Status>
InstanceGroupManagerResizeRequestsRestMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::zone_operations::v1::
        DeleteOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCancelOperation(cq, std::move(rest_context),
                                      std::move(options), request);
}

void InstanceGroupManagerResizeRequestsRestMetadata::SetMetadata(
    rest_internal::RestContext& rest_context, Options const& options,
    std::vector<std::string> const& params) {
  google::cloud::rest_internal::SetMetadata(rest_context, options, params,
                                            api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instance_group_manager_resize_requests_v1_internal
}  // namespace cloud
}  // namespace google
