// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/target_pools/v1/target_pools.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_POOLS_V1_INTERNAL_TARGET_POOLS_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_POOLS_V1_INTERNAL_TARGET_POOLS_TRACING_CONNECTION_H

#include "google/cloud/compute/target_pools/v1/target_pools_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_target_pools_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class TargetPoolsTracingConnection
    : public compute_target_pools_v1::TargetPoolsConnection {
 public:
  ~TargetPoolsTracingConnection() override = default;

  explicit TargetPoolsTracingConnection(
      std::shared_ptr<compute_target_pools_v1::TargetPoolsConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> AddHealthCheck(
      google::cloud::cpp::compute::target_pools::v1::
          AddHealthCheckRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> AddHealthCheck(
      NoAwaitTag, google::cloud::cpp::compute::target_pools::v1::
                      AddHealthCheckRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> AddHealthCheck(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> AddInstance(
      google::cloud::cpp::compute::target_pools::v1::AddInstanceRequest const&
          request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> AddInstance(
      NoAwaitTag,
      google::cloud::cpp::compute::target_pools::v1::AddInstanceRequest const&
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> AddInstance(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StreamRange<std::pair<std::string,
                        google::cloud::cpp::compute::v1::TargetPoolsScopedList>>
  AggregatedListTargetPools(
      google::cloud::cpp::compute::target_pools::v1::
          AggregatedListTargetPoolsRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> DeleteTargetPool(
      google::cloud::cpp::compute::target_pools::v1::
          DeleteTargetPoolRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> DeleteTargetPool(
      NoAwaitTag, google::cloud::cpp::compute::target_pools::v1::
                      DeleteTargetPoolRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> DeleteTargetPool(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StatusOr<google::cloud::cpp::compute::v1::TargetPool> GetTargetPool(
      google::cloud::cpp::compute::target_pools::v1::GetTargetPoolRequest const&
          request) override;

  StatusOr<google::cloud::cpp::compute::v1::TargetPoolInstanceHealth> GetHealth(
      google::cloud::cpp::compute::target_pools::v1::GetHealthRequest const&
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> InsertTargetPool(
      google::cloud::cpp::compute::target_pools::v1::
          InsertTargetPoolRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> InsertTargetPool(
      NoAwaitTag, google::cloud::cpp::compute::target_pools::v1::
                      InsertTargetPoolRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> InsertTargetPool(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StreamRange<google::cloud::cpp::compute::v1::TargetPool> ListTargetPools(
      google::cloud::cpp::compute::target_pools::v1::ListTargetPoolsRequest
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  RemoveHealthCheck(google::cloud::cpp::compute::target_pools::v1::
                        RemoveHealthCheckRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> RemoveHealthCheck(
      NoAwaitTag, google::cloud::cpp::compute::target_pools::v1::
                      RemoveHealthCheckRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  RemoveHealthCheck(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> RemoveInstance(
      google::cloud::cpp::compute::target_pools::v1::
          RemoveInstanceRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> RemoveInstance(
      NoAwaitTag, google::cloud::cpp::compute::target_pools::v1::
                      RemoveInstanceRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> RemoveInstance(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> SetBackup(
      google::cloud::cpp::compute::target_pools::v1::SetBackupRequest const&
          request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> SetBackup(
      NoAwaitTag,
      google::cloud::cpp::compute::target_pools::v1::SetBackupRequest const&
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> SetBackup(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetSecurityPolicy(google::cloud::cpp::compute::target_pools::v1::
                        SetSecurityPolicyRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> SetSecurityPolicy(
      NoAwaitTag, google::cloud::cpp::compute::target_pools::v1::
                      SetSecurityPolicyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetSecurityPolicy(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

 private:
  std::shared_ptr<compute_target_pools_v1::TargetPoolsConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<compute_target_pools_v1::TargetPoolsConnection>
MakeTargetPoolsTracingConnection(
    std::shared_ptr<compute_target_pools_v1::TargetPoolsConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_target_pools_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_POOLS_V1_INTERNAL_TARGET_POOLS_TRACING_CONNECTION_H
