// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/document_link_service.proto

#include "google/cloud/contentwarehouse/v1/internal/document_link_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contentwarehouse_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DocumentLinkServiceTracingConnection::DocumentLinkServiceTracingConnection(
    std::shared_ptr<contentwarehouse_v1::DocumentLinkServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::contentwarehouse::v1::ListLinkedTargetsResponse>
DocumentLinkServiceTracingConnection::ListLinkedTargets(
    google::cloud::contentwarehouse::v1::ListLinkedTargetsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentLinkServiceConnection::ListLinkedTargets");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ListLinkedTargets(request));
}

StreamRange<google::cloud::contentwarehouse::v1::DocumentLink>
DocumentLinkServiceTracingConnection::ListLinkedSources(
    google::cloud::contentwarehouse::v1::ListLinkedSourcesRequest request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentLinkServiceConnection::ListLinkedSources");
  internal::OTelScope scope(span);
  auto sr = child_->ListLinkedSources(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::contentwarehouse::v1::DocumentLink>(std::move(span),
                                                         std::move(sr));
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentLink>
DocumentLinkServiceTracingConnection::CreateDocumentLink(
    google::cloud::contentwarehouse::v1::CreateDocumentLinkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentLinkServiceConnection::CreateDocumentLink");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateDocumentLink(request));
}

Status DocumentLinkServiceTracingConnection::DeleteDocumentLink(
    google::cloud::contentwarehouse::v1::DeleteDocumentLinkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentLinkServiceConnection::DeleteDocumentLink");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteDocumentLink(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<contentwarehouse_v1::DocumentLinkServiceConnection>
MakeDocumentLinkServiceTracingConnection(
    std::shared_ptr<contentwarehouse_v1::DocumentLinkServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<DocumentLinkServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1_internal
}  // namespace cloud
}  // namespace google
