// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkeconnect/gateway/v1/control.proto

#include "google/cloud/gkeconnect/gateway/v1/internal/gateway_control_connection_impl.h"
#include "google/cloud/gkeconnect/gateway/v1/internal/gateway_control_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace gkeconnect_gateway_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<gkeconnect_gateway_v1::GatewayControlRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<gkeconnect_gateway_v1::GatewayControlRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<gkeconnect_gateway_v1::GatewayControlBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    gkeconnect_gateway_v1::GatewayControlConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<gkeconnect_gateway_v1::
               GatewayControlConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

GatewayControlConnectionImpl::GatewayControlConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<gkeconnect_gateway_v1_internal::GatewayControlStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      GatewayControlConnection::options())) {}

StatusOr<google::cloud::gkeconnect::gateway::v1::GenerateCredentialsResponse>
GatewayControlConnectionImpl::GenerateCredentials(
    google::cloud::gkeconnect::gateway::v1::GenerateCredentialsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GenerateCredentials(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkeconnect::gateway::v1::
                 GenerateCredentialsRequest const& request) {
        return stub_->GenerateCredentials(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkeconnect_gateway_v1_internal
}  // namespace cloud
}  // namespace google
