// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/logging/v2/logging.proto

#include "google/cloud/logging/v2/logging_service_v2_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace logging_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

LoggingServiceV2ConnectionIdempotencyPolicy::
    ~LoggingServiceV2ConnectionIdempotencyPolicy() = default;

std::unique_ptr<LoggingServiceV2ConnectionIdempotencyPolicy>
LoggingServiceV2ConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<LoggingServiceV2ConnectionIdempotencyPolicy>(*this);
}

Idempotency LoggingServiceV2ConnectionIdempotencyPolicy::DeleteLog(
    google::logging::v2::DeleteLogRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LoggingServiceV2ConnectionIdempotencyPolicy::WriteLogEntries(
    google::logging::v2::WriteLogEntriesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LoggingServiceV2ConnectionIdempotencyPolicy::ListLogEntries(
    google::logging::v2::ListLogEntriesRequest) {  // NOLINT
  return Idempotency::kNonIdempotent;
}

Idempotency
LoggingServiceV2ConnectionIdempotencyPolicy::ListMonitoredResourceDescriptors(
    google::logging::v2::ListMonitoredResourceDescriptorsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency LoggingServiceV2ConnectionIdempotencyPolicy::ListLogs(
    google::logging::v2::ListLogsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<LoggingServiceV2ConnectionIdempotencyPolicy>
MakeDefaultLoggingServiceV2ConnectionIdempotencyPolicy() {
  return std::make_unique<LoggingServiceV2ConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace logging_v2
}  // namespace cloud
}  // namespace google
