// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/dashboard/v1/dashboards_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_DASHBOARD_V1_INTERNAL_DASHBOARDS_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_DASHBOARD_V1_INTERNAL_DASHBOARDS_TRACING_CONNECTION_H

#include "google/cloud/monitoring/dashboard/v1/dashboards_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_dashboard_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class DashboardsServiceTracingConnection
    : public monitoring_dashboard_v1::DashboardsServiceConnection {
 public:
  ~DashboardsServiceTracingConnection() override = default;

  explicit DashboardsServiceTracingConnection(
      std::shared_ptr<monitoring_dashboard_v1::DashboardsServiceConnection>
          child);

  Options options() override { return child_->options(); }

  StatusOr<google::monitoring::dashboard::v1::Dashboard> CreateDashboard(
      google::monitoring::dashboard::v1::CreateDashboardRequest const& request)
      override;

  StreamRange<google::monitoring::dashboard::v1::Dashboard> ListDashboards(
      google::monitoring::dashboard::v1::ListDashboardsRequest request)
      override;

  StatusOr<google::monitoring::dashboard::v1::Dashboard> GetDashboard(
      google::monitoring::dashboard::v1::GetDashboardRequest const& request)
      override;

  Status DeleteDashboard(
      google::monitoring::dashboard::v1::DeleteDashboardRequest const& request)
      override;

  StatusOr<google::monitoring::dashboard::v1::Dashboard> UpdateDashboard(
      google::monitoring::dashboard::v1::UpdateDashboardRequest const& request)
      override;

 private:
  std::shared_ptr<monitoring_dashboard_v1::DashboardsServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<monitoring_dashboard_v1::DashboardsServiceConnection>
MakeDashboardsServiceTracingConnection(
    std::shared_ptr<monitoring_dashboard_v1::DashboardsServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_dashboard_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_DASHBOARD_V1_INTERNAL_DASHBOARDS_TRACING_CONNECTION_H
