// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/dep.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_MOCKS_MOCK_DEP_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_MOCKS_MOCK_DEP_CONNECTION_H

#include "google/cloud/networkservices/v1/dep_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace networkservices_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `DepServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `DepServiceClient`. To do so,
 * construct an object of type `DepServiceClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockDepServiceConnection
    : public networkservices_v1::DepServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::networkservices::v1::LbTrafficExtension>),
      ListLbTrafficExtensions,
      (google::cloud::networkservices::v1::ListLbTrafficExtensionsRequest
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>,
      GetLbTrafficExtension,
      (google::cloud::networkservices::v1::GetLbTrafficExtensionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateLbTrafficExtension(Matcher<google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>,
      CreateLbTrafficExtension,
      (google::cloud::networkservices::v1::
           CreateLbTrafficExtensionRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateLbTrafficExtension(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>,
              CreateLbTrafficExtension,
              (NoAwaitTag, google::cloud::networkservices::v1::
                               CreateLbTrafficExtensionRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateLbTrafficExtension(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>,
      CreateLbTrafficExtension,
      (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateLbTrafficExtension(Matcher<google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>,
      UpdateLbTrafficExtension,
      (google::cloud::networkservices::v1::
           UpdateLbTrafficExtensionRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateLbTrafficExtension(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>,
              UpdateLbTrafficExtension,
              (NoAwaitTag, google::cloud::networkservices::v1::
                               UpdateLbTrafficExtensionRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateLbTrafficExtension(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>,
      UpdateLbTrafficExtension,
      (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteLbTrafficExtension(Matcher<google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteLbTrafficExtension,
      (google::cloud::networkservices::v1::
           DeleteLbTrafficExtensionRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteLbTrafficExtension(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>,
              DeleteLbTrafficExtension,
              (NoAwaitTag, google::cloud::networkservices::v1::
                               DeleteLbTrafficExtensionRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteLbTrafficExtension(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteLbTrafficExtension,
      (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::networkservices::v1::LbRouteExtension>),
      ListLbRouteExtensions,
      (google::cloud::networkservices::v1::ListLbRouteExtensionsRequest
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::networkservices::v1::LbRouteExtension>,
      GetLbRouteExtension,
      (google::cloud::networkservices::v1::GetLbRouteExtensionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateLbRouteExtension(Matcher<google::cloud::networkservices::v1::CreateLbRouteExtensionRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>,
      CreateLbRouteExtension,
      (google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateLbRouteExtension(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateLbRouteExtension,
      (NoAwaitTag,
       google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateLbRouteExtension(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>,
      CreateLbRouteExtension, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateLbRouteExtension(Matcher<google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>,
      UpdateLbRouteExtension,
      (google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateLbRouteExtension(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateLbRouteExtension,
      (NoAwaitTag,
       google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateLbRouteExtension(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>,
      UpdateLbRouteExtension, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteLbRouteExtension(Matcher<google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteLbRouteExtension,
      (google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteLbRouteExtension(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteLbRouteExtension,
      (NoAwaitTag,
       google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteLbRouteExtension(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteLbRouteExtension, (google::longrunning::Operation const& operation),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_MOCKS_MOCK_DEP_CONNECTION_H
