// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/storageinsights/v1/storageinsights.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGEINSIGHTS_V1_STORAGE_INSIGHTS_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGEINSIGHTS_V1_STORAGE_INSIGHTS_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/storageinsights/v1/storageinsights.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace storageinsights_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class StorageInsightsConnectionIdempotencyPolicy {
 public:
  virtual ~StorageInsightsConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<StorageInsightsConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency ListReportConfigs(
      google::cloud::storageinsights::v1::ListReportConfigsRequest request);

  virtual google::cloud::Idempotency GetReportConfig(
      google::cloud::storageinsights::v1::GetReportConfigRequest const&
          request);

  virtual google::cloud::Idempotency CreateReportConfig(
      google::cloud::storageinsights::v1::CreateReportConfigRequest const&
          request);

  virtual google::cloud::Idempotency UpdateReportConfig(
      google::cloud::storageinsights::v1::UpdateReportConfigRequest const&
          request);

  virtual google::cloud::Idempotency DeleteReportConfig(
      google::cloud::storageinsights::v1::DeleteReportConfigRequest const&
          request);

  virtual google::cloud::Idempotency ListReportDetails(
      google::cloud::storageinsights::v1::ListReportDetailsRequest request);

  virtual google::cloud::Idempotency GetReportDetail(
      google::cloud::storageinsights::v1::GetReportDetailRequest const&
          request);
};

std::unique_ptr<StorageInsightsConnectionIdempotencyPolicy>
MakeDefaultStorageInsightsConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storageinsights_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGEINSIGHTS_V1_STORAGE_INSIGHTS_CONNECTION_IDEMPOTENCY_POLICY_H
