/*
 * Decompiled with CFR 0.152.
 */
package jflex.core;

import java.util.Objects;
import jflex.exceptions.GeneratorException;
import jflex.logging.Out;

public final class Action {
    public final String content;
    public final int priority;
    private Kind kind = Kind.NORMAL;
    private int len;
    private int entryState;

    public Action(String content, int priority) {
        this.content = content.trim();
        this.priority = priority;
    }

    public Action(Kind kind) {
        if (kind != Kind.FORWARD_ACTION && kind != Kind.BACKWARD_ACTION) {
            throw new GeneratorException();
        }
        this.content = "";
        this.priority = Integer.MAX_VALUE;
        this.kind = kind;
    }

    public Action getHigherPriority(Action other) {
        if (other == null) {
            return this;
        }
        if (other.priority > this.priority) {
            return this;
        }
        return other;
    }

    public String toString() {
        return "Action (priority " + this.priority + ", lookahead " + (Object)((Object)this.kind) + ") :" + Out.NL + this.content;
    }

    public boolean isEquiv(Action a) {
        return Objects.equals(this.content, a.content) && this.kind == a.kind && this.len == a.len && this.entryState == a.entryState;
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Action) {
            if (o == this) {
                return true;
            }
            return this.isEquiv((Action)o);
        }
        return false;
    }

    public boolean isGenLookAction() {
        return this.kind == Kind.GENERAL_LOOK;
    }

    public boolean isEmittable() {
        return this.kind != Kind.BACKWARD_ACTION && this.kind != Kind.FORWARD_ACTION;
    }

    public Kind lookAhead() {
        return this.kind;
    }

    public void setLookAction(Kind kind, int data) {
        this.kind = kind;
        this.len = data;
    }

    public int getLookLength() {
        return this.len;
    }

    public int getEntryState() {
        return this.entryState;
    }

    public void setEntryState(int entryState) {
        this.entryState = entryState;
    }

    public Action copyChoice(int length) {
        Action a = new Action(this.content, this.priority);
        a.setLookAction(Kind.FINITE_CHOICE, length);
        return a;
    }

    public String lookString() {
        switch (this.kind) {
            case NORMAL: {
                return "";
            }
            case BACKWARD_ACTION: {
                return "LOOK_BACK";
            }
            case FIXED_BASE: {
                return "FIXED_BASE";
            }
            case FIXED_LOOK: {
                return "FIXED_LOOK";
            }
            case FINITE_CHOICE: {
                return "FINITE_CHOICE";
            }
            case FORWARD_ACTION: {
                return "LOOK_FORWARD";
            }
            case GENERAL_LOOK: {
                return "LOOK_ACTION";
            }
        }
        return "unknown lookahead type";
    }

    public static enum Kind {
        NORMAL,
        FIXED_BASE,
        FIXED_LOOK,
        FINITE_CHOICE,
        GENERAL_LOOK,
        FORWARD_ACTION,
        BACKWARD_ACTION;

    }
}

