SYD-TOR(1)

# NAME

syd-tor - SOCKS Proxy Forwarder

# SYNOPSIS

*syd-tor* _[-dh]_ _-p <pid-fd>_ _-i <socket-fd>_ _[-o addr:port]_ _[-u unix-sock]_

# DESCRIPTION

Receives listening socket from fd and forwards traffic to addr:port or
UNIX socket.

External address must either be an IPv4, or an IPv6 address or path to a
UNIX domain socket, defaults to *127.0.0.1:9050*.

PID file descriptor is used to track the exit of Syd process.

# OPTIONS

|[ *-h*
:< Display help.
|[ *-d*
:< Run in debug mode without confinement.
|[ *-p* *pid-fd*
:< PID file descriptor of Syd process.
|[ *-i* *socket-fd*
:< Socket file descriptor to receive the listening socket from.
|[ *-o* *ext-addr*
:< Specify external address to forward traffic to.
|[
:< Address may be an IPv4/IPv6 address in format "addr:port".
|[
:< Defaults to "127.0.0.1:9050".
|[ *-u* *unix-sock*
:< Specify UNIX domain socket to forward traffic to.
|[
:< This option has precedence over *-o*.

# USAGE

_syd-tor_(1) is not meant to be used as a standalone tool. Syd invokes
_syd-tor_(1) at startup when Proxy sandboxing is set to on with
"sandbox/proxy:on". See the PROXY SANDBOXING section in _syd_(7) manual
page for more information. If you want to use _syd-tor_(1) in your own
project, what you need to do first is to pass it a _non-blocking_ PID fd
of your own process with the "-p <pid-fd>" argument so _syd-tor_(1) can
simultaneously exit with it. Care should be given at this stage as PID
file descriptors are "O_CLOEXEC" by default. Next, create a UNIX
socket-pair, enter a network namespace, bring up the loopback device,
_bind_(2) a socket to a port on it and then send this socket file
descriptor through the write end of the socket-pair with _sendmsg_(2)
"SCM_RIGHTS" option. Finally pass the read end of the socket-pair to
_syd-tor_(1) with the "-i <socket-fd>" argument.

# IMPLEMENTATION

_syd-tor_(1) is designed with performance, security, and privacy in
mind, utilizing advanced techniques such as edge-triggered _epoll_(7)
for efficient event notification and full asynchronous operations to
handle multiple connections without blocking. It employs zero-copy data
transfer using the _splice_(2) system call to move data directly between
file descriptors within the kernel, ensuring high performance and data
privacy. To facilitate bidirectional communication, _syd-tor_(1) uses
two pairs of pipes, allowing seamless data flow between the client and
the external address. Additionally, _syd-tor_(1) confines its execution
environment using seccomp and Landlock, restricting system calls and
file accesses to minimize the attack surface.  Compared to socksns,
which uses the Tokio runtime for asynchronous I/O, _syd-tor_(1)
emphasizes kernel-level efficiency and security, making it a robust
solution for SOCKS proxy forwarding.

# SECURITY

_syd-tor_(1) implements comprehensive security measures to mitigate
risks associated with running outside the Syd sandbox, thus preventing
potential Meddler-in-the-Middle (MITM) attacks against containers.
Seccomp filters are carefully configured to allow only the required
syscalls. The _socket_(2) syscall is limited to a single domain, type,
and protocol, while _connect_(2) is restricted to a single memory
address, preventing unauthorized network connections. These restrictions
are most effective on 64-bit architectures, but on 32-bit systems the
_socketcall_(2) interface may be exploited. Therefore, additional
protective measures are implemented. On Linux 6.10 and later, the
memory area containing the external network address is sealed using
_mseal_(2) and surrounding memory is protected with guard pages to
prevent overflow or adjacent corruption. Executable memory is also
disallowed to prevent code injection attacks. Additionally, reading the
timestamp counter is blocked on x86 systems, making timing attacks more
difficult to execute. If available, Landlock and namespaces impose
further restrictions by disallowing all filesystem access, thereby
providing an extra layer of security. Together, these techniques ensure
that even if _syd-tor_(1) is compromised, the scope of malicious actions
is significantly limited, maintaining the overall integrity and security
of the system.

# ENVIRONMENT

|[ *SYD_TOR_DEBUG*
:< Run in debug mode without confinement, equivalent to the "-d" option
|[ *SYD_TOR_RULES*
:< Print seccomp rules in human-readable format to standard error at startup

# BUGS

The _syd-tor_(1) process runs as a single process and can potentially
hit file descriptor (FD) limits due to the number of FDs it opens per
connection. Each client connection involves six FDs: one for the client
socket, one for the external socket, and four for the pipes used for
bidirectional data transfer (two pipes with an input and output FD
each). To mitigate this, _syd-tor_(1) sets the file-max limit to the
hard limit by overriding the soft limit at startup. However, in some
cases, this may not be sufficient, and manual adjustment of FD limits
may be necessary.

# SEE ALSO

_syd_(1), _syd_(2), _syd_(7)

*syd* homepage: https://sydbox.exherbo.org/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
