/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.ScrollableResults;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.hql.QueryTranslator;
import net.sf.hibernate.type.Type;

public class ScrollableResultsImpl
implements ScrollableResults {
    private final ResultSet rs;
    private final PreparedStatement ps;
    private final SessionImplementor sess;
    private final Type[] types;
    private final String[][] names;

    public boolean scroll(int i) throws HibernateException {
        try {
            return this.rs.relative(i);
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public boolean first() throws HibernateException {
        try {
            return this.rs.first();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public boolean last() throws HibernateException {
        try {
            return this.rs.last();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public boolean next() throws HibernateException {
        try {
            return this.rs.next();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public boolean previous() throws HibernateException {
        try {
            return this.rs.previous();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public Object[] get() throws HibernateException {
        Object[] row = new Object[this.types.length];
        int i = 0;
        while (i < this.types.length) {
            try {
                row[i] = this.types[i].nullSafeGet(this.rs, this.names[i], this.sess, null);
            }
            catch (SQLException sqle) {
                throw new JDBCException(sqle);
            }
            ++i;
        }
        return row;
    }

    public Object get(int col) throws HibernateException {
        try {
            return this.types[col].nullSafeGet(this.rs, this.names[col], this.sess, null);
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public ScrollableResultsImpl(ResultSet rs, PreparedStatement ps, SessionImplementor sess, Type[] types) throws MappingException {
        this.rs = rs;
        this.ps = ps;
        this.sess = sess;
        this.types = types;
        this.names = new String[types.length][];
        int i = 0;
        while (i < types.length) {
            int span = types[i].getColumnSpan(sess.getFactory());
            this.names[i] = new String[span];
            int j = 0;
            while (j < span) {
                this.names[i][j] = QueryTranslator.scalarName(i, j);
                ++j;
            }
            ++i;
        }
    }

    public BigDecimal getBigDecimal(int col) throws HibernateException {
        return (BigDecimal)this.get(col);
    }

    public byte[] getBinary(int col) throws HibernateException {
        return (byte[])this.get(col);
    }

    public Blob getBlob(int col) throws HibernateException {
        return (Blob)this.get(col);
    }

    public Clob getClob(int col) throws HibernateException {
        return (Clob)this.get(col);
    }

    public Boolean getBoolean(int col) throws HibernateException {
        return (Boolean)this.get(col);
    }

    public Byte getByte(int col) throws HibernateException {
        return (Byte)this.get(col);
    }

    public Character getCharacter(int col) throws HibernateException {
        return (Character)this.get(col);
    }

    public Date getDate(int col) throws HibernateException {
        return (Date)this.get(col);
    }

    public Calendar getCalendar(int col) throws HibernateException {
        return (Calendar)this.get(col);
    }

    public Double getDouble(int col) throws HibernateException {
        return (Double)this.get(col);
    }

    public Float getFloat(int col) throws HibernateException {
        return (Float)this.get(col);
    }

    public Integer getInteger(int col) throws HibernateException {
        return (Integer)this.get(col);
    }

    public Long getLong(int col) throws HibernateException {
        return (Long)this.get(col);
    }

    public Short getShort(int col) throws HibernateException {
        return (Short)this.get(col);
    }

    public String getString(int col) throws HibernateException {
        return (String)this.get(col);
    }

    public void afterLast() throws HibernateException {
        try {
            this.rs.afterLast();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public void beforeFirst() throws HibernateException {
        try {
            this.rs.beforeFirst();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public void close() throws HibernateException {
        try {
            this.sess.getBatcher().closeQueryStatement(this.ps, this.rs);
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public Locale getLocale(int col) throws HibernateException {
        return (Locale)this.get(col);
    }

    public TimeZone getTimeZone(int col) throws HibernateException {
        return (TimeZone)this.get(col);
    }

    public Type getType(int i) {
        return this.types[i];
    }

    public boolean isFirst() throws HibernateException {
        try {
            return this.rs.isFirst();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public boolean isLast() throws HibernateException {
        try {
            return this.rs.isLast();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }
}

