// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: testify

package docker

import (
	"context"
	"io"
	"time"

	"github.com/docker/docker/api/types"
	"github.com/docker/docker/api/types/container"
	"github.com/docker/docker/api/types/image"
	"github.com/docker/docker/api/types/network"
	"github.com/docker/docker/api/types/system"
	"github.com/docker/docker/api/types/volume"
	"github.com/opencontainers/image-spec/specs-go/v1"
	mock "github.com/stretchr/testify/mock"
)

// NewMockClient creates a new instance of MockClient. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockClient(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockClient {
	mock := &MockClient{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockClient is an autogenerated mock type for the Client type
type MockClient struct {
	mock.Mock
}

type MockClient_Expecter struct {
	mock *mock.Mock
}

func (_m *MockClient) EXPECT() *MockClient_Expecter {
	return &MockClient_Expecter{mock: &_m.Mock}
}

// ClientVersion provides a mock function for the type MockClient
func (_mock *MockClient) ClientVersion() string {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for ClientVersion")
	}

	var r0 string
	if returnFunc, ok := ret.Get(0).(func() string); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(string)
	}
	return r0
}

// MockClient_ClientVersion_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ClientVersion'
type MockClient_ClientVersion_Call struct {
	*mock.Call
}

// ClientVersion is a helper method to define mock.On call
func (_e *MockClient_Expecter) ClientVersion() *MockClient_ClientVersion_Call {
	return &MockClient_ClientVersion_Call{Call: _e.mock.On("ClientVersion")}
}

func (_c *MockClient_ClientVersion_Call) Run(run func()) *MockClient_ClientVersion_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockClient_ClientVersion_Call) Return(s string) *MockClient_ClientVersion_Call {
	_c.Call.Return(s)
	return _c
}

func (_c *MockClient_ClientVersion_Call) RunAndReturn(run func() string) *MockClient_ClientVersion_Call {
	_c.Call.Return(run)
	return _c
}

// Close provides a mock function for the type MockClient
func (_mock *MockClient) Close() error {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for Close")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func() error); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockClient_Close_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Close'
type MockClient_Close_Call struct {
	*mock.Call
}

// Close is a helper method to define mock.On call
func (_e *MockClient_Expecter) Close() *MockClient_Close_Call {
	return &MockClient_Close_Call{Call: _e.mock.On("Close")}
}

func (_c *MockClient_Close_Call) Run(run func()) *MockClient_Close_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockClient_Close_Call) Return(err error) *MockClient_Close_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockClient_Close_Call) RunAndReturn(run func() error) *MockClient_Close_Call {
	_c.Call.Return(run)
	return _c
}

// ContainerAttach provides a mock function for the type MockClient
func (_mock *MockClient) ContainerAttach(ctx context.Context, container1 string, options container.AttachOptions) (types.HijackedResponse, error) {
	ret := _mock.Called(ctx, container1, options)

	if len(ret) == 0 {
		panic("no return value specified for ContainerAttach")
	}

	var r0 types.HijackedResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, container.AttachOptions) (types.HijackedResponse, error)); ok {
		return returnFunc(ctx, container1, options)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, container.AttachOptions) types.HijackedResponse); ok {
		r0 = returnFunc(ctx, container1, options)
	} else {
		r0 = ret.Get(0).(types.HijackedResponse)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, string, container.AttachOptions) error); ok {
		r1 = returnFunc(ctx, container1, options)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_ContainerAttach_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ContainerAttach'
type MockClient_ContainerAttach_Call struct {
	*mock.Call
}

// ContainerAttach is a helper method to define mock.On call
//   - ctx context.Context
//   - container1 string
//   - options container.AttachOptions
func (_e *MockClient_Expecter) ContainerAttach(ctx interface{}, container1 interface{}, options interface{}) *MockClient_ContainerAttach_Call {
	return &MockClient_ContainerAttach_Call{Call: _e.mock.On("ContainerAttach", ctx, container1, options)}
}

func (_c *MockClient_ContainerAttach_Call) Run(run func(ctx context.Context, container1 string, options container.AttachOptions)) *MockClient_ContainerAttach_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 container.AttachOptions
		if args[2] != nil {
			arg2 = args[2].(container.AttachOptions)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockClient_ContainerAttach_Call) Return(hijackedResponse types.HijackedResponse, err error) *MockClient_ContainerAttach_Call {
	_c.Call.Return(hijackedResponse, err)
	return _c
}

func (_c *MockClient_ContainerAttach_Call) RunAndReturn(run func(ctx context.Context, container1 string, options container.AttachOptions) (types.HijackedResponse, error)) *MockClient_ContainerAttach_Call {
	_c.Call.Return(run)
	return _c
}

// ContainerCreate provides a mock function for the type MockClient
func (_mock *MockClient) ContainerCreate(ctx context.Context, config *container.Config, hostConfig *container.HostConfig, networkingConfig *network.NetworkingConfig, platform *v1.Platform, containerName string) (container.CreateResponse, error) {
	ret := _mock.Called(ctx, config, hostConfig, networkingConfig, platform, containerName)

	if len(ret) == 0 {
		panic("no return value specified for ContainerCreate")
	}

	var r0 container.CreateResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *container.Config, *container.HostConfig, *network.NetworkingConfig, *v1.Platform, string) (container.CreateResponse, error)); ok {
		return returnFunc(ctx, config, hostConfig, networkingConfig, platform, containerName)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *container.Config, *container.HostConfig, *network.NetworkingConfig, *v1.Platform, string) container.CreateResponse); ok {
		r0 = returnFunc(ctx, config, hostConfig, networkingConfig, platform, containerName)
	} else {
		r0 = ret.Get(0).(container.CreateResponse)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *container.Config, *container.HostConfig, *network.NetworkingConfig, *v1.Platform, string) error); ok {
		r1 = returnFunc(ctx, config, hostConfig, networkingConfig, platform, containerName)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_ContainerCreate_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ContainerCreate'
type MockClient_ContainerCreate_Call struct {
	*mock.Call
}

// ContainerCreate is a helper method to define mock.On call
//   - ctx context.Context
//   - config *container.Config
//   - hostConfig *container.HostConfig
//   - networkingConfig *network.NetworkingConfig
//   - platform *v1.Platform
//   - containerName string
func (_e *MockClient_Expecter) ContainerCreate(ctx interface{}, config interface{}, hostConfig interface{}, networkingConfig interface{}, platform interface{}, containerName interface{}) *MockClient_ContainerCreate_Call {
	return &MockClient_ContainerCreate_Call{Call: _e.mock.On("ContainerCreate", ctx, config, hostConfig, networkingConfig, platform, containerName)}
}

func (_c *MockClient_ContainerCreate_Call) Run(run func(ctx context.Context, config *container.Config, hostConfig *container.HostConfig, networkingConfig *network.NetworkingConfig, platform *v1.Platform, containerName string)) *MockClient_ContainerCreate_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *container.Config
		if args[1] != nil {
			arg1 = args[1].(*container.Config)
		}
		var arg2 *container.HostConfig
		if args[2] != nil {
			arg2 = args[2].(*container.HostConfig)
		}
		var arg3 *network.NetworkingConfig
		if args[3] != nil {
			arg3 = args[3].(*network.NetworkingConfig)
		}
		var arg4 *v1.Platform
		if args[4] != nil {
			arg4 = args[4].(*v1.Platform)
		}
		var arg5 string
		if args[5] != nil {
			arg5 = args[5].(string)
		}
		run(
			arg0,
			arg1,
			arg2,
			arg3,
			arg4,
			arg5,
		)
	})
	return _c
}

func (_c *MockClient_ContainerCreate_Call) Return(createResponse container.CreateResponse, err error) *MockClient_ContainerCreate_Call {
	_c.Call.Return(createResponse, err)
	return _c
}

func (_c *MockClient_ContainerCreate_Call) RunAndReturn(run func(ctx context.Context, config *container.Config, hostConfig *container.HostConfig, networkingConfig *network.NetworkingConfig, platform *v1.Platform, containerName string) (container.CreateResponse, error)) *MockClient_ContainerCreate_Call {
	_c.Call.Return(run)
	return _c
}

// ContainerExecAttach provides a mock function for the type MockClient
func (_mock *MockClient) ContainerExecAttach(ctx context.Context, execID string, config container.ExecStartOptions) (types.HijackedResponse, error) {
	ret := _mock.Called(ctx, execID, config)

	if len(ret) == 0 {
		panic("no return value specified for ContainerExecAttach")
	}

	var r0 types.HijackedResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, container.ExecStartOptions) (types.HijackedResponse, error)); ok {
		return returnFunc(ctx, execID, config)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, container.ExecStartOptions) types.HijackedResponse); ok {
		r0 = returnFunc(ctx, execID, config)
	} else {
		r0 = ret.Get(0).(types.HijackedResponse)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, string, container.ExecStartOptions) error); ok {
		r1 = returnFunc(ctx, execID, config)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_ContainerExecAttach_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ContainerExecAttach'
type MockClient_ContainerExecAttach_Call struct {
	*mock.Call
}

// ContainerExecAttach is a helper method to define mock.On call
//   - ctx context.Context
//   - execID string
//   - config container.ExecStartOptions
func (_e *MockClient_Expecter) ContainerExecAttach(ctx interface{}, execID interface{}, config interface{}) *MockClient_ContainerExecAttach_Call {
	return &MockClient_ContainerExecAttach_Call{Call: _e.mock.On("ContainerExecAttach", ctx, execID, config)}
}

func (_c *MockClient_ContainerExecAttach_Call) Run(run func(ctx context.Context, execID string, config container.ExecStartOptions)) *MockClient_ContainerExecAttach_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 container.ExecStartOptions
		if args[2] != nil {
			arg2 = args[2].(container.ExecStartOptions)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockClient_ContainerExecAttach_Call) Return(hijackedResponse types.HijackedResponse, err error) *MockClient_ContainerExecAttach_Call {
	_c.Call.Return(hijackedResponse, err)
	return _c
}

func (_c *MockClient_ContainerExecAttach_Call) RunAndReturn(run func(ctx context.Context, execID string, config container.ExecStartOptions) (types.HijackedResponse, error)) *MockClient_ContainerExecAttach_Call {
	_c.Call.Return(run)
	return _c
}

// ContainerExecCreate provides a mock function for the type MockClient
func (_mock *MockClient) ContainerExecCreate(ctx context.Context, container1 string, config container.ExecOptions) (types.IDResponse, error) {
	ret := _mock.Called(ctx, container1, config)

	if len(ret) == 0 {
		panic("no return value specified for ContainerExecCreate")
	}

	var r0 types.IDResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, container.ExecOptions) (types.IDResponse, error)); ok {
		return returnFunc(ctx, container1, config)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, container.ExecOptions) types.IDResponse); ok {
		r0 = returnFunc(ctx, container1, config)
	} else {
		r0 = ret.Get(0).(types.IDResponse)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, string, container.ExecOptions) error); ok {
		r1 = returnFunc(ctx, container1, config)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_ContainerExecCreate_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ContainerExecCreate'
type MockClient_ContainerExecCreate_Call struct {
	*mock.Call
}

// ContainerExecCreate is a helper method to define mock.On call
//   - ctx context.Context
//   - container1 string
//   - config container.ExecOptions
func (_e *MockClient_Expecter) ContainerExecCreate(ctx interface{}, container1 interface{}, config interface{}) *MockClient_ContainerExecCreate_Call {
	return &MockClient_ContainerExecCreate_Call{Call: _e.mock.On("ContainerExecCreate", ctx, container1, config)}
}

func (_c *MockClient_ContainerExecCreate_Call) Run(run func(ctx context.Context, container1 string, config container.ExecOptions)) *MockClient_ContainerExecCreate_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 container.ExecOptions
		if args[2] != nil {
			arg2 = args[2].(container.ExecOptions)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockClient_ContainerExecCreate_Call) Return(iDResponse types.IDResponse, err error) *MockClient_ContainerExecCreate_Call {
	_c.Call.Return(iDResponse, err)
	return _c
}

func (_c *MockClient_ContainerExecCreate_Call) RunAndReturn(run func(ctx context.Context, container1 string, config container.ExecOptions) (types.IDResponse, error)) *MockClient_ContainerExecCreate_Call {
	_c.Call.Return(run)
	return _c
}

// ContainerInspect provides a mock function for the type MockClient
func (_mock *MockClient) ContainerInspect(ctx context.Context, containerID string) (types.ContainerJSON, error) {
	ret := _mock.Called(ctx, containerID)

	if len(ret) == 0 {
		panic("no return value specified for ContainerInspect")
	}

	var r0 types.ContainerJSON
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string) (types.ContainerJSON, error)); ok {
		return returnFunc(ctx, containerID)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, string) types.ContainerJSON); ok {
		r0 = returnFunc(ctx, containerID)
	} else {
		r0 = ret.Get(0).(types.ContainerJSON)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = returnFunc(ctx, containerID)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_ContainerInspect_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ContainerInspect'
type MockClient_ContainerInspect_Call struct {
	*mock.Call
}

// ContainerInspect is a helper method to define mock.On call
//   - ctx context.Context
//   - containerID string
func (_e *MockClient_Expecter) ContainerInspect(ctx interface{}, containerID interface{}) *MockClient_ContainerInspect_Call {
	return &MockClient_ContainerInspect_Call{Call: _e.mock.On("ContainerInspect", ctx, containerID)}
}

func (_c *MockClient_ContainerInspect_Call) Run(run func(ctx context.Context, containerID string)) *MockClient_ContainerInspect_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockClient_ContainerInspect_Call) Return(containerJSON types.ContainerJSON, err error) *MockClient_ContainerInspect_Call {
	_c.Call.Return(containerJSON, err)
	return _c
}

func (_c *MockClient_ContainerInspect_Call) RunAndReturn(run func(ctx context.Context, containerID string) (types.ContainerJSON, error)) *MockClient_ContainerInspect_Call {
	_c.Call.Return(run)
	return _c
}

// ContainerKill provides a mock function for the type MockClient
func (_mock *MockClient) ContainerKill(ctx context.Context, containerID string, signal string) error {
	ret := _mock.Called(ctx, containerID, signal)

	if len(ret) == 0 {
		panic("no return value specified for ContainerKill")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, string) error); ok {
		r0 = returnFunc(ctx, containerID, signal)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockClient_ContainerKill_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ContainerKill'
type MockClient_ContainerKill_Call struct {
	*mock.Call
}

// ContainerKill is a helper method to define mock.On call
//   - ctx context.Context
//   - containerID string
//   - signal string
func (_e *MockClient_Expecter) ContainerKill(ctx interface{}, containerID interface{}, signal interface{}) *MockClient_ContainerKill_Call {
	return &MockClient_ContainerKill_Call{Call: _e.mock.On("ContainerKill", ctx, containerID, signal)}
}

func (_c *MockClient_ContainerKill_Call) Run(run func(ctx context.Context, containerID string, signal string)) *MockClient_ContainerKill_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 string
		if args[2] != nil {
			arg2 = args[2].(string)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockClient_ContainerKill_Call) Return(err error) *MockClient_ContainerKill_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockClient_ContainerKill_Call) RunAndReturn(run func(ctx context.Context, containerID string, signal string) error) *MockClient_ContainerKill_Call {
	_c.Call.Return(run)
	return _c
}

// ContainerList provides a mock function for the type MockClient
func (_mock *MockClient) ContainerList(ctx context.Context, options container.ListOptions) ([]types.Container, error) {
	ret := _mock.Called(ctx, options)

	if len(ret) == 0 {
		panic("no return value specified for ContainerList")
	}

	var r0 []types.Container
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, container.ListOptions) ([]types.Container, error)); ok {
		return returnFunc(ctx, options)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, container.ListOptions) []types.Container); ok {
		r0 = returnFunc(ctx, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]types.Container)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, container.ListOptions) error); ok {
		r1 = returnFunc(ctx, options)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_ContainerList_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ContainerList'
type MockClient_ContainerList_Call struct {
	*mock.Call
}

// ContainerList is a helper method to define mock.On call
//   - ctx context.Context
//   - options container.ListOptions
func (_e *MockClient_Expecter) ContainerList(ctx interface{}, options interface{}) *MockClient_ContainerList_Call {
	return &MockClient_ContainerList_Call{Call: _e.mock.On("ContainerList", ctx, options)}
}

func (_c *MockClient_ContainerList_Call) Run(run func(ctx context.Context, options container.ListOptions)) *MockClient_ContainerList_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 container.ListOptions
		if args[1] != nil {
			arg1 = args[1].(container.ListOptions)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockClient_ContainerList_Call) Return(containers []types.Container, err error) *MockClient_ContainerList_Call {
	_c.Call.Return(containers, err)
	return _c
}

func (_c *MockClient_ContainerList_Call) RunAndReturn(run func(ctx context.Context, options container.ListOptions) ([]types.Container, error)) *MockClient_ContainerList_Call {
	_c.Call.Return(run)
	return _c
}

// ContainerLogs provides a mock function for the type MockClient
func (_mock *MockClient) ContainerLogs(ctx context.Context, container1 string, options container.LogsOptions) (io.ReadCloser, error) {
	ret := _mock.Called(ctx, container1, options)

	if len(ret) == 0 {
		panic("no return value specified for ContainerLogs")
	}

	var r0 io.ReadCloser
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, container.LogsOptions) (io.ReadCloser, error)); ok {
		return returnFunc(ctx, container1, options)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, container.LogsOptions) io.ReadCloser); ok {
		r0 = returnFunc(ctx, container1, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(io.ReadCloser)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, string, container.LogsOptions) error); ok {
		r1 = returnFunc(ctx, container1, options)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_ContainerLogs_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ContainerLogs'
type MockClient_ContainerLogs_Call struct {
	*mock.Call
}

// ContainerLogs is a helper method to define mock.On call
//   - ctx context.Context
//   - container1 string
//   - options container.LogsOptions
func (_e *MockClient_Expecter) ContainerLogs(ctx interface{}, container1 interface{}, options interface{}) *MockClient_ContainerLogs_Call {
	return &MockClient_ContainerLogs_Call{Call: _e.mock.On("ContainerLogs", ctx, container1, options)}
}

func (_c *MockClient_ContainerLogs_Call) Run(run func(ctx context.Context, container1 string, options container.LogsOptions)) *MockClient_ContainerLogs_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 container.LogsOptions
		if args[2] != nil {
			arg2 = args[2].(container.LogsOptions)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockClient_ContainerLogs_Call) Return(readCloser io.ReadCloser, err error) *MockClient_ContainerLogs_Call {
	_c.Call.Return(readCloser, err)
	return _c
}

func (_c *MockClient_ContainerLogs_Call) RunAndReturn(run func(ctx context.Context, container1 string, options container.LogsOptions) (io.ReadCloser, error)) *MockClient_ContainerLogs_Call {
	_c.Call.Return(run)
	return _c
}

// ContainerRemove provides a mock function for the type MockClient
func (_mock *MockClient) ContainerRemove(ctx context.Context, containerID string, options container.RemoveOptions) error {
	ret := _mock.Called(ctx, containerID, options)

	if len(ret) == 0 {
		panic("no return value specified for ContainerRemove")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, container.RemoveOptions) error); ok {
		r0 = returnFunc(ctx, containerID, options)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockClient_ContainerRemove_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ContainerRemove'
type MockClient_ContainerRemove_Call struct {
	*mock.Call
}

// ContainerRemove is a helper method to define mock.On call
//   - ctx context.Context
//   - containerID string
//   - options container.RemoveOptions
func (_e *MockClient_Expecter) ContainerRemove(ctx interface{}, containerID interface{}, options interface{}) *MockClient_ContainerRemove_Call {
	return &MockClient_ContainerRemove_Call{Call: _e.mock.On("ContainerRemove", ctx, containerID, options)}
}

func (_c *MockClient_ContainerRemove_Call) Run(run func(ctx context.Context, containerID string, options container.RemoveOptions)) *MockClient_ContainerRemove_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 container.RemoveOptions
		if args[2] != nil {
			arg2 = args[2].(container.RemoveOptions)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockClient_ContainerRemove_Call) Return(err error) *MockClient_ContainerRemove_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockClient_ContainerRemove_Call) RunAndReturn(run func(ctx context.Context, containerID string, options container.RemoveOptions) error) *MockClient_ContainerRemove_Call {
	_c.Call.Return(run)
	return _c
}

// ContainerStart provides a mock function for the type MockClient
func (_mock *MockClient) ContainerStart(ctx context.Context, containerID string, options container.StartOptions) error {
	ret := _mock.Called(ctx, containerID, options)

	if len(ret) == 0 {
		panic("no return value specified for ContainerStart")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, container.StartOptions) error); ok {
		r0 = returnFunc(ctx, containerID, options)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockClient_ContainerStart_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ContainerStart'
type MockClient_ContainerStart_Call struct {
	*mock.Call
}

// ContainerStart is a helper method to define mock.On call
//   - ctx context.Context
//   - containerID string
//   - options container.StartOptions
func (_e *MockClient_Expecter) ContainerStart(ctx interface{}, containerID interface{}, options interface{}) *MockClient_ContainerStart_Call {
	return &MockClient_ContainerStart_Call{Call: _e.mock.On("ContainerStart", ctx, containerID, options)}
}

func (_c *MockClient_ContainerStart_Call) Run(run func(ctx context.Context, containerID string, options container.StartOptions)) *MockClient_ContainerStart_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 container.StartOptions
		if args[2] != nil {
			arg2 = args[2].(container.StartOptions)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockClient_ContainerStart_Call) Return(err error) *MockClient_ContainerStart_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockClient_ContainerStart_Call) RunAndReturn(run func(ctx context.Context, containerID string, options container.StartOptions) error) *MockClient_ContainerStart_Call {
	_c.Call.Return(run)
	return _c
}

// ContainerStop provides a mock function for the type MockClient
func (_mock *MockClient) ContainerStop(ctx context.Context, containerID string, opions container.StopOptions) error {
	ret := _mock.Called(ctx, containerID, opions)

	if len(ret) == 0 {
		panic("no return value specified for ContainerStop")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, container.StopOptions) error); ok {
		r0 = returnFunc(ctx, containerID, opions)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockClient_ContainerStop_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ContainerStop'
type MockClient_ContainerStop_Call struct {
	*mock.Call
}

// ContainerStop is a helper method to define mock.On call
//   - ctx context.Context
//   - containerID string
//   - opions container.StopOptions
func (_e *MockClient_Expecter) ContainerStop(ctx interface{}, containerID interface{}, opions interface{}) *MockClient_ContainerStop_Call {
	return &MockClient_ContainerStop_Call{Call: _e.mock.On("ContainerStop", ctx, containerID, opions)}
}

func (_c *MockClient_ContainerStop_Call) Run(run func(ctx context.Context, containerID string, opions container.StopOptions)) *MockClient_ContainerStop_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 container.StopOptions
		if args[2] != nil {
			arg2 = args[2].(container.StopOptions)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockClient_ContainerStop_Call) Return(err error) *MockClient_ContainerStop_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockClient_ContainerStop_Call) RunAndReturn(run func(ctx context.Context, containerID string, opions container.StopOptions) error) *MockClient_ContainerStop_Call {
	_c.Call.Return(run)
	return _c
}

// ContainerWait provides a mock function for the type MockClient
func (_mock *MockClient) ContainerWait(ctx context.Context, containerID string, condition container.WaitCondition) (<-chan container.WaitResponse, <-chan error) {
	ret := _mock.Called(ctx, containerID, condition)

	if len(ret) == 0 {
		panic("no return value specified for ContainerWait")
	}

	var r0 <-chan container.WaitResponse
	var r1 <-chan error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, container.WaitCondition) (<-chan container.WaitResponse, <-chan error)); ok {
		return returnFunc(ctx, containerID, condition)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, container.WaitCondition) <-chan container.WaitResponse); ok {
		r0 = returnFunc(ctx, containerID, condition)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(<-chan container.WaitResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, string, container.WaitCondition) <-chan error); ok {
		r1 = returnFunc(ctx, containerID, condition)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(<-chan error)
		}
	}
	return r0, r1
}

// MockClient_ContainerWait_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ContainerWait'
type MockClient_ContainerWait_Call struct {
	*mock.Call
}

// ContainerWait is a helper method to define mock.On call
//   - ctx context.Context
//   - containerID string
//   - condition container.WaitCondition
func (_e *MockClient_Expecter) ContainerWait(ctx interface{}, containerID interface{}, condition interface{}) *MockClient_ContainerWait_Call {
	return &MockClient_ContainerWait_Call{Call: _e.mock.On("ContainerWait", ctx, containerID, condition)}
}

func (_c *MockClient_ContainerWait_Call) Run(run func(ctx context.Context, containerID string, condition container.WaitCondition)) *MockClient_ContainerWait_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 container.WaitCondition
		if args[2] != nil {
			arg2 = args[2].(container.WaitCondition)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockClient_ContainerWait_Call) Return(waitResponseCh <-chan container.WaitResponse, errCh <-chan error) *MockClient_ContainerWait_Call {
	_c.Call.Return(waitResponseCh, errCh)
	return _c
}

func (_c *MockClient_ContainerWait_Call) RunAndReturn(run func(ctx context.Context, containerID string, condition container.WaitCondition) (<-chan container.WaitResponse, <-chan error)) *MockClient_ContainerWait_Call {
	_c.Call.Return(run)
	return _c
}

// ImageImportBlocking provides a mock function for the type MockClient
func (_mock *MockClient) ImageImportBlocking(ctx context.Context, source image.ImportSource, ref string, options image.ImportOptions) error {
	ret := _mock.Called(ctx, source, ref, options)

	if len(ret) == 0 {
		panic("no return value specified for ImageImportBlocking")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, image.ImportSource, string, image.ImportOptions) error); ok {
		r0 = returnFunc(ctx, source, ref, options)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockClient_ImageImportBlocking_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ImageImportBlocking'
type MockClient_ImageImportBlocking_Call struct {
	*mock.Call
}

// ImageImportBlocking is a helper method to define mock.On call
//   - ctx context.Context
//   - source image.ImportSource
//   - ref string
//   - options image.ImportOptions
func (_e *MockClient_Expecter) ImageImportBlocking(ctx interface{}, source interface{}, ref interface{}, options interface{}) *MockClient_ImageImportBlocking_Call {
	return &MockClient_ImageImportBlocking_Call{Call: _e.mock.On("ImageImportBlocking", ctx, source, ref, options)}
}

func (_c *MockClient_ImageImportBlocking_Call) Run(run func(ctx context.Context, source image.ImportSource, ref string, options image.ImportOptions)) *MockClient_ImageImportBlocking_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 image.ImportSource
		if args[1] != nil {
			arg1 = args[1].(image.ImportSource)
		}
		var arg2 string
		if args[2] != nil {
			arg2 = args[2].(string)
		}
		var arg3 image.ImportOptions
		if args[3] != nil {
			arg3 = args[3].(image.ImportOptions)
		}
		run(
			arg0,
			arg1,
			arg2,
			arg3,
		)
	})
	return _c
}

func (_c *MockClient_ImageImportBlocking_Call) Return(err error) *MockClient_ImageImportBlocking_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockClient_ImageImportBlocking_Call) RunAndReturn(run func(ctx context.Context, source image.ImportSource, ref string, options image.ImportOptions) error) *MockClient_ImageImportBlocking_Call {
	_c.Call.Return(run)
	return _c
}

// ImageInspectWithRaw provides a mock function for the type MockClient
func (_mock *MockClient) ImageInspectWithRaw(ctx context.Context, imageID string) (types.ImageInspect, []byte, error) {
	ret := _mock.Called(ctx, imageID)

	if len(ret) == 0 {
		panic("no return value specified for ImageInspectWithRaw")
	}

	var r0 types.ImageInspect
	var r1 []byte
	var r2 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string) (types.ImageInspect, []byte, error)); ok {
		return returnFunc(ctx, imageID)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, string) types.ImageInspect); ok {
		r0 = returnFunc(ctx, imageID)
	} else {
		r0 = ret.Get(0).(types.ImageInspect)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, string) []byte); ok {
		r1 = returnFunc(ctx, imageID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]byte)
		}
	}
	if returnFunc, ok := ret.Get(2).(func(context.Context, string) error); ok {
		r2 = returnFunc(ctx, imageID)
	} else {
		r2 = ret.Error(2)
	}
	return r0, r1, r2
}

// MockClient_ImageInspectWithRaw_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ImageInspectWithRaw'
type MockClient_ImageInspectWithRaw_Call struct {
	*mock.Call
}

// ImageInspectWithRaw is a helper method to define mock.On call
//   - ctx context.Context
//   - imageID string
func (_e *MockClient_Expecter) ImageInspectWithRaw(ctx interface{}, imageID interface{}) *MockClient_ImageInspectWithRaw_Call {
	return &MockClient_ImageInspectWithRaw_Call{Call: _e.mock.On("ImageInspectWithRaw", ctx, imageID)}
}

func (_c *MockClient_ImageInspectWithRaw_Call) Run(run func(ctx context.Context, imageID string)) *MockClient_ImageInspectWithRaw_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockClient_ImageInspectWithRaw_Call) Return(imageInspect types.ImageInspect, bytes []byte, err error) *MockClient_ImageInspectWithRaw_Call {
	_c.Call.Return(imageInspect, bytes, err)
	return _c
}

func (_c *MockClient_ImageInspectWithRaw_Call) RunAndReturn(run func(ctx context.Context, imageID string) (types.ImageInspect, []byte, error)) *MockClient_ImageInspectWithRaw_Call {
	_c.Call.Return(run)
	return _c
}

// ImageLoad provides a mock function for the type MockClient
func (_mock *MockClient) ImageLoad(ctx context.Context, input io.Reader, quiet bool) (image.LoadResponse, error) {
	ret := _mock.Called(ctx, input, quiet)

	if len(ret) == 0 {
		panic("no return value specified for ImageLoad")
	}

	var r0 image.LoadResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, io.Reader, bool) (image.LoadResponse, error)); ok {
		return returnFunc(ctx, input, quiet)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, io.Reader, bool) image.LoadResponse); ok {
		r0 = returnFunc(ctx, input, quiet)
	} else {
		r0 = ret.Get(0).(image.LoadResponse)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, io.Reader, bool) error); ok {
		r1 = returnFunc(ctx, input, quiet)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_ImageLoad_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ImageLoad'
type MockClient_ImageLoad_Call struct {
	*mock.Call
}

// ImageLoad is a helper method to define mock.On call
//   - ctx context.Context
//   - input io.Reader
//   - quiet bool
func (_e *MockClient_Expecter) ImageLoad(ctx interface{}, input interface{}, quiet interface{}) *MockClient_ImageLoad_Call {
	return &MockClient_ImageLoad_Call{Call: _e.mock.On("ImageLoad", ctx, input, quiet)}
}

func (_c *MockClient_ImageLoad_Call) Run(run func(ctx context.Context, input io.Reader, quiet bool)) *MockClient_ImageLoad_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 io.Reader
		if args[1] != nil {
			arg1 = args[1].(io.Reader)
		}
		var arg2 bool
		if args[2] != nil {
			arg2 = args[2].(bool)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockClient_ImageLoad_Call) Return(loadResponse image.LoadResponse, err error) *MockClient_ImageLoad_Call {
	_c.Call.Return(loadResponse, err)
	return _c
}

func (_c *MockClient_ImageLoad_Call) RunAndReturn(run func(ctx context.Context, input io.Reader, quiet bool) (image.LoadResponse, error)) *MockClient_ImageLoad_Call {
	_c.Call.Return(run)
	return _c
}

// ImagePullBlocking provides a mock function for the type MockClient
func (_mock *MockClient) ImagePullBlocking(ctx context.Context, ref string, options image.PullOptions) error {
	ret := _mock.Called(ctx, ref, options)

	if len(ret) == 0 {
		panic("no return value specified for ImagePullBlocking")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, image.PullOptions) error); ok {
		r0 = returnFunc(ctx, ref, options)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockClient_ImagePullBlocking_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ImagePullBlocking'
type MockClient_ImagePullBlocking_Call struct {
	*mock.Call
}

// ImagePullBlocking is a helper method to define mock.On call
//   - ctx context.Context
//   - ref string
//   - options image.PullOptions
func (_e *MockClient_Expecter) ImagePullBlocking(ctx interface{}, ref interface{}, options interface{}) *MockClient_ImagePullBlocking_Call {
	return &MockClient_ImagePullBlocking_Call{Call: _e.mock.On("ImagePullBlocking", ctx, ref, options)}
}

func (_c *MockClient_ImagePullBlocking_Call) Run(run func(ctx context.Context, ref string, options image.PullOptions)) *MockClient_ImagePullBlocking_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 image.PullOptions
		if args[2] != nil {
			arg2 = args[2].(image.PullOptions)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockClient_ImagePullBlocking_Call) Return(err error) *MockClient_ImagePullBlocking_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockClient_ImagePullBlocking_Call) RunAndReturn(run func(ctx context.Context, ref string, options image.PullOptions) error) *MockClient_ImagePullBlocking_Call {
	_c.Call.Return(run)
	return _c
}

// ImageTag provides a mock function for the type MockClient
func (_mock *MockClient) ImageTag(ctx context.Context, source string, target string) error {
	ret := _mock.Called(ctx, source, target)

	if len(ret) == 0 {
		panic("no return value specified for ImageTag")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, string) error); ok {
		r0 = returnFunc(ctx, source, target)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockClient_ImageTag_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ImageTag'
type MockClient_ImageTag_Call struct {
	*mock.Call
}

// ImageTag is a helper method to define mock.On call
//   - ctx context.Context
//   - source string
//   - target string
func (_e *MockClient_Expecter) ImageTag(ctx interface{}, source interface{}, target interface{}) *MockClient_ImageTag_Call {
	return &MockClient_ImageTag_Call{Call: _e.mock.On("ImageTag", ctx, source, target)}
}

func (_c *MockClient_ImageTag_Call) Run(run func(ctx context.Context, source string, target string)) *MockClient_ImageTag_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 string
		if args[2] != nil {
			arg2 = args[2].(string)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockClient_ImageTag_Call) Return(err error) *MockClient_ImageTag_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockClient_ImageTag_Call) RunAndReturn(run func(ctx context.Context, source string, target string) error) *MockClient_ImageTag_Call {
	_c.Call.Return(run)
	return _c
}

// Info provides a mock function for the type MockClient
func (_mock *MockClient) Info(ctx context.Context) (system.Info, error) {
	ret := _mock.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for Info")
	}

	var r0 system.Info
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context) (system.Info, error)); ok {
		return returnFunc(ctx)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context) system.Info); ok {
		r0 = returnFunc(ctx)
	} else {
		r0 = ret.Get(0).(system.Info)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = returnFunc(ctx)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_Info_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Info'
type MockClient_Info_Call struct {
	*mock.Call
}

// Info is a helper method to define mock.On call
//   - ctx context.Context
func (_e *MockClient_Expecter) Info(ctx interface{}) *MockClient_Info_Call {
	return &MockClient_Info_Call{Call: _e.mock.On("Info", ctx)}
}

func (_c *MockClient_Info_Call) Run(run func(ctx context.Context)) *MockClient_Info_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockClient_Info_Call) Return(info system.Info, err error) *MockClient_Info_Call {
	_c.Call.Return(info, err)
	return _c
}

func (_c *MockClient_Info_Call) RunAndReturn(run func(ctx context.Context) (system.Info, error)) *MockClient_Info_Call {
	_c.Call.Return(run)
	return _c
}

// NetworkCreate provides a mock function for the type MockClient
func (_mock *MockClient) NetworkCreate(ctx context.Context, networkName string, options network.CreateOptions) (network.CreateResponse, error) {
	ret := _mock.Called(ctx, networkName, options)

	if len(ret) == 0 {
		panic("no return value specified for NetworkCreate")
	}

	var r0 network.CreateResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, network.CreateOptions) (network.CreateResponse, error)); ok {
		return returnFunc(ctx, networkName, options)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, network.CreateOptions) network.CreateResponse); ok {
		r0 = returnFunc(ctx, networkName, options)
	} else {
		r0 = ret.Get(0).(network.CreateResponse)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, string, network.CreateOptions) error); ok {
		r1 = returnFunc(ctx, networkName, options)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_NetworkCreate_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NetworkCreate'
type MockClient_NetworkCreate_Call struct {
	*mock.Call
}

// NetworkCreate is a helper method to define mock.On call
//   - ctx context.Context
//   - networkName string
//   - options network.CreateOptions
func (_e *MockClient_Expecter) NetworkCreate(ctx interface{}, networkName interface{}, options interface{}) *MockClient_NetworkCreate_Call {
	return &MockClient_NetworkCreate_Call{Call: _e.mock.On("NetworkCreate", ctx, networkName, options)}
}

func (_c *MockClient_NetworkCreate_Call) Run(run func(ctx context.Context, networkName string, options network.CreateOptions)) *MockClient_NetworkCreate_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 network.CreateOptions
		if args[2] != nil {
			arg2 = args[2].(network.CreateOptions)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockClient_NetworkCreate_Call) Return(createResponse network.CreateResponse, err error) *MockClient_NetworkCreate_Call {
	_c.Call.Return(createResponse, err)
	return _c
}

func (_c *MockClient_NetworkCreate_Call) RunAndReturn(run func(ctx context.Context, networkName string, options network.CreateOptions) (network.CreateResponse, error)) *MockClient_NetworkCreate_Call {
	_c.Call.Return(run)
	return _c
}

// NetworkDisconnect provides a mock function for the type MockClient
func (_mock *MockClient) NetworkDisconnect(ctx context.Context, networkID string, containerID string, force bool) error {
	ret := _mock.Called(ctx, networkID, containerID, force)

	if len(ret) == 0 {
		panic("no return value specified for NetworkDisconnect")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, string, bool) error); ok {
		r0 = returnFunc(ctx, networkID, containerID, force)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockClient_NetworkDisconnect_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NetworkDisconnect'
type MockClient_NetworkDisconnect_Call struct {
	*mock.Call
}

// NetworkDisconnect is a helper method to define mock.On call
//   - ctx context.Context
//   - networkID string
//   - containerID string
//   - force bool
func (_e *MockClient_Expecter) NetworkDisconnect(ctx interface{}, networkID interface{}, containerID interface{}, force interface{}) *MockClient_NetworkDisconnect_Call {
	return &MockClient_NetworkDisconnect_Call{Call: _e.mock.On("NetworkDisconnect", ctx, networkID, containerID, force)}
}

func (_c *MockClient_NetworkDisconnect_Call) Run(run func(ctx context.Context, networkID string, containerID string, force bool)) *MockClient_NetworkDisconnect_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 string
		if args[2] != nil {
			arg2 = args[2].(string)
		}
		var arg3 bool
		if args[3] != nil {
			arg3 = args[3].(bool)
		}
		run(
			arg0,
			arg1,
			arg2,
			arg3,
		)
	})
	return _c
}

func (_c *MockClient_NetworkDisconnect_Call) Return(err error) *MockClient_NetworkDisconnect_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockClient_NetworkDisconnect_Call) RunAndReturn(run func(ctx context.Context, networkID string, containerID string, force bool) error) *MockClient_NetworkDisconnect_Call {
	_c.Call.Return(run)
	return _c
}

// NetworkInspect provides a mock function for the type MockClient
func (_mock *MockClient) NetworkInspect(ctx context.Context, networkID string) (network.Inspect, error) {
	ret := _mock.Called(ctx, networkID)

	if len(ret) == 0 {
		panic("no return value specified for NetworkInspect")
	}

	var r0 network.Inspect
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string) (network.Inspect, error)); ok {
		return returnFunc(ctx, networkID)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, string) network.Inspect); ok {
		r0 = returnFunc(ctx, networkID)
	} else {
		r0 = ret.Get(0).(network.Inspect)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = returnFunc(ctx, networkID)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_NetworkInspect_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NetworkInspect'
type MockClient_NetworkInspect_Call struct {
	*mock.Call
}

// NetworkInspect is a helper method to define mock.On call
//   - ctx context.Context
//   - networkID string
func (_e *MockClient_Expecter) NetworkInspect(ctx interface{}, networkID interface{}) *MockClient_NetworkInspect_Call {
	return &MockClient_NetworkInspect_Call{Call: _e.mock.On("NetworkInspect", ctx, networkID)}
}

func (_c *MockClient_NetworkInspect_Call) Run(run func(ctx context.Context, networkID string)) *MockClient_NetworkInspect_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockClient_NetworkInspect_Call) Return(inspect network.Inspect, err error) *MockClient_NetworkInspect_Call {
	_c.Call.Return(inspect, err)
	return _c
}

func (_c *MockClient_NetworkInspect_Call) RunAndReturn(run func(ctx context.Context, networkID string) (network.Inspect, error)) *MockClient_NetworkInspect_Call {
	_c.Call.Return(run)
	return _c
}

// NetworkList provides a mock function for the type MockClient
func (_mock *MockClient) NetworkList(ctx context.Context, options network.ListOptions) ([]network.Summary, error) {
	ret := _mock.Called(ctx, options)

	if len(ret) == 0 {
		panic("no return value specified for NetworkList")
	}

	var r0 []network.Summary
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, network.ListOptions) ([]network.Summary, error)); ok {
		return returnFunc(ctx, options)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, network.ListOptions) []network.Summary); ok {
		r0 = returnFunc(ctx, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]network.Summary)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, network.ListOptions) error); ok {
		r1 = returnFunc(ctx, options)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_NetworkList_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NetworkList'
type MockClient_NetworkList_Call struct {
	*mock.Call
}

// NetworkList is a helper method to define mock.On call
//   - ctx context.Context
//   - options network.ListOptions
func (_e *MockClient_Expecter) NetworkList(ctx interface{}, options interface{}) *MockClient_NetworkList_Call {
	return &MockClient_NetworkList_Call{Call: _e.mock.On("NetworkList", ctx, options)}
}

func (_c *MockClient_NetworkList_Call) Run(run func(ctx context.Context, options network.ListOptions)) *MockClient_NetworkList_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 network.ListOptions
		if args[1] != nil {
			arg1 = args[1].(network.ListOptions)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockClient_NetworkList_Call) Return(vs []network.Summary, err error) *MockClient_NetworkList_Call {
	_c.Call.Return(vs, err)
	return _c
}

func (_c *MockClient_NetworkList_Call) RunAndReturn(run func(ctx context.Context, options network.ListOptions) ([]network.Summary, error)) *MockClient_NetworkList_Call {
	_c.Call.Return(run)
	return _c
}

// NetworkRemove provides a mock function for the type MockClient
func (_mock *MockClient) NetworkRemove(ctx context.Context, networkID string) error {
	ret := _mock.Called(ctx, networkID)

	if len(ret) == 0 {
		panic("no return value specified for NetworkRemove")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = returnFunc(ctx, networkID)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockClient_NetworkRemove_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NetworkRemove'
type MockClient_NetworkRemove_Call struct {
	*mock.Call
}

// NetworkRemove is a helper method to define mock.On call
//   - ctx context.Context
//   - networkID string
func (_e *MockClient_Expecter) NetworkRemove(ctx interface{}, networkID interface{}) *MockClient_NetworkRemove_Call {
	return &MockClient_NetworkRemove_Call{Call: _e.mock.On("NetworkRemove", ctx, networkID)}
}

func (_c *MockClient_NetworkRemove_Call) Run(run func(ctx context.Context, networkID string)) *MockClient_NetworkRemove_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockClient_NetworkRemove_Call) Return(err error) *MockClient_NetworkRemove_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockClient_NetworkRemove_Call) RunAndReturn(run func(ctx context.Context, networkID string) error) *MockClient_NetworkRemove_Call {
	_c.Call.Return(run)
	return _c
}

// ServerVersion provides a mock function for the type MockClient
func (_mock *MockClient) ServerVersion(context1 context.Context) (types.Version, error) {
	ret := _mock.Called(context1)

	if len(ret) == 0 {
		panic("no return value specified for ServerVersion")
	}

	var r0 types.Version
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context) (types.Version, error)); ok {
		return returnFunc(context1)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context) types.Version); ok {
		r0 = returnFunc(context1)
	} else {
		r0 = ret.Get(0).(types.Version)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = returnFunc(context1)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_ServerVersion_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ServerVersion'
type MockClient_ServerVersion_Call struct {
	*mock.Call
}

// ServerVersion is a helper method to define mock.On call
//   - context1 context.Context
func (_e *MockClient_Expecter) ServerVersion(context1 interface{}) *MockClient_ServerVersion_Call {
	return &MockClient_ServerVersion_Call{Call: _e.mock.On("ServerVersion", context1)}
}

func (_c *MockClient_ServerVersion_Call) Run(run func(context1 context.Context)) *MockClient_ServerVersion_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockClient_ServerVersion_Call) Return(version types.Version, err error) *MockClient_ServerVersion_Call {
	_c.Call.Return(version, err)
	return _c
}

func (_c *MockClient_ServerVersion_Call) RunAndReturn(run func(context1 context.Context) (types.Version, error)) *MockClient_ServerVersion_Call {
	_c.Call.Return(run)
	return _c
}

// VolumeCreate provides a mock function for the type MockClient
func (_mock *MockClient) VolumeCreate(ctx context.Context, options volume.CreateOptions) (volume.Volume, error) {
	ret := _mock.Called(ctx, options)

	if len(ret) == 0 {
		panic("no return value specified for VolumeCreate")
	}

	var r0 volume.Volume
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, volume.CreateOptions) (volume.Volume, error)); ok {
		return returnFunc(ctx, options)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, volume.CreateOptions) volume.Volume); ok {
		r0 = returnFunc(ctx, options)
	} else {
		r0 = ret.Get(0).(volume.Volume)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, volume.CreateOptions) error); ok {
		r1 = returnFunc(ctx, options)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_VolumeCreate_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'VolumeCreate'
type MockClient_VolumeCreate_Call struct {
	*mock.Call
}

// VolumeCreate is a helper method to define mock.On call
//   - ctx context.Context
//   - options volume.CreateOptions
func (_e *MockClient_Expecter) VolumeCreate(ctx interface{}, options interface{}) *MockClient_VolumeCreate_Call {
	return &MockClient_VolumeCreate_Call{Call: _e.mock.On("VolumeCreate", ctx, options)}
}

func (_c *MockClient_VolumeCreate_Call) Run(run func(ctx context.Context, options volume.CreateOptions)) *MockClient_VolumeCreate_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 volume.CreateOptions
		if args[1] != nil {
			arg1 = args[1].(volume.CreateOptions)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockClient_VolumeCreate_Call) Return(volume1 volume.Volume, err error) *MockClient_VolumeCreate_Call {
	_c.Call.Return(volume1, err)
	return _c
}

func (_c *MockClient_VolumeCreate_Call) RunAndReturn(run func(ctx context.Context, options volume.CreateOptions) (volume.Volume, error)) *MockClient_VolumeCreate_Call {
	_c.Call.Return(run)
	return _c
}

// VolumeInspect provides a mock function for the type MockClient
func (_mock *MockClient) VolumeInspect(ctx context.Context, volumeID string) (volume.Volume, error) {
	ret := _mock.Called(ctx, volumeID)

	if len(ret) == 0 {
		panic("no return value specified for VolumeInspect")
	}

	var r0 volume.Volume
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string) (volume.Volume, error)); ok {
		return returnFunc(ctx, volumeID)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, string) volume.Volume); ok {
		r0 = returnFunc(ctx, volumeID)
	} else {
		r0 = ret.Get(0).(volume.Volume)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = returnFunc(ctx, volumeID)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClient_VolumeInspect_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'VolumeInspect'
type MockClient_VolumeInspect_Call struct {
	*mock.Call
}

// VolumeInspect is a helper method to define mock.On call
//   - ctx context.Context
//   - volumeID string
func (_e *MockClient_Expecter) VolumeInspect(ctx interface{}, volumeID interface{}) *MockClient_VolumeInspect_Call {
	return &MockClient_VolumeInspect_Call{Call: _e.mock.On("VolumeInspect", ctx, volumeID)}
}

func (_c *MockClient_VolumeInspect_Call) Run(run func(ctx context.Context, volumeID string)) *MockClient_VolumeInspect_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockClient_VolumeInspect_Call) Return(volume1 volume.Volume, err error) *MockClient_VolumeInspect_Call {
	_c.Call.Return(volume1, err)
	return _c
}

func (_c *MockClient_VolumeInspect_Call) RunAndReturn(run func(ctx context.Context, volumeID string) (volume.Volume, error)) *MockClient_VolumeInspect_Call {
	_c.Call.Return(run)
	return _c
}

// VolumeRemove provides a mock function for the type MockClient
func (_mock *MockClient) VolumeRemove(ctx context.Context, volumeID string, force bool) error {
	ret := _mock.Called(ctx, volumeID, force)

	if len(ret) == 0 {
		panic("no return value specified for VolumeRemove")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, bool) error); ok {
		r0 = returnFunc(ctx, volumeID, force)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockClient_VolumeRemove_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'VolumeRemove'
type MockClient_VolumeRemove_Call struct {
	*mock.Call
}

// VolumeRemove is a helper method to define mock.On call
//   - ctx context.Context
//   - volumeID string
//   - force bool
func (_e *MockClient_Expecter) VolumeRemove(ctx interface{}, volumeID interface{}, force interface{}) *MockClient_VolumeRemove_Call {
	return &MockClient_VolumeRemove_Call{Call: _e.mock.On("VolumeRemove", ctx, volumeID, force)}
}

func (_c *MockClient_VolumeRemove_Call) Run(run func(ctx context.Context, volumeID string, force bool)) *MockClient_VolumeRemove_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 bool
		if args[2] != nil {
			arg2 = args[2].(bool)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockClient_VolumeRemove_Call) Return(err error) *MockClient_VolumeRemove_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockClient_VolumeRemove_Call) RunAndReturn(run func(ctx context.Context, volumeID string, force bool) error) *MockClient_VolumeRemove_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockMachine creates a new instance of MockMachine. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockMachine(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockMachine {
	mock := &MockMachine{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockMachine is an autogenerated mock type for the Machine type
type MockMachine struct {
	mock.Mock
}

type MockMachine_Expecter struct {
	mock *mock.Mock
}

func (_m *MockMachine) EXPECT() *MockMachine_Expecter {
	return &MockMachine_Expecter{mock: &_m.Mock}
}

// CanConnect provides a mock function for the type MockMachine
func (_mock *MockMachine) CanConnect(name string, skipCache bool) bool {
	ret := _mock.Called(name, skipCache)

	if len(ret) == 0 {
		panic("no return value specified for CanConnect")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func(string, bool) bool); ok {
		r0 = returnFunc(name, skipCache)
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockMachine_CanConnect_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'CanConnect'
type MockMachine_CanConnect_Call struct {
	*mock.Call
}

// CanConnect is a helper method to define mock.On call
//   - name string
//   - skipCache bool
func (_e *MockMachine_Expecter) CanConnect(name interface{}, skipCache interface{}) *MockMachine_CanConnect_Call {
	return &MockMachine_CanConnect_Call{Call: _e.mock.On("CanConnect", name, skipCache)}
}

func (_c *MockMachine_CanConnect_Call) Run(run func(name string, skipCache bool)) *MockMachine_CanConnect_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		var arg1 bool
		if args[1] != nil {
			arg1 = args[1].(bool)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockMachine_CanConnect_Call) Return(b bool) *MockMachine_CanConnect_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockMachine_CanConnect_Call) RunAndReturn(run func(name string, skipCache bool) bool) *MockMachine_CanConnect_Call {
	_c.Call.Return(run)
	return _c
}

// Create provides a mock function for the type MockMachine
func (_mock *MockMachine) Create(driver string, name string, opts ...string) error {
	// string
	_va := make([]interface{}, len(opts))
	for _i := range opts {
		_va[_i] = opts[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, driver, name)
	_ca = append(_ca, _va...)
	ret := _mock.Called(_ca...)

	if len(ret) == 0 {
		panic("no return value specified for Create")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(string, string, ...string) error); ok {
		r0 = returnFunc(driver, name, opts...)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockMachine_Create_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Create'
type MockMachine_Create_Call struct {
	*mock.Call
}

// Create is a helper method to define mock.On call
//   - driver string
//   - name string
//   - opts ...string
func (_e *MockMachine_Expecter) Create(driver interface{}, name interface{}, opts ...interface{}) *MockMachine_Create_Call {
	return &MockMachine_Create_Call{Call: _e.mock.On("Create",
		append([]interface{}{driver, name}, opts...)...)}
}

func (_c *MockMachine_Create_Call) Run(run func(driver string, name string, opts ...string)) *MockMachine_Create_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 []string
		variadicArgs := make([]string, len(args)-2)
		for i, a := range args[2:] {
			if a != nil {
				variadicArgs[i] = a.(string)
			}
		}
		arg2 = variadicArgs
		run(
			arg0,
			arg1,
			arg2...,
		)
	})
	return _c
}

func (_c *MockMachine_Create_Call) Return(err error) *MockMachine_Create_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockMachine_Create_Call) RunAndReturn(run func(driver string, name string, opts ...string) error) *MockMachine_Create_Call {
	_c.Call.Return(run)
	return _c
}

// Credentials provides a mock function for the type MockMachine
func (_mock *MockMachine) Credentials(name string) (Credentials, error) {
	ret := _mock.Called(name)

	if len(ret) == 0 {
		panic("no return value specified for Credentials")
	}

	var r0 Credentials
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(string) (Credentials, error)); ok {
		return returnFunc(name)
	}
	if returnFunc, ok := ret.Get(0).(func(string) Credentials); ok {
		r0 = returnFunc(name)
	} else {
		r0 = ret.Get(0).(Credentials)
	}
	if returnFunc, ok := ret.Get(1).(func(string) error); ok {
		r1 = returnFunc(name)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockMachine_Credentials_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Credentials'
type MockMachine_Credentials_Call struct {
	*mock.Call
}

// Credentials is a helper method to define mock.On call
//   - name string
func (_e *MockMachine_Expecter) Credentials(name interface{}) *MockMachine_Credentials_Call {
	return &MockMachine_Credentials_Call{Call: _e.mock.On("Credentials", name)}
}

func (_c *MockMachine_Credentials_Call) Run(run func(name string)) *MockMachine_Credentials_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockMachine_Credentials_Call) Return(credentials Credentials, err error) *MockMachine_Credentials_Call {
	_c.Call.Return(credentials, err)
	return _c
}

func (_c *MockMachine_Credentials_Call) RunAndReturn(run func(name string) (Credentials, error)) *MockMachine_Credentials_Call {
	_c.Call.Return(run)
	return _c
}

// Exist provides a mock function for the type MockMachine
func (_mock *MockMachine) Exist(name string) bool {
	ret := _mock.Called(name)

	if len(ret) == 0 {
		panic("no return value specified for Exist")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func(string) bool); ok {
		r0 = returnFunc(name)
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockMachine_Exist_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Exist'
type MockMachine_Exist_Call struct {
	*mock.Call
}

// Exist is a helper method to define mock.On call
//   - name string
func (_e *MockMachine_Expecter) Exist(name interface{}) *MockMachine_Exist_Call {
	return &MockMachine_Exist_Call{Call: _e.mock.On("Exist", name)}
}

func (_c *MockMachine_Exist_Call) Run(run func(name string)) *MockMachine_Exist_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockMachine_Exist_Call) Return(b bool) *MockMachine_Exist_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockMachine_Exist_Call) RunAndReturn(run func(name string) bool) *MockMachine_Exist_Call {
	_c.Call.Return(run)
	return _c
}

// List provides a mock function for the type MockMachine
func (_mock *MockMachine) List() ([]string, error) {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for List")
	}

	var r0 []string
	var r1 error
	if returnFunc, ok := ret.Get(0).(func() ([]string, error)); ok {
		return returnFunc()
	}
	if returnFunc, ok := ret.Get(0).(func() []string); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}
	if returnFunc, ok := ret.Get(1).(func() error); ok {
		r1 = returnFunc()
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockMachine_List_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'List'
type MockMachine_List_Call struct {
	*mock.Call
}

// List is a helper method to define mock.On call
func (_e *MockMachine_Expecter) List() *MockMachine_List_Call {
	return &MockMachine_List_Call{Call: _e.mock.On("List")}
}

func (_c *MockMachine_List_Call) Run(run func()) *MockMachine_List_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockMachine_List_Call) Return(machines []string, err error) *MockMachine_List_Call {
	_c.Call.Return(machines, err)
	return _c
}

func (_c *MockMachine_List_Call) RunAndReturn(run func() ([]string, error)) *MockMachine_List_Call {
	_c.Call.Return(run)
	return _c
}

// Provision provides a mock function for the type MockMachine
func (_mock *MockMachine) Provision(name string) error {
	ret := _mock.Called(name)

	if len(ret) == 0 {
		panic("no return value specified for Provision")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(string) error); ok {
		r0 = returnFunc(name)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockMachine_Provision_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Provision'
type MockMachine_Provision_Call struct {
	*mock.Call
}

// Provision is a helper method to define mock.On call
//   - name string
func (_e *MockMachine_Expecter) Provision(name interface{}) *MockMachine_Provision_Call {
	return &MockMachine_Provision_Call{Call: _e.mock.On("Provision", name)}
}

func (_c *MockMachine_Provision_Call) Run(run func(name string)) *MockMachine_Provision_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockMachine_Provision_Call) Return(err error) *MockMachine_Provision_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockMachine_Provision_Call) RunAndReturn(run func(name string) error) *MockMachine_Provision_Call {
	_c.Call.Return(run)
	return _c
}

// Remove provides a mock function for the type MockMachine
func (_mock *MockMachine) Remove(name string) error {
	ret := _mock.Called(name)

	if len(ret) == 0 {
		panic("no return value specified for Remove")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(string) error); ok {
		r0 = returnFunc(name)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockMachine_Remove_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Remove'
type MockMachine_Remove_Call struct {
	*mock.Call
}

// Remove is a helper method to define mock.On call
//   - name string
func (_e *MockMachine_Expecter) Remove(name interface{}) *MockMachine_Remove_Call {
	return &MockMachine_Remove_Call{Call: _e.mock.On("Remove", name)}
}

func (_c *MockMachine_Remove_Call) Run(run func(name string)) *MockMachine_Remove_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockMachine_Remove_Call) Return(err error) *MockMachine_Remove_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockMachine_Remove_Call) RunAndReturn(run func(name string) error) *MockMachine_Remove_Call {
	_c.Call.Return(run)
	return _c
}

// Stop provides a mock function for the type MockMachine
func (_mock *MockMachine) Stop(name string, timeout time.Duration) error {
	ret := _mock.Called(name, timeout)

	if len(ret) == 0 {
		panic("no return value specified for Stop")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(string, time.Duration) error); ok {
		r0 = returnFunc(name, timeout)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockMachine_Stop_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Stop'
type MockMachine_Stop_Call struct {
	*mock.Call
}

// Stop is a helper method to define mock.On call
//   - name string
//   - timeout time.Duration
func (_e *MockMachine_Expecter) Stop(name interface{}, timeout interface{}) *MockMachine_Stop_Call {
	return &MockMachine_Stop_Call{Call: _e.mock.On("Stop", name, timeout)}
}

func (_c *MockMachine_Stop_Call) Run(run func(name string, timeout time.Duration)) *MockMachine_Stop_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		var arg1 time.Duration
		if args[1] != nil {
			arg1 = args[1].(time.Duration)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockMachine_Stop_Call) Return(err error) *MockMachine_Stop_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockMachine_Stop_Call) RunAndReturn(run func(name string, timeout time.Duration) error) *MockMachine_Stop_Call {
	_c.Call.Return(run)
	return _c
}
