/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.bytes.ByteSpliterator;
import it.unimi.dsi.fastutil.chars.CharSpliterator;
import it.unimi.dsi.fastutil.doubles.DoubleSpliterator;
import it.unimi.dsi.fastutil.doubles.DoubleSpliterators;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatPredicate;
import it.unimi.dsi.fastutil.floats.FloatSpliterator;
import it.unimi.dsi.fastutil.floats.FloatSpliterators;
import it.unimi.dsi.fastutil.shorts.ShortSpliterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;

public final class FloatSpliterators {
    static final int BASE_SPLITERATOR_CHARACTERISTICS = 256;
    public static final int COLLECTION_SPLITERATOR_CHARACTERISTICS = 320;
    public static final int LIST_SPLITERATOR_CHARACTERISTICS = 16720;
    public static final int SET_SPLITERATOR_CHARACTERISTICS = 321;
    private static final int SORTED_CHARACTERISTICS = 20;
    public static final int SORTED_SET_SPLITERATOR_CHARACTERISTICS = 341;
    public static final EmptySpliterator EMPTY_SPLITERATOR = new EmptySpliterator();

    private FloatSpliterators() {
    }

    public static FloatSpliterator singleton(float element) {
        return new SingletonSpliterator(element);
    }

    public static FloatSpliterator singleton(float element, FloatComparator comparator) {
        return new SingletonSpliterator(element, comparator);
    }

    public static FloatSpliterator wrap(float[] array, int offset, int length) {
        FloatArrays.ensureOffsetLength(array, offset, length);
        return new ArraySpliterator(array, offset, length, 0);
    }

    public static FloatSpliterator wrap(float[] array) {
        return new ArraySpliterator(array, 0, array.length, 0);
    }

    public static FloatSpliterator wrap(float[] array, int offset, int length, int additionalCharacteristics) {
        FloatArrays.ensureOffsetLength(array, offset, length);
        return new ArraySpliterator(array, offset, length, additionalCharacteristics);
    }

    public static FloatSpliterator wrapPreSorted(float[] array, int offset, int length, int additionalCharacteristics, FloatComparator comparator) {
        FloatArrays.ensureOffsetLength(array, offset, length);
        return new ArraySpliteratorWithComparator(array, offset, length, additionalCharacteristics, comparator);
    }

    public static FloatSpliterator wrapPreSorted(float[] array, int offset, int length, FloatComparator comparator) {
        return FloatSpliterators.wrapPreSorted(array, offset, length, 0, comparator);
    }

    public static FloatSpliterator wrapPreSorted(float[] array, FloatComparator comparator) {
        return FloatSpliterators.wrapPreSorted(array, 0, array.length, comparator);
    }

    public static FloatSpliterator asFloatSpliterator(Spliterator i) {
        if (i instanceof FloatSpliterator) {
            return (FloatSpliterator)i;
        }
        return new SpliteratorWrapper(i);
    }

    public static FloatSpliterator asFloatSpliterator(Spliterator i, FloatComparator comparatorOverride) {
        if (i instanceof FloatSpliterator) {
            throw new IllegalArgumentException("Cannot override comparator on instance that is already a " + FloatSpliterator.class.getSimpleName());
        }
        if (i instanceof Spliterator.OfDouble) {
            return new PrimitiveSpliteratorWrapperWithComparator((Spliterator.OfDouble)i, comparatorOverride);
        }
        return new SpliteratorWrapperWithComparator(i, comparatorOverride);
    }

    public static FloatSpliterator narrow(Spliterator.OfDouble i) {
        return new PrimitiveSpliteratorWrapper(i);
    }

    public static DoubleSpliterator widen(FloatSpliterator i) {
        return DoubleSpliterators.wrap(i);
    }

    public static void onEachMatching(FloatSpliterator spliterator, FloatPredicate predicate, FloatConsumer action) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(action);
        spliterator.forEachRemaining(value -> {
            if (predicate.test(value)) {
                action.accept(value);
            }
        });
    }

    public static void onEachMatching(FloatSpliterator spliterator, DoublePredicate predicate, DoubleConsumer action) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(action);
        spliterator.forEachRemaining(value -> {
            if (predicate.test(value)) {
                action.accept(value);
            }
        });
    }

    public static FloatSpliterator concat(FloatSpliterator ... a) {
        return FloatSpliterators.concat(a, 0, a.length);
    }

    public static FloatSpliterator concat(FloatSpliterator[] a, int offset, int length) {
        return new SpliteratorConcatenator(a, offset, length);
    }

    public static FloatSpliterator asSpliterator(FloatIterator iter, long size, int additionalCharacterisitcs) {
        return new SpliteratorFromIterator(iter, size, additionalCharacterisitcs);
    }

    public static FloatSpliterator asSpliteratorFromSorted(FloatIterator iter, long size, int additionalCharacterisitcs, FloatComparator comparator) {
        return new SpliteratorFromIteratorWithComparator(iter, size, additionalCharacterisitcs, comparator);
    }

    public static FloatSpliterator asSpliteratorUnknownSize(FloatIterator iter, int characterisitcs) {
        return new SpliteratorFromIterator(iter, characterisitcs);
    }

    public static FloatSpliterator asSpliteratorFromSortedUnknownSize(FloatIterator iter, int additionalCharacterisitcs, FloatComparator comparator) {
        return new SpliteratorFromIteratorWithComparator(iter, additionalCharacterisitcs, comparator);
    }

    public static FloatIterator asIterator(FloatSpliterator spliterator) {
        return new IteratorFromSpliterator(spliterator);
    }

    public static FloatSpliterator wrap(ByteSpliterator spliterator) {
        return new ByteSpliteratorWrapper(spliterator);
    }

    public static FloatSpliterator wrap(ShortSpliterator spliterator) {
        return new ShortSpliteratorWrapper(spliterator);
    }

    public static FloatSpliterator wrap(CharSpliterator spliterator) {
        return new CharSpliteratorWrapper(spliterator);
    }
}

