---
title: pixi upload
---
<!--- This file is autogenerated. Do not edit manually! -->
# [pixi](../pixi.md) upload

Upload conda packages to various channels

--8<-- "docs/reference/cli/pixi/upload_extender:description"

## Usage
```
pixi upload [OPTIONS] [PACKAGE_FILES]... <COMMAND>
```

## Subcommands
| Command | Description |
|---------|-------------|
| [`quetz`](upload/quetz.md) | Upload to a Quetz server. Authentication is used from the keychain / auth-file |
| [`artifactory`](upload/artifactory.md) | Options for uploading to a Artifactory channel. Authentication is used from the keychain / auth-file |
| [`prefix`](upload/prefix.md) | Options for uploading to a prefix.dev server. Authentication is used from the keychain / auth-file |
| [`anaconda`](upload/anaconda.md) | Options for uploading to a Anaconda.org server |
| [`s3`](upload/s3.md) | Options for uploading to S3 |


## Arguments
- <a id="arg-<PACKAGE_FILES>" href="#arg-<PACKAGE_FILES>">`<PACKAGE_FILES>`</a>
:  The package file to upload
<br>May be provided more than once.

## Options
- <a id="arg---allow-insecure-host" href="#arg---allow-insecure-host">`--allow-insecure-host <ALLOW_INSECURE_HOST>`</a>
:  List of hosts for which SSL certificate verification should be skipped
<br>May be provided more than once.

## Description
Upload conda packages to various channels

Supported server types: prefix, anaconda, quetz, artifactory, s3, conda-forge

Use `pixi auth login` to authenticate with the server.


--8<-- "docs/reference/cli/pixi/upload_extender:example"
