/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import org.asciidoctor.diagram.AbstractCommandServer;
import org.asciidoctor.diagram.DiagramGenerator;

public class SocketCommandServer
extends AbstractCommandServer {
    private final ServerSocket serverSocket;

    public static void main(String[] args) throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        System.out.println(serverSocket.getLocalPort());
        System.out.flush();
        SocketCommandServer server = new SocketCommandServer(serverSocket, SocketCommandServer.getGenerators());
        server.processRequests();
        server.terminate();
    }

    public SocketCommandServer(ServerSocket socket, Map<String, DiagramGenerator> generators) {
        super(generators);
        this.serverSocket = socket;
    }

    public void processRequests() throws IOException {
        while (!this.serverSocket.isClosed()) {
            Socket client = this.serverSocket.accept();
            this.processRequests(client.getInputStream(), client.getOutputStream());
            client.close();
        }
    }

    public void terminate() throws IOException {
        this.serverSocket.close();
    }
}

