---
title: ebpf
sidebar_position: 10
---

The eBPF operator handles the [ebpf layer](../oci.md#the-ebpf-layer)
that contains an ELF file with the eBPF programs. This operator loads the
programs into the kernel and attaches them to the different hooks as specified
by the gadget developer.

## Instance Parameters

### `iface`

Network interface to attach networking programs to. Only available if the gadget
uses networking programs.

Fully qualified name: `operator.oci.ebpf.iface`

### `trace-pipe`

Print debug information generated by eBPF with `bpf_printk()` to the terminal.

Fully qualified name: `operator.oci.ebpf.trace-pipe`

### `map-fetch-interval`

Interval in which to iterate over eBPF maps that have been marked with
`GADGET_MAPITER()`.

Fully qualified name: `operator.oci.ebpf.map-fetch-interval`

Default: `1000ms`

### `map-fetch-count`

Number of fetch cycles (use 0 for unlimited) for eBPF maps that have been marked
with `GADGET_MAPITER()`.

Fully qualified name: `operator.oci.ebpf.map-fetch-count`

Default: `0`
