/*MT*

    MediaTomb - http://www.mediatomb.cc/

    mem_io_handler.h - this file is part of MediaTomb.

    Copyright (C) 2005 Gena Batyan <bgeradz@mediatomb.cc>,
                       Sergey 'Jin' Bostandzhyan <jin@mediatomb.cc>

    Copyright (C) 2006-2010 Gena Batyan <bgeradz@mediatomb.cc>,
                            Sergey 'Jin' Bostandzhyan <jin@mediatomb.cc>,
                            Leonhard Wimmer <leo@mediatomb.cc>

    Copyright (C) 2016-2024 Gerbera Contributors

    MediaTomb is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2
    as published by the Free Software Foundation.

    MediaTomb is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    version 2 along with MediaTomb; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

    $Id$
*/

/// \file mem_io_handler.h
/// \brief definition of the MemIOHandler class.
#ifndef __MEM_IO_HANDLER_H__
#define __MEM_IO_HANDLER_H__

#include "io_handler.h"

#include <string>

/// \brief Allows the web server to read from a memory buffer instead of a file.
class MemIOHandler : public IOHandler {
protected:
    /// \brief buffer that is holding our data.
    char* buffer;
    off_t length;

    /// \brief current offset in the buffer
    off_t pos { -1 };

public:
    /// \brief Initializes the internal buffer.
    /// \param buffer all operations will be done on this buffer.
    /// \param length size of the buffer
    MemIOHandler(const void* buffer, int length);
    explicit MemIOHandler(const std::string& str);
    ~MemIOHandler() override;

    MemIOHandler(const MemIOHandler&) = delete;
    MemIOHandler& operator=(const MemIOHandler&) = delete;

    ///
    void open(enum UpnpOpenFileMode mode) override;
    grb_read_t read(std::byte* buf, std::size_t length) override;
    void seek(off_t offset, int whence) override;
    off_t tell() override;
    void close() override;
};

#endif // __MEM_IO_HANDLER_H__
