## Rust bindings for GrapheneOS allocator

- Released under the same license as the GrapheneOS allocator.
- The major version follows the GrapheneOS allocator version.
- Use it, harden your memories, spread the love!

## Configuration

- Build requires a C17 supporting compiler!
- We follow upstream configuration closely (except `CONFIG_WERROR`).
- Feature `light` enables light mode, otherwise you're in `default` mode.
- Feature `seal` enables `CONFIG_SEAL_METADATA`, noop if target env isn't GNU.
- Feature `small` sets `CONFIG_CLASS_REGION_SIZE` to `4GiB` (default: `32GiB`).
- Feature `tiny` sets `CONFIG_CLASS_REGION_SIZE` to `4MiB`.
- Use the files `config-{default,light}.conf` to fine tune build as needed.

Maintained by Ali Polatel. Up-to-date sources can be found at
https://git.sr.ht/~alip/syd and bugs/patches can be submitted by email to
[~alip/sydbox-devel@lists.sr.ht](mailto:~alip/sydbox-devel@lists.sr.ht).
Exherbo related bugs/issues can be submitted to
<https://gitlab.exherbo.org/groups/sydbox/-/issues>. Discuss in [#sydbox on Libera
Chat](ircs://irc.libera.chat/#sydbox).
