# Generators

This is the full list of generators available, organized by most popular [use cases](#by-use-case) and by their comprehensive [list](#all-generators).

> [!TIP]
> If you run into any issues with a generator not being available, see [A note about the Generators versions](#a-note-about-the-generators-versions).

## By Use Case

### Internet

Generate email addresses, passwords, domains, etc.

- [Faker::App](doc/default/app.md)
- [Faker::Boolean](doc/default/boolean.md)
- [Faker::Color](doc/default/color.md)
- [Faker::Computer](doc/default/computer.md)
- [Faker::Device](doc/default/device.md)
- [Faker::Esport](doc/default/esport.md)
- [Faker::File](doc/default/file.md)
- [Faker::Json](doc/default/json.md)
- [Faker::Hacker](doc/default/hacker.md)
- [Faker::Internet](doc/default/internet.md)
- [Faker::Markdown](doc/default/markdown.md)
- [Faker::ProgrammingLanguage](doc/default/programming_language.md)
- [Faker::Omniauth](doc/default/omniauth.md)
- [Faker::SlackEmoji](doc/default/slack_emoji.md)
- [Faker::Source](doc/default/source.md)
- [Faker::Types](doc/default/types.md)
- [Faker::VulnerabilityIdentifier](doc/default/vulnerability_identifier.md)
- [Faker::X](doc/default/x.md)

### Date and Time

Travel back in time or to future.

- [Faker::Date](doc/default/date.md)
- [Faker::Time](doc/default/time.md)


### Person

Generate names, genders, bios, job titles, and more.

- [Faker::Artist](doc/default/artist.md)
- [Faker::Blood](doc/default/blood.md)
- [Faker::Demographic](doc/default/demographic.md)
- [Faker::DrivingLicence](doc/default/driving_licence.md)
- [Faker::Educator](doc/default/educator.md)
- [Faker::FunnyName](doc/default/funny_name.md)
- [Faker::Gender](doc/default/gender.md)
- [Faker::Hacker](doc/default/hacker.md)
- [Faker::Hobby](doc/default/hobby.md)
- [Faker::Job](doc/default/job.md)
- [Faker::Military](doc/default/military.md)
- [Faker::Name](doc/default/name.md)
- [Faker::NationalHealthService](doc/default/national_health_service.md)
- [Faker::Nation](doc/default/nation.md)
- [Faker::Relationship](doc/default/relationship.md)
- [Faker::University](doc/default/university.md)

### Number and String

Generate random numbers and strings.

- [Faker::Alphanumeric](doc/default/alphanumeric.md)
- [Faker::Barcode](doc/default/barcode.md)
- [Faker::Code](doc/default/code.md)
- [Faker::DrivingLicence](doc/default/driving_licence.md)
- [Faker::Emotion](doc/default/emotion.md)
- [Faker::IdNumber](doc/default/id_number.md)
- [Faker::Lorem](doc/default/lorem.md)
- [Faker::Number](doc/default/number.md)
- [Faker::PhoneNumber](doc/default/phone_number.md)
- [Faker::SouthAfrica](doc/default/south_africa.md)
- [Faker::String](doc/default/string.md)
- [Faker::Verbs](doc/default/verbs.md)

### Location

Generate addresses, zip codes, street names, states, and countries.

- [Faker::Address](doc/default/address.md)
- [Faker::Compass](doc/default/compass.md)
- [Faker::Locations::Australia](doc/locations/australia.md)
- [Faker::Nation](doc/default/nation.md)
- [Faker::University](doc/default/university.md)
- [Faker:Travel::Airport](doc/travel/airport.md)
- [Faker:Travel::TrainStation](doc/travel/train_station.md)

### Finance

Create account details, transactions, and crypto addresses.

- [Faker::Bank](doc/default/bank.md)
- [Faker::Blockchain::Aeternity](doc/blockchain/aeternity.md)
- [Faker::Blockchain::Bitcoin](doc/blockchain/bitcoin.md)
- [Faker::Blockchain::Ethereum](doc/blockchain/ethereum.md)
- [Faker::Blockchain::Tezos](doc/blockchain/tezos.md)
- [Faker::Business](doc/default/business.md)
- [Faker::Coin](doc/default/coin.md)
- [Faker::Company](doc/default/company.md)
- [Faker::Commerce](doc/default/commerce.md)
- [Faker::CryptoCoin](doc/default/crypto_coin.md)
- [Faker::Currency](doc/default/currency.md)
- [Faker::Finance](doc/default/finance.md)
- [Faker::IdNumber](doc/default/id_number.md)
- [Faker::Invoice](doc/default/invoice.md)
- [Faker::Stripe](doc/default/stripe.md)

### Image

Generate avatars with lots of customization.

- [Faker::Avatar](doc/default/avatar.md)
- [Faker::Camera](doc/default/camera.md)
- [Faker::LoremFlickr](doc/default/lorem_flickr.md)
- [Faker::Placeholdit](doc/default/placeholdit.md)

### Food

Generate coffee, beer, tea and other entries.

- [Faker::Beer](doc/default/beer.md)
- [Faker::Cannabis](doc/default/cannabis.md)
- [Faker::Coffee](doc/default/coffee.md)
- [Faker::Dessert](doc/default/dessert.md)
- [Faker::Food](doc/default/food.md)
- [Faker::Restaurant](doc/default/restaurant.md)
- [Faker::Tea](doc/default/tea.md)

### Animal

Generate breeds, names, sizes, etc.

- [Faker::Creature::Animal](doc/creature/animal.md)
- [Faker::Creature::Bird](doc/creature/bird.md)
- [Faker::Creature::Cat](doc/creature/cat.md)
- [Faker::Creature::Dog](doc/creature/dog.md)
- [Faker::Creature::Horse](doc/creature/horse.md)

### Arts and Media

Generate entries for artistic needs, from TV Shows to Japanese media.

- [Faker::DcComics](doc/default/dc_comics.md)
- [Faker::Superhero](doc/default/superhero.md)
- [Faker::Theater](doc/default/theater.md)

#### Movies

Generate movies titles, quotes, characters, etc.

- [Faker::ChuckNorris](doc/default/chuck_norris.md)
- [Faker::Movie](doc/movies/movie.md)
- [Faker::Movies::Avatar](doc/movies/avatar.md)
- [Faker::Movies::BackToTheFuture](doc/movies/back_to_the_future.md)
- [Faker::Movies::Departed](doc/movies/departed.md)
- [Faker::Movies::Ghostbusters](doc/movies/ghostbusters.md)
- [Faker::Movies::HarryPotter](doc/movies/harry_potter.md)
- [Faker::Movies::HitchhikersGuideToTheGalaxy](doc/movies/hitchhikers_guide_to_the_galaxy.md)
- [Faker::Movies::Hobbit](doc/movies/hobbit.md)
- [Faker::Movies::HowToTrainYourDragon](doc/movies/how_to_train_your_dragon.md)
- [Faker::Movies::Lebowski](doc/movies/lebowski.md)
- [Faker::Movies::LordOfTheRings](doc/movies/lord_of_the_rings.md)
- [Faker::Movies::PrincessBride](doc/movies/princess_bride.md)
- [Faker::Movies::StarWars](doc/movies/star_wars.md)
- [Faker::Movies::TRON](doc/movies/tron.md)
- [Faker::Movies::VForVendetta](doc/movies/v_for_vendetta.md)

#### Music

Generate genres, artists, song names, etc.

- [Faker::Kpop](doc/default/kpop.md)
- [Faker::Music](doc/music/music.md)
- [Faker::Music::BossaNova](doc/music/bossa_nova.md)
- [Faker::Music::GratefulDead](doc/music/grateful_dead.md)
- [Faker::Music::Hiphop](doc/music/hiphop.md)
- [Faker::Music::Opera](doc/music/opera.md)
- [Faker::Music::PearlJam](doc/music/pearl_jam.md)
- [Faker::Music::Phish](doc/music/phish.md)
- [Faker::Music::Prince](doc/music/prince.md)
- [Faker::Music::RockBand](doc/music/rock_band.md)
- [Faker::Music::Rush](doc/music/rush.md)
- [Faker::Music::SmashingPumpkins](doc/music/smashing_pumpkins.md)
- [Faker::Music::UmphreysMcgee](doc/music/umphreys_mcgee.md)

#### Books

Generate genres, titles, authors, etc.

- [Faker::Book](doc/books/book.md)
- [Faker::Books::CultureSeries](doc/books/culture_series.md)
- [Faker::Books::Dune](doc/books/dune.md)
- [Faker::Books::Lovecraft](doc/books/lovecraft.md)
- [Faker::Books::TheKingkillerChronicle](doc/books/the_kingkiller_chronicle.md)
- [Faker::Fantasy::Tolkien](doc/fantasy/tolkien.md)

#### TV Shows

Generate titles, characters, quotes and more from a variety of TV shows.

- [Faker::TvShows::AquaTeenHungerForce](doc/tv_shows/aqua_teen_hunger_force.md)
- [Faker::TvShows::Archer](doc/tv_shows/archer.md)
- [Faker::TvShows::BigBangTheory](doc/tv_shows/big_bang_theory.md)
- [Faker::TvShows::BojackHorseman](doc/tv_shows/bojack_horseman.md)
- [Faker::TvShows::BreakingBad](doc/tv_shows/breaking_bad.md)
- [Faker::TvShows::BrooklynNineNine](doc/tv_shows/brooklyn_nine_nine.md)
- [Faker::TvShows::Buffy](doc/tv_shows/buffy.md)
- [Faker::TvShows::Community](doc/tv_shows/community.md)
- [Faker::TvShows::DrWho](doc/tv_shows/dr_who.md)
- [Faker::TvShows::DumbAndDumber](doc/tv_shows/dumb_and_dumber.md)
- [Faker::TvShows::FamilyGuy](doc/tv_shows/family_guy.md)
- [Faker::TvShows::FinalSpace](doc/tv_shows/final_space.md)
- [Faker::TvShows::Friends](doc/tv_shows/friends.md)
- [Faker::TvShows::GameOfThrones](doc/tv_shows/game_of_thrones.md)
- [Faker::TvShows::HeyArnold](doc/tv_shows/hey_arnold.md)
- [Faker::TvShows::HowIMetYourMother](doc/tv_shows/how_i_met_your_mother.md)
- [Faker::TvShows::MichaelScott](doc/tv_shows/michael_scott.md)
- [Faker::TvShows::NewGirl](doc/tv_shows/new_girl.md)
- [Faker::TvShows::ParksAndRec](doc/tv_shows/parks_and_rec.md)
- [Faker::TvShows::RickAndMorty](doc/tv_shows/rick_and_morty.md)
- [Faker::TvShows::RuPaul](doc/tv_shows/rupaul.md)
- [Faker::TvShows::Seinfeld](doc/tv_shows/seinfeld.md)
- [Faker::TvShows::SiliconValley](doc/tv_shows/silicon_valley.md)
- [Faker::TvShows::Simpsons](doc/tv_shows/simpsons.md)
- [Faker::TvShows::SouthPark](doc/tv_shows/south_park.md)
- [Faker::TvShows::Spongebob](doc/tv_shows/spongebob.md)
- [Faker::TvShows::StarTrek](doc/tv_shows/star_trek.md)
- [Faker::TvShows::Stargate](doc/tv_shows/stargate.md)
- [Faker::TvShows::StrangerThings](doc/tv_shows/stranger_things.md)
- [Faker::TvShows::Suits](doc/tv_shows/suits.md)
- [Faker::TvShows::Supernatural](doc/tv_shows/supernatural.md)
- [Faker::TvShows::TheExpanse](doc/tv_shows/the_expanse.md)
- [Faker::TvShows::TheFreshPrinceOfBelAir](doc/tv_shows/the_fresh_prince_of_bel_air.md)
- [Faker::TvShows::TheITCrowd](doc/tv_shows/the_it_crowd.md)
- [Faker::TvShows::TheThickOfIt](doc/tv_shows/the_thick_of_it.md)
- [Faker::TvShows::TwinPeaks](doc/tv_shows/twin_peaks.md)
- [Faker::TvShows::VentureBros](doc/tv_shows/venture_bros.md)

## All generators

Want to see a comprehensive list of all generators? Expand the sections below to find **all** the available generators, categorized by their namespaces.

<details>
  <summary>Default</summary>

  - [Faker::Address](doc/default/address.md)
  - [Faker::Alphanumeric](doc/default/alphanumeric.md)
  - [Faker::Ancient](doc/default/ancient.md)
  - [Faker::App](doc/default/app.md)
  - [Faker::Appliance](doc/default/appliance.md)
  - [Faker::Artist](doc/default/artist.md)
  - [Faker::Avatar](doc/default/avatar.md)
  - [Faker::Bank](doc/default/bank.md)
  - [Faker::Barcode](doc/default/barcode.md)
  - [Faker::Beer](doc/default/beer.md)
  - [Faker::Blood](doc/default/blood.md)
  - [Faker::Boolean](doc/default/boolean.md)
  - [Faker::Business](doc/default/business.md)
  - [Faker::Camera](doc/default/camera.md)
  - [Faker::Cannabis](doc/default/cannabis.md)
  - [Faker::ChileRut](doc/default/chile_rut.md)
  - [Faker::ChuckNorris](doc/default/chuck_norris.md)
  - [Faker::Code](doc/default/code.md)
  - [Faker::Coffee](doc/default/coffee.md)
  - [Faker::Coin](doc/default/coin.md)
  - [Faker::Color](doc/default/color.md)
  - [Faker::Commerce](doc/default/commerce.md)
  - [Faker::Company](doc/default/company.md)
  - [Faker::Compass](doc/default/compass.md)
  - [Faker::Computer](doc/default/computer.md)
  - [Faker::Construction](doc/default/construction.md)
  - [Faker::Cosmere](doc/default/cosmere.md)
  - [Faker::Crypto](doc/default/crypto.md)
  - [Faker::CryptoCoin](doc/default/crypto_coin.md)
  - [Faker::Currency](doc/default/currency.md)
  - [Faker::Date](doc/default/date.md)
  - [Faker::DcComics](doc/default/dc_comics.md)
  - [Faker::Demographic](doc/default/demographic.md)
  - [Faker::Dessert](doc/default/dessert.md)
  - [Faker::Device](doc/default/device.md)
  - [Faker::DrivingLicence](doc/default/driving_licence.md)
  - [Faker::Drone](doc/drone/drone.md)
  - [Faker::Educator](doc/default/educator.md)
  - [Faker::ElectricalComponents](doc/default/electrical_components.md)
  - [Faker::Emotion](doc/default/emotion.md)
  - [Faker::Esport](doc/default/esport.md)
  - [Faker::File](doc/default/file.md)
  - [Faker::Finance](doc/default/finance.md)
  - [Faker::Food](doc/default/food.md)
  - [Faker::FunnyName](doc/default/funny_name.md)
  - [Faker::Gender](doc/default/gender.md)
  - [Faker::GreekPhilosophers](doc/default/greek_philosophers.md)
  - [Faker::Hacker](doc/default/hacker.md)
  - [Faker::Hipster](doc/default/hipster.md)
  - [Faker::Hobby](doc/default/hobby.md)
  - [Faker::House](doc/default/house.md)
  - [Faker::IdNumber](doc/default/id_number.md)
  - [Faker::IndustrySegments](doc/default/industry_segments.md)
  - [Faker::Internet](doc/default/internet.md)
  - [Faker::Invoice](doc/default/invoice.md)
  - [Faker::Job](doc/default/job.md)
  - [Faker::Json](doc/default/json.md)
  - [Faker::Kpop](doc/default/kpop.md)
  - [Faker::Lorem](doc/default/lorem.md)
  - [Faker::LoremFlickr](doc/default/lorem_flickr.md)
  - [Faker::Markdown](doc/default/markdown.md)
  - [Faker::Marketing](doc/default/marketing.md)
  - [Faker::Measurement](doc/default/measurement.md)
  - [Faker::Military](doc/default/military.md)
  - [Faker::Mountain](doc/default/mountain.md)
  - [Faker::Name](doc/default/name.md)
  - [Faker::Nation](doc/default/nation.md)
  - [Faker::NatoPhoneticAlphabet](doc/default/nato_phonetic_alphabet.md)
  - [Faker::NationalHealthService](doc/default/national_health_service.md)
  - [Faker::Number](doc/default/number.md)
  - [Faker::Omniauth](doc/default/omniauth.md)
  - [Faker::PhoneNumber](doc/default/phone_number.md)
  - [Faker::Placeholdit](doc/default/placeholdit.md)
  - [Faker::ProgrammingLanguage](doc/default/programming_language.md)
  - [Faker::Relationship](doc/default/relationship.md)
  - [Faker::Restaurant](doc/default/restaurant.md)
  - [Faker::Science](doc/default/science.md)
  - [Faker::SlackEmoji](doc/default/slack_emoji.md)
  - [Faker::Source](doc/default/source.md)
  - [Faker::SouthAfrica](doc/default/south_africa.md)
  - [Faker::Space](doc/default/space.md)
  - [Faker::String](doc/default/string.md)
  - [Faker::Stripe](doc/default/stripe.md)
  - [Faker::Subscription](doc/default/subscription.md)
  - [Faker::Superhero](doc/default/superhero.md)
  - [Faker::Tea](doc/default/tea.md)
  - [Faker::Team](doc/default/team.md)
  - [Faker::Theater](doc/default/theater.md)
  - [Faker::Time](doc/default/time.md)
  - [Faker::Types](doc/default/types.md)
  - [Faker::University](doc/default/university.md)
  - [Faker::Vehicle](doc/default/vehicle.md)
  - [Faker::Verbs](doc/default/verbs.md)
  - [Faker::VulnerabilityIdentifier](doc/default/vulnerability_identifier.md)
  - [Faker::WorldCup](doc/default/world_cup.md)
  - [Faker::X](doc/default/x.md)
</details>

<details>
  <summary>Blockchain</summary>

  - [Faker::Blockchain::Aeternity](doc/blockchain/aeternity.md)
  - [Faker::Blockchain::Bitcoin](doc/blockchain/bitcoin.md)
  - [Faker::Blockchain::Ethereum](doc/blockchain/ethereum.md)
  - [Faker::Blockchain::Tezos](doc/blockchain/tezos.md)
</details>

<details>
  <summary>Books</summary>

  - [Faker::Book](doc/books/book.md)
  - [Faker::Books::CultureSeries](doc/books/culture_series.md)
  - [Faker::Books::Dune](doc/books/dune.md)
  - [Faker::Books::Lovecraft](doc/books/lovecraft.md)
  - [Faker::Books::TheKingkillerChronicle](doc/books/the_kingkiller_chronicle.md)
</details>

<details>
  <summary>Fantasy</summary>

  - [Faker::Fantasy::Tolkien](doc/fantasy/tolkien.md)
</details>

<details>
  <summary>Travel</summary>

  - [Faker:Travel::Airport](doc/travel/airport.md)
  - [Faker:Travel::TrainStation](doc/travel/train_station.md)
</details>

<details>
  <summary>Creature</summary>

  - [Faker::Creature::Animal](doc/creature/animal.md)
  - [Faker::Creature::Bird](doc/creature/bird.md)
  - [Faker::Creature::Cat](doc/creature/cat.md)
  - [Faker::Creature::Dog](doc/creature/dog.md)
  - [Faker::Creature::Horse](doc/creature/horse.md)
</details>

<details>
  <summary>Games</summary>

  - [Faker::Game](doc/games/game.md)
  - [Faker::Games::ClashOfClans](doc/games/clash_of_clans.md)
  - [Faker::Games::DnD](doc/games/dnd.md)
  - [Faker::Games::Dota](doc/games/dota.md)
  - [Faker::Games::ElderScrolls](doc/games/elder_scrolls.md)
  - [Faker::Games::Fallout](doc/games/fallout.md)
  - [Faker::Games::FinalFantasyXIV](doc/games/final_fantasy_xiv.md)
  - [Faker::Games::HalfLife](doc/games/half_life.md)
  - [Faker::Games::Heroes](doc/games/heroes.md)
  - [Faker::Games::HeroesOfTheStorm](doc/games/heroes_of_the_storm.md)
  - [Faker::Games::LeagueOfLegends](doc/games/league_of_legends.md)
  - [Faker::Games::Minecraft](doc/games/minecraft.md)
  - [Faker::Games::Myst](doc/games/myst.md)
  - [Faker::Games::Overwatch](doc/games/overwatch.md)
  - [Faker::Games::Pokemon](doc/games/pokemon.md)
  - [Faker::Games::SonicTheHedgehog](doc/games/sonic_the_hedgehog.md)
  - [Faker::Games::StreetFighter](doc/games/street_fighter.md)
  - [Faker::Games::SuperMario](doc/games/super_mario.md)
  - [Faker::Games::SuperSmashBros](doc/games/super_smash_bros.md)
  - [Faker::Games::Touhou](doc/games/touhou.md)
  - [Faker::Games::WarhammerFantasy](doc/games/warhammer_fantasy.md)
  - [Faker::Games::Witcher](doc/games/witcher.md)
  - [Faker::Games::WorldOfWarcraft](doc/games/world_of_warcraft.md)
  - [Faker::Games::Zelda](doc/games/zelda.md)
</details>

<details>
  <summary>Japanese Media</summary>

  - [Faker::JapaneseMedia::CowboyBebop](doc/japanese_media/cowboy_bebop.md)
  - [Faker::JapaneseMedia::DragonBall](doc/japanese_media/dragon_ball.md)
  - [Faker::JapaneseMedia::OnePiece](doc/japanese_media/one_piece.md)
  - [Faker::JapaneseMedia::StudioGhibli](doc/japanese_media/studio_ghibli.md)
  - [Faker::JapaneseMedia::SwordArtOnline](doc/japanese_media/sword_art_online.md)
  - [Faker::JapaneseMedia::Naruto](doc/japanese_media/naruto.md)
  - [Faker::JapaneseMedia::Doraemon](doc/japanese_media/doraemon.md)
  - [Faker::JapaneseMedia::Conan](doc/japanese_media/conan.md)
  - [Faker::JapaneseMedia::FullmetalAlchemistBrotherhood](doc/japanese_media/fullmetal_alchemist_brotherhood.md)
</details>

<details>
  <summary>Movies</summary>

  - [Faker::Movie](doc/movies/movie.md)
  - [Faker::Movies::Avatar](doc/movies/avatar.md)
  - [Faker::Movies::BackToTheFuture](doc/movies/back_to_the_future.md)
  - [Faker::Movies::Departed](doc/movies/departed.md)
  - [Faker::Movies::Ghostbusters](doc/movies/ghostbusters.md)
  - [Faker::Movies::HarryPotter](doc/movies/harry_potter.md)
  - [Faker::Movies::HitchhikersGuideToTheGalaxy](doc/movies/hitchhikers_guide_to_the_galaxy.md)
  - [Faker::Movies::Hobbit](doc/movies/hobbit.md)
  - [Faker::Movies::HowToTrainYourDragon](doc/movies/how_to_train_your_dragon.md)
  - [Faker::Movies::Lebowski](doc/movies/lebowski.md)
  - [Faker::Movies::LordOfTheRings](doc/movies/lord_of_the_rings.md)
  - [Faker::Movies::PrincessBride](doc/movies/princess_bride.md)
  - [Faker::Movies::StarWars](doc/movies/star_wars.md)
  - [Faker::Movies::TRON](doc/movies/tron.md)
  - [Faker::Movies::VForVendetta](doc/movies/v_for_vendetta.md)
</details>

<details>
  <summary>Music</summary>

  - [Faker::Music](doc/music/music.md)
  - [Faker::Music::GratefulDead](doc/music/grateful_dead.md)
  - [Faker::Music::Hiphop](doc/music/hiphop.md)
  - [Faker::Music::Opera](doc/music/opera.md)
  - [Faker::Music::PearlJam](doc/music/pearl_jam.md)
  - [Faker::Music::Phish](doc/music/phish.md)
  - [Faker::Music::Prince](doc/music/prince.md)
  - [Faker::Music::RockBand](doc/music/rock_band.md)
  - [Faker::Music::Rush](doc/music/rush.md)
  - [Faker::Music::SmashingPumpkins](doc/music/smashing_pumpkins.md)
  - [Faker::Music::UmphreysMcgee](doc/music/umphreys_mcgee.md)
  - [Faker::Music::BossaNova](doc/music/bossa_nova.md)
</details>

<details>
  <summary>Quotes</summary>

  - [Faker::Quote](doc/quotes/quote.md)
  - [Faker::Quotes::Chiquito](doc/quotes/chiquito.md)
  - [Faker::Quotes::Rajnikanth](doc/quotes/rajnikanth.md)
  - [Faker::Quotes::Shakespeare](doc/quotes/shakespeare.md)
</details>

<details>
  <summary>Sports</summary>

  - [Faker::Sport](doc/sports/sport.md)
  - [Faker::Sports::Basketball](doc/sports/basketball.md)
  - [Faker::Sports::Chess](doc/sports/chess.md)
  - [Faker::Sports::Football](doc/sports/football.md)
  - [Faker::Sports::Mountaineering](doc/sports/mountaineering.md)
  - [Faker::Sports::Volleyball](doc/sports/volleyball.md)
</details>

<details>
  <summary>TV Shows</summary>

  - [Faker::TvShows::AquaTeenHungerForce](doc/tv_shows/aqua_teen_hunger_force.md)
  - [Faker::TvShows::Archer](doc/tv_shows/archer.md)
  - [Faker::TvShows::BigBangTheory](doc/tv_shows/big_bang_theory.md)
  - [Faker::TvShows::BojackHorseman](doc/tv_shows/bojack_horseman.md)
  - [Faker::TvShows::BreakingBad](doc/tv_shows/breaking_bad.md)
  - [Faker::TvShows::BrooklynNineNine](doc/tv_shows/brooklyn_nine_nine.md)
  - [Faker::TvShows::Buffy](doc/tv_shows/buffy.md)
  - [Faker::TvShows::Community](doc/tv_shows/community.md)
  - [Faker::TvShows::DrWho](doc/tv_shows/dr_who.md)
  - [Faker::TvShows::DumbAndDumber](doc/tv_shows/dumb_and_dumber.md)
  - [Faker::TvShows::FamilyGuy](doc/tv_shows/family_guy.md)
  - [Faker::TvShows::FinalSpace](doc/tv_shows/final_space.md)
  - [Faker::TvShows::Friends](doc/tv_shows/friends.md)
  - [Faker::TvShows::GameOfThrones](doc/tv_shows/game_of_thrones.md)
  - [Faker::TvShows::HeyArnold](doc/tv_shows/hey_arnold.md)
  - [Faker::TvShows::HowIMetYourMother](doc/tv_shows/how_i_met_your_mother.md)
  - [Faker::TvShows::MichaelScott](doc/tv_shows/michael_scott.md)
  - [Faker::TvShows::NewGirl](doc/tv_shows/new_girl.md)
  - [Faker::TvShows::ParksAndRec](doc/tv_shows/parks_and_rec.md)
  - [Faker::TvShows::RickAndMorty](doc/tv_shows/rick_and_morty.md)
  - [Faker::TvShows::RuPaul](doc/tv_shows/rupaul.md)
  - [Faker::TvShows::Seinfeld](doc/tv_shows/seinfeld.md)
  - [Faker::TvShows::SiliconValley](doc/tv_shows/silicon_valley.md)
  - [Faker::TvShows::Simpsons](doc/tv_shows/simpsons.md)
  - [Faker::TvShows::SouthPark](doc/tv_shows/south_park.md)
  - [Faker::TvShows::Spongebob](doc/tv_shows/spongebob.md)
  - [Faker::TvShows::StarTrek](doc/tv_shows/star_trek.md)
  - [Faker::TvShows::Stargate](doc/tv_shows/stargate.md)
  - [Faker::TvShows::StrangerThings](doc/tv_shows/stranger_things.md)
  - [Faker::TvShows::Suits](doc/tv_shows/suits.md)
  - [Faker::TvShows::Supernatural](doc/tv_shows/supernatural.md)
  - [Faker::TvShows::TheExpanse](doc/tv_shows/the_expanse.md)
  - [Faker::TvShows::TheFreshPrinceOfBelAir](doc/tv_shows/the_fresh_prince_of_bel_air.md)
  - [Faker::TvShows::TheITCrowd](doc/tv_shows/the_it_crowd.md)
  - [Faker::TvShows::TheThickOfIt](doc/tv_shows/the_thick_of_it.md)
  - [Faker::TvShows::TwinPeaks](doc/tv_shows/twin_peaks.md)
  - [Faker::TvShows::VentureBros](doc/tv_shows/venture_bros.md)
</details>

<details>
  <summary>Locations</summary>

  - [Faker::Locations::Australia](doc/locations/australia.md)
</details>

### A note about the Generators versions

If you get a `uninitialized constant Faker::[some_class]` error, your version of
the gem is behind main.

To make sure that your gem is the one
documented here, change the line in your Gemfile to:

```ruby
gem 'faker', :git => 'https://github.com/faker-ruby/faker.git', :branch => 'main'
```

The generators have the `@faker.version` tag on top of their implementation.
From the tags, you can identify the version the generator was added:

```ruby
# Faker::TvShows::ParksAndRec.character

# @faker.version 1.9.0
def character
  fetch('parks_and_rec.characters')
end
```
