// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"
#include "Rivet/Projections/DecayedParticles.hh"

namespace Rivet {


  /// @brief D+ -> K+K-pi+pi0
  class BESIII_2020_I1808166 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BESIII_2020_I1808166);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      // Initialise and register projections
      UnstableParticles ufs = UnstableParticles(Cuts::abspid==411);
      declare(ufs, "UFS");
      DecayedParticles DD(ufs);
      DD.addStable(PID::PI0);
      DD.addStable(PID::K0S);
      declare(DD, "DD");
      // histograms
      for(unsigned int ix=0;ix<10;++ix) {
	book(_h[ix],1,1,1+ix);
      }
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      static const map<PdgId,unsigned int> & mode   = { {321,1}, {-321,1}, { 211,1}, { 111,1} };
      static const map<PdgId,unsigned int> & modeCC = { {321,1}, {-321,1}, {-211,1}, { 111,1} };
      DecayedParticles DD = apply<DecayedParticles>(event, "DD");
      // loop over particles
      for(unsigned int ix=0;ix<DD.decaying().size();++ix) {
      	int sign = DD.decaying()[ix].pid()/DD.decaying()[ix].abspid();
      	if ( !DD.modeMatches(ix,4,mode) && !DD.modeMatches(ix,4,modeCC)) continue;
	const Particle & Kp  = DD.decayProducts()[ix].at( sign*321)[0];
	const Particle & Km  = DD.decayProducts()[ix].at(-sign*321)[0];
	const Particle & pip = DD.decayProducts()[ix].at( sign*211)[0];
	const Particle & pi0 = DD.decayProducts()[ix].at(      111)[0];
	_h[0]->fill((Kp .momentum()+Km .momentum()).mass());
	_h[1]->fill((Kp .momentum()+pip.momentum()).mass());
	_h[2]->fill((Kp .momentum()+pi0.momentum()).mass());
	_h[3]->fill((Km .momentum()+pip.momentum()).mass());
	_h[4]->fill((Km .momentum()+pi0.momentum()).mass());
	_h[5]->fill((pip.momentum()+pi0.momentum()).mass());
	_h[6]->fill((Kp .momentum()+Km .momentum()+pip.momentum()).mass());
	_h[7]->fill((Kp .momentum()+Km .momentum()+pi0.momentum()).mass());
	_h[8]->fill((Kp .momentum()+pip.momentum()+pi0.momentum()).mass());
	_h[9]->fill((Km .momentum()+pip.momentum()+pi0.momentum()).mass());
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      for(unsigned int ix=0;ix<10;++ix) {
	normalize(_h[ix]);
      }
    }

    /// @}


    /// @name Histograms
    /// @{
    Histo1DPtr _h[10];
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BESIII_2020_I1808166);

}
